/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.core.ILogger;
import org.eclipse.hyades.logging.core.IPreemptedLogger;
import org.eclipse.hyades.logging.core.LoggingAgent;

public class XmlLogger
implements ILogger,
IPreemptedLogger {
    private LoggingAgent loggingAgent;

    public XmlLogger(String string) {
        this.loggingAgent = new LoggingAgent(string);
    }

    public final void finalize() {
        this.loggingAgent.deregister();
    }

    public boolean waitUntilLogging(long l) {
        return this.loggingAgent.waitUntilLogging(l);
    }

    public boolean isLogging() {
        return this.loggingAgent.isLogging();
    }

    public void write(boolean bl) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(bl));
    }

    public void write(char c) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(c));
    }

    public void write(byte by) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(by));
    }

    public void write(short s) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(s));
    }

    public void write(int n) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(n));
    }

    public void write(long l) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(l));
    }

    public void write(float f) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(f));
    }

    public void write(double d) {
        this.loggingAgent.write(XmlGenerator.primitiveToXML(d));
    }

    public void write(Object object) {
        if (object instanceof IExternalizableToXml) {
            this.loggingAgent.write(((IExternalizableToXml)object).externalizeCanonicalXmlString());
        } else {
            XmlGenerator xmlGenerator = new XmlGenerator(this.loggingAgent.getName());
            xmlGenerator.reset(null, false, 4);
            this.loggingAgent.write(xmlGenerator.objectToXML(object));
        }
    }

    public void logErrorMessage(String string, String string2, int n) {
        this.loggingAgent.logErrorMessage(string, string2, n);
    }
}

