/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;

public final class Guid {
    private static final char[] HEXADECIMAL_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final long UTC_OFFSET = 122192928000000000L;
    private static final short GUID_VERSION_1 = 4096;
    private static final byte GUID_RESERVED = -64;
    private static final int MAX_CLOCK_SEQ_ADJUST = 9999;
    private static final long MAX_WAIT_TIME = 1000L;
    private static final Object lockObject = new Object();
    private static boolean _internalsSet = false;
    private static long _lastTimestamp = 0L;
    private static int _clock_seq_adjust = 0;
    private static int _osProcessId = 0;
    private static int _rand_ia = 0;
    private static int _rand_ib = 0;
    private static int _rand_irand = 0;
    private static int _rand_m = 0;
    private static long clockSeq = 0L;
    private int time_low = 0;
    private short time_mid = 0;
    private short time_hi_and_version = 0;
    private byte clock_seq_hi_and_reserved = 0;
    private byte clock_seq_low = 0;
    private static byte[] _ieee802Addr = new byte[6];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Guid() {
        long l = 0L;
        Object object = lockObject;
        synchronized (object) {
            if (!_internalsSet) {
                this.getPseudoIEEE802Address(_ieee802Addr);
                _osProcessId = this.getPseudoOSProcessId();
                this.initTrueRandom(this.getAdjustedTimestamp());
                clockSeq = this.getTrueRandom();
                _internalsSet = true;
            }
            boolean bl = true;
            do {
                if ((l = this.getAdjustedTimestamp()) < _lastTimestamp) {
                    clockSeq = this.getTrueRandom();
                    _clock_seq_adjust = 0;
                }
                if (l > _lastTimestamp) {
                    _clock_seq_adjust = 0;
                }
                if (l != _lastTimestamp) continue;
                if (_clock_seq_adjust < 9999) {
                    ++_clock_seq_adjust;
                    continue;
                }
                bl = false;
            } while (!bl);
            _lastTimestamp = l;
            if (_clock_seq_adjust != 0) {
                l += (long)_clock_seq_adjust;
            }
            long l2 = l & 0xFFFFFFFFFFFFFFFFL;
            this.time_low = (int)l2;
            l2 = l >>> 32 & 0xFFFFL;
            this.time_mid = (short)l2;
            l2 = l >>> 48 & 0xFFFL;
            this.time_hi_and_version = (short)l2;
            this.time_hi_and_version = (short)(this.time_hi_and_version | 0x1000);
            l2 = clockSeq & 0xFFL;
            this.clock_seq_low = (byte)l2;
            l2 = (clockSeq & 0x3F00L) >>> 8;
            this.clock_seq_hi_and_reserved = (byte)l2;
            this.clock_seq_hi_and_reserved = (byte)(this.clock_seq_hi_and_reserved | 0xFFFFFFC0);
        }
    }

    private synchronized void initTrueRandom(long l) {
        _rand_m = 971;
        _rand_ia = 11113;
        _rand_ib = 104322;
        _rand_irand = 4181;
        int n = (int)(l >>> 48) ^ (int)(l >>> 32) ^ (int)(l >>> 16) ^ (int)(l & 0xFFFFL);
        _rand_irand = _rand_irand + n + _osProcessId;
    }

    private synchronized short getTrueRandom() {
        _rand_ia += 1907;
        _rand_ib += 73939;
        if ((_rand_m += 7) >= 9973) {
            _rand_m -= 9871;
        }
        if (_rand_ia >= 99991) {
            _rand_ia -= 89989;
        }
        if (_rand_ib >= 224729) {
            _rand_ib -= 96233;
        }
        _rand_irand = _rand_irand * _rand_m + _rand_ia + _rand_ib;
        _rand_irand = _rand_irand >>> 16 ^ _rand_irand & 0x3FFF;
        return (short)_rand_irand;
    }

    private synchronized int getPseudoOSProcessId() {
        return (int)(this.getUniqueTimeStamp() % 1000000000L);
    }

    private synchronized void getPseudoIEEE802Address(byte[] byArray) {
        byte[] byArray2 = String.valueOf(this.getUniqueTimeStamp()).getBytes();
        byte[] byArray3 = this.getLocalHostAddress();
        byte[] byArray4 = new Object().toString().getBytes();
        byte[] byArray5 = String.valueOf(Runtime.getRuntime().freeMemory()).getBytes();
        byte[] byArray6 = String.valueOf(Runtime.getRuntime().totalMemory()).getBytes();
        byte[] byArray7 = null;
        byte[] byArray8 = new byte[byArray5.length + byArray6.length + byArray2.length + byArray3.length + byArray4.length];
        int n = 0;
        System.arraycopy(byArray2, 0, byArray8, n, byArray2.length);
        System.arraycopy(byArray3, 0, byArray8, n += byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray8, n += byArray3.length, byArray4.length);
        System.arraycopy(byArray5, 0, byArray8, n += byArray4.length, byArray5.length);
        System.arraycopy(byArray6, 0, byArray8, n += byArray5.length, byArray6.length);
        n += byArray6.length;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            byArray7 = messageDigest.digest(byArray8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.arraycopy(byArray7, 0, byArray, 0, 6);
        byArray[0] = (byte)(byArray[0] | 0x80);
    }

    private synchronized byte[] getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return new byte[]{127, 0, 0, 1};
        }
    }

    private synchronized long getAdjustedTimestamp() {
        return System.currentTimeMillis() * 10000L + 122192928000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized long getUniqueTimeStamp() {
        block20: {
            block19: {
                var1_1 = new File(System.getProperty("java.io.tmpdir"), "guid.lock");
                var2_2 = System.currentTimeMillis();
                try {
                    try {
                        block18: {
                            var4_3 = var1_1.lastModified();
                            var6_5 = System.currentTimeMillis() + 1000L;
                            block13: while (true) {
                                try {
                                    while (!var1_1.createNewFile()) {
                                        if (System.currentTimeMillis() <= var6_5) continue;
                                        if (var1_1.lastModified() <= var4_3) {
                                            var1_1.delete();
                                            var4_3 = -1L;
                                            continue;
                                        }
                                        var8_7 = System.currentTimeMillis();
                                        break block13;
                                    }
                                    break block18;
                                }
                                catch (IOException var8_6) {
                                    continue;
                                }
                                break;
                            }
                            var11_9 = null;
                            break block19;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException var8_8) {
                            // empty catch block
                        }
                        var2_2 = System.currentTimeMillis();
                        break block20;
                    }
                    catch (SecurityException var4_4) {
                        var11_11 = null;
                        try {
                            if (var1_1 == null) return var2_2;
                            var1_1.delete();
                            return var2_2;
                        }
                        catch (SecurityException var12_15) {
                            return var2_2;
                        }
                    }
                }
                catch (Throwable var10_17) {
                    var11_12 = null;
                    ** try [egrp 4[TRYBLOCK] [9 : 134->146)] { 
lbl45:
                    // 1 sources

                    if (var1_1 == null) throw var10_17;
                    var1_1.delete();
                    throw var10_17;
lbl49:
                    // 1 sources

                    catch (SecurityException var12_16) {
                        // empty catch block
                    }
                    throw var10_17;
                }
            }
            try {}
            catch (SecurityException var12_13) {
                // empty catch block
                return var8_7;
            }
            if (var1_1 == null) return var8_7;
            var1_1.delete();
            return var8_7;
        }
        var11_10 = null;
        try {}
        catch (SecurityException var12_14) {}
        if (var1_1 == null) return var2_2;
        var1_1.delete();
        return var2_2;
        return var2_2;
    }

    public String toString() {
        char[] cArray = new char[32];
        int n = 0;
        cArray[n++] = HEXADECIMAL_CHARACTERS[this.clock_seq_hi_and_reserved >>> 4 & 0xF];
        cArray[n++] = HEXADECIMAL_CHARACTERS[this.clock_seq_hi_and_reserved & 0xF];
        cArray[n++] = HEXADECIMAL_CHARACTERS[this.clock_seq_low >>> 4 & 0xF];
        cArray[n++] = HEXADECIMAL_CHARACTERS[this.clock_seq_low & 0xF];
        int n2 = 0;
        while (n < 16) {
            cArray[n] = HEXADECIMAL_CHARACTERS[_ieee802Addr[n2] >>> 4 & 0xF];
            cArray[n + 1] = HEXADECIMAL_CHARACTERS[_ieee802Addr[n2] & 0xF];
            ++n2;
            n += 2;
        }
        int n3 = 28;
        while (n < 24) {
            cArray[n] = HEXADECIMAL_CHARACTERS[this.time_low >>> n3 & 0xF];
            n3 -= 4;
            ++n;
        }
        n3 = 12;
        while (n < 28) {
            cArray[n] = HEXADECIMAL_CHARACTERS[this.time_mid >>> n3 & 0xF];
            n3 -= 4;
            ++n;
        }
        n3 = 12;
        while (n < 32) {
            cArray[n] = HEXADECIMAL_CHARACTERS[this.time_hi_and_version >>> n3 & 0xF];
            n3 -= 4;
            ++n;
        }
        return new String(cArray).trim();
    }

    public static String generate() {
        return new Guid().toString();
    }
}

