/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.eclipse.hyades.execution.core.file.IFileLocater;
import org.eclipse.hyades.execution.core.file.IFileLocation;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.local.file.FileLocaterImpl;
import org.eclipse.hyades.internal.execution.file.FileServiceConstants;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.SecureConnectionImpl;

public class FileManagerImpl
extends ExecutionComponentImpl
implements IFileManager {
    private IFileLocater locator;
    private Connection connection;

    public FileManagerImpl(Connection connection) {
        this.locator = new FileLocaterImpl(connection);
        this.connection = connection;
    }

    public void getFile(String localName, String remoteName) throws IOException {
        IFileLocation location = this.locator.getFile(remoteName);
        String directoryName = null;
        File file = new File(localName);
        directoryName = file.getParent();
        File dirFile = new File(directoryName);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        file.createNewFile();
        if (this.connection instanceof SecureConnectionImpl) {
            SecureResourceConnection resourceConnection = new SecureResourceConnection();
            try {
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException e) {}
        } else if (this.connection instanceof ConnectionImpl) {
            ResourceConnection resourceConnection = new ResourceConnection();
            try {
                resourceConnection.setParams(remoteName, 1L);
                resourceConnection.setInputStream(null);
                resourceConnection.setOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException e) {
            }
            catch (FileNotFoundException e1) {
                throw e1;
            }
        }
    }

    public void deleteFile(String absFileName) throws IOException {
        this.locator.deleteFile(absFileName);
    }

    public void putFile(String localName, String remoteName) throws IOException {
        IFileLocation location = this.locator.putFile(remoteName);
        File file = new File(localName);
        if (this.connection instanceof SecureConnectionImpl) {
            SecureResourceConnection resourceConnection = new SecureResourceConnection();
            try {
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException e) {}
        } else if (this.connection instanceof ConnectionImpl) {
            ResourceConnection resourceConnection = new ResourceConnection();
            try {
                resourceConnection.setParams(remoteName, 2L);
                resourceConnection.setInputStream(new BufferedInputStream(new FileInputStream(file)));
                resourceConnection.setOutputStream(null);
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException e) {
                // empty catch block
            }
        }
    }

    class SecureResourceConnection
    extends SecureConnectionImpl {
        SecureResourceConnection() {
        }

        protected void init() {
        }
    }

    class ResourceConnection
    extends ConnectionImpl {
        private FileOutputStream stream;
        private InputStream inStream;
        private OutputStream outStream;
        private String fileName;
        private long operation;

        ResourceConnection() {
        }

        protected void init() {
            try {
                this._socket.setSoTimeout(1000);
                this._socket.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            new SocketReader().run();
        }

        public void setStream(FileOutputStream stream) {
            this.stream = stream;
        }

        public void setInputStream(InputStream in) {
            this.inStream = in;
        }

        public void setOutputStream(OutputStream out) {
            this.outStream = out;
        }

        public void setParams(String fileName, long operation) {
            this.fileName = fileName;
            this.operation = operation;
        }

        class SocketReader
        implements Runnable,
        FileServiceConstants,
        Constants {
            private boolean _isComplete = false;
            private byte[] buffer = new byte[1024];
            private long byteCount = 0L;

            SocketReader() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        byte[] tempFileName = ResourceConnection.this.fileName.getBytes("UTF-8");
                        OutputStream os = ResourceConnection.this._socket.getOutputStream();
                        long len = ResourceConnection.this.fileName.length();
                        int offset = 0;
                        offset = Message.writeRALongToBuffer(this.buffer, 0, ResourceConnection.this.operation);
                        offset = Message.writeRALongToBuffer(this.buffer, offset, len);
                        System.arraycopy(tempFileName, 0, this.buffer, offset, ResourceConnection.this.fileName.length());
                        os.write(this.buffer);
                        if (ResourceConnection.this.inStream == null) {
                            ResourceConnection.this.inStream = ResourceConnection.this._socket.getInputStream();
                        }
                        if (ResourceConnection.this.outStream == null) {
                            ResourceConnection.this.outStream = ResourceConnection.this._socket.getOutputStream();
                        }
                        while (!this._isComplete) {
                            try {
                                int bytesRead = ResourceConnection.this.inStream.read(this.buffer);
                                if (bytesRead == -1) {
                                    if (this.byteCount <= 0L) break;
                                    InputStream in = ResourceConnection.this._socket.getInputStream();
                                    int result = in.read();
                                    in.close();
                                    if (result == -1) break;
                                    throw new IOException();
                                }
                                this.byteCount += (long)bytesRead;
                                ResourceConnection.this.outStream.write(this.buffer, 0, bytesRead);
                            }
                            catch (InterruptedIOException e) {}
                        }
                        Object var10_10 = null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    ResourceConnection.this.disconnect();
                    try {
                        ResourceConnection.this.outStream.close();
                        ResourceConnection.this.inStream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                ResourceConnection.this.disconnect();
                try {}
                catch (IOException e) {}
                ResourceConnection.this.outStream.close();
                ResourceConnection.this.inStream.close();
                return;
            }
        }
    }
}

