/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    protected IExtensionRegistry pluginRegistry;
    String pluginID;
    String extensionPointID;

    public RegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
        this.pluginRegistry = pluginRegistry;
        this.pluginID = pluginID;
        this.extensionPointID = extensionPointID;
    }

    abstract boolean readElement(IConfigurationElement var1);

    public void readRegistry() {
        IExtensionPoint point = this.pluginRegistry.getExtensionPoint(this.pluginID, this.extensionPointID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.internalReadElement(elements[i]);
                ++i;
            }
        }
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (recognized) {
            IConfigurationElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.internalReadElement(children[i]);
                ++i;
            }
        } else {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        System.err.println("Plugin " + extension.getNamespace() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        System.err.println(text);
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "The required attribute '" + attributeName + "' not defined");
    }

    static class PluginClassDescriptor {
        protected IConfigurationElement element;
        protected String attributeName;

        public PluginClassDescriptor(IConfigurationElement element, String attributeName) {
            this.element = element;
            this.attributeName = attributeName;
        }

        public Object createInstance() {
            try {
                return this.element.createExecutableExtension(this.attributeName);
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
    }

    static class ResourceFactoryDescriptor
    extends PluginClassDescriptor
    implements Resource.Factory.Descriptor {
        protected Resource.Factory factoryInstance;

        public ResourceFactoryDescriptor(IConfigurationElement e, String attrName) {
            super(e, attrName);
        }

        public Resource.Factory createFactory() {
            if (this.factoryInstance == null) {
                this.factoryInstance = (Resource.Factory)this.createInstance();
            }
            return this.factoryInstance;
        }
    }

    static class EPackageDescriptor
    extends PluginClassDescriptor
    implements EPackage.Descriptor {
        public EPackageDescriptor(IConfigurationElement element, String attributeName) {
            super(element, attributeName);
        }

        public EPackage getEPackage() {
            try {
                Class javaClass = Platform.getBundle((String)this.element.getDeclaringExtension().getNamespace()).loadClass(this.element.getAttribute(this.attributeName));
                Field field = javaClass.getField("eINSTANCE");
                Object result = field.get(null);
                return (EPackage)result;
            }
            catch (ClassNotFoundException e) {
                throw new WrappedException(e);
            }
            catch (IllegalAccessException e) {
                throw new WrappedException(e);
            }
            catch (NoSuchFieldException e) {
                throw new WrappedException(e);
            }
        }
    }
}

