/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.workloadcontroller;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.workloadcontroller.IWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadResource;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WorkloadController {
    public static final int DEFAULT_QUIESCE_TIMEOUT = 180;
    public static final String QUIESCE_TIMEOUT_PROP_NAME = "com.ibm.ejs.sm.server.quiesceTimeout";
    public static final int DEFAULT_QUIESCE_INACTIVE_REQUEST_TIME = 5000;
    public static final String QUIESCE_INACTIVE_REQUEST_TIME_PROP_NAME = "com.ibm.ejs.sm.server.quiesceInactiveRequestTime";
    private Hashtable _regulators = new Hashtable();
    private Vector _resources = new Vector();
    private boolean _fQuiesce = false;
    private boolean _fStarting = false;
    private boolean _fStarted = true;
    private boolean _fQuiesceComplete = false;
    private static WorkloadController _theInstance = null;
    private static TraceComponent tc = Tr.register((Class)WorkloadController.class);

    private WorkloadController() {
    }

    public static WorkloadController getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance");
        }
        if (_theInstance == null) {
            WorkloadController.create();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInstance");
        }
        return _theInstance;
    }

    public static synchronized void registerResource(WorkloadResource workloadResource) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerResource: " + workloadResource.getName()));
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        workloadController._resources.add(workloadResource);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerResource");
        }
    }

    public static synchronized void registerRegulator(IWorkloadRegulator iWorkloadRegulator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("registerRegulator: " + iWorkloadRegulator.getName()));
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        workloadController._regulators.put(iWorkloadRegulator.getName(), iWorkloadRegulator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerRegulator");
        }
    }

    public static synchronized void registerRegulator(WorkloadRegulator workloadRegulator) {
        WorkloadController.registerRegulator((IWorkloadRegulator)workloadRegulator);
    }

    public static IWorkloadRegulator getRegulator(String string) {
        return (IWorkloadRegulator)WorkloadController.getInstance()._regulators.get(string);
    }

    public static boolean quiesce(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("quiesce: timeout=" + n));
        }
        boolean bl = false;
        if (n == 0) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"quiesce: quiesce timeout value = 0 - do not quiesce, just shutdown");
            }
            bl = WorkloadController.quiesceCompleteWorkloads(-1);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("quiesce: quiesceCompleteWorkloads= " + bl));
            }
            return bl;
        }
        bl = WorkloadController.quiesceWorkloads(-1, n);
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)tc, (String)("quiesce: workload quiesced=" + bl));
        }
        bl = WorkloadController.quiesceCompleteWorkloads(-1);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("quiesce: quiesceCompleteWorkloads= " + bl));
        }
        return bl;
    }

    public static boolean inQuiesceMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inQuiesceMode");
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("inQuiesceMode: " + workloadController._fQuiesce));
        }
        return workloadController._fQuiesce;
    }

    protected static boolean quiesceWorkloads(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("quiesceWorkloads: typeMask=" + n + " timeout=" + n2));
        }
        long l = n2 * 1000;
        long l2 = System.currentTimeMillis();
        WorkloadController workloadController = WorkloadController.getInstance();
        workloadController._fQuiesce = true;
        workloadController._fStarting = false;
        workloadController._fStarted = false;
        workloadController._fQuiesceComplete = false;
        boolean bl = false;
        while (System.currentTimeMillis() < l2 + l && !bl) {
            bl = true;
            Enumeration enumeration = workloadController._regulators.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                IWorkloadRegulator iWorkloadRegulator = (IWorkloadRegulator)workloadController._regulators.get(string);
                if (iWorkloadRegulator == null) continue;
                if ((n & iWorkloadRegulator.getType()) == iWorkloadRegulator.getType()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("quiesceWorkloads: will attempt to quiesce " + iWorkloadRegulator.getName()));
                    }
                    bl = iWorkloadRegulator.quiesce() && bl;
                    continue;
                }
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("quiesceWorkloads: will NOT attempt to quiesce " + iWorkloadRegulator.getName()));
            }
            WorkloadController.shortSleep(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("quiesceWorkloads: fQuiesced=" + bl + " stop time=" + System.currentTimeMillis()));
        }
        return bl;
    }

    public static boolean quiesceResources(int n) {
        WorkloadResource workloadResource;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("quiesceResources: timeout=" + n));
        }
        long l = n * 1000;
        long l2 = System.currentTimeMillis();
        WorkloadController workloadController = WorkloadController.getInstance();
        workloadController._fQuiesce = true;
        boolean bl = false;
        while (System.currentTimeMillis() < l2 + l && !bl) {
            bl = true;
            for (n2 = 0; n2 < workloadController._resources.size(); ++n2) {
                workloadResource = (WorkloadResource)workloadController._resources.get(n2);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("quiesceResources: Checking for quiesced state of " + workloadResource.toString()));
                }
                bl = workloadResource.isQuiesced() && bl;
            }
            WorkloadController.shortSleep(bl);
        }
        for (n2 = 0; n2 < workloadController._resources.size(); ++n2) {
            workloadResource = (WorkloadResource)workloadController._resources.get(n2);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("quiesceResources: Forcing quiesced state of " + workloadResource.toString()));
            }
            if (workloadResource.isQuiesced()) continue;
            workloadResource.quiesce();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("quiesceResources: fQuiesce=" + bl));
        }
        return bl;
    }

    protected static boolean quiesceCompleteWorkloads(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("quiesceCompleteWorkloads: typeMask= " + n));
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        workloadController._fStarting = false;
        workloadController._fStarted = false;
        workloadController._fQuiesce = false;
        workloadController._fQuiesceComplete = true;
        boolean bl = true;
        Enumeration enumeration = workloadController._regulators.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IWorkloadRegulator iWorkloadRegulator = (IWorkloadRegulator)workloadController._regulators.get(string);
            if (iWorkloadRegulator == null) continue;
            if ((n & iWorkloadRegulator.getType()) == iWorkloadRegulator.getType()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("quiesceCompleteWorkloads: will notify regulator " + iWorkloadRegulator.getName()));
                }
                bl = iWorkloadRegulator.quiesceComplete() && bl;
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event((TraceComponent)tc, (String)("quiesceCompleteWorkloads: will NOT notify regulator " + iWorkloadRegulator.getName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("quiesceCompleteWorkloads: fQuiesceComplete= " + bl));
        }
        return bl;
    }

    public static boolean inQuiesceCompleteMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inQuiesceCompleteMode ");
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("inQuiesceCompleteMode: " + workloadController._fQuiesceComplete));
        }
        return workloadController._fQuiesceComplete;
    }

    public static boolean starting() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"starting");
        }
        boolean bl = false;
        bl = WorkloadController.startingWorkloads(-1);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("starting " + bl));
        }
        return bl;
    }

    protected static boolean startingWorkloads(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startingWorkloads: typeMask= " + n));
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        workloadController._fStarting = true;
        workloadController._fStarted = false;
        workloadController._fQuiesce = false;
        workloadController._fQuiesceComplete = false;
        boolean bl = true;
        Enumeration enumeration = workloadController._regulators.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IWorkloadRegulator iWorkloadRegulator = (IWorkloadRegulator)workloadController._regulators.get(string);
            if (iWorkloadRegulator == null) continue;
            if ((n & iWorkloadRegulator.getType()) == iWorkloadRegulator.getType()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("startingWorkloads: will notify regulator " + iWorkloadRegulator.getName()));
                }
                bl = iWorkloadRegulator.starting() && bl;
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event((TraceComponent)tc, (String)("startingWorkloads: will NOT notify regulator " + iWorkloadRegulator.getName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("startingWorkloads: fStarting= " + bl));
        }
        return bl;
    }

    public static boolean inStartingMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inStartingMode ");
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("inStartingMode: " + workloadController._fStarting));
        }
        return workloadController._fStarting;
    }

    public static boolean started() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"started");
        }
        boolean bl = false;
        bl = WorkloadController.startedWorkloads(-1);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("started " + bl));
        }
        return bl;
    }

    protected static boolean startedWorkloads(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startedWorkloads: typeMask=" + n));
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        workloadController._fStarting = false;
        workloadController._fStarted = false;
        workloadController._fQuiesce = false;
        workloadController._fQuiesceComplete = false;
        boolean bl = true;
        Enumeration enumeration = workloadController._regulators.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IWorkloadRegulator iWorkloadRegulator = (IWorkloadRegulator)workloadController._regulators.get(string);
            if (iWorkloadRegulator == null) continue;
            if ((n & iWorkloadRegulator.getType()) == iWorkloadRegulator.getType()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("startedWorkloads: will notify regulator " + iWorkloadRegulator.getName()));
                }
                bl = iWorkloadRegulator.started() && bl;
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event((TraceComponent)tc, (String)("startedWorkloads: will NOT notify regulator " + iWorkloadRegulator.getName()));
        }
        workloadController._fStarted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("startedWorkloads: fStarted=" + bl));
        }
        return bl;
    }

    public static boolean inStartedMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inStartedMode");
        }
        WorkloadController workloadController = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("inStartedMode: " + workloadController._fStarted));
        }
        return workloadController._fStarted;
    }

    protected static synchronized void create() {
        _theInstance = new WorkloadController();
    }

    protected static void shortSleep(boolean bl) {
        if (!bl) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.runtime.workloadcontroller.WorkloadController.shortSleep", (String)"714");
            }
        }
    }
}

