/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.mbean;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.LogRecordRasMessageAdapter;
import com.ibm.ws.logging.WsHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;

public class RasLoggingServiceMBean
extends RuntimeCollaborator
implements WsHandler {
    public static final String NOTIFICATION_LOG_FATAL = "websphere.ras.fatal";
    public static final String NOTIFICATION_LOG_ERROR = "websphere.ras.error";
    public static final String NOTIFICATION_LOG_WARNING = "websphere.ras.warning";
    public static final String NOTIFICATION_LOG_AUDIT = "websphere.ras.audit";
    public static final String NOTIFICATION_LOG_SERVICE = "websphere.ras.service";
    public static final String NOTIFICATION_LOG_INFO = "websphere.ras.info";
    private long ntfySeqNum = 0L;
    private static boolean registered = false;

    public void setObjectName(ObjectName objectName) {
        super.setObjectName(objectName);
        RasLoggingServiceMBean.registerWithRas(this);
    }

    public String getMessageFilterLevel() {
        return ManagerAdmin.getMessageFilterLevel();
    }

    public void setMessageFilterLevel(String string) {
        ManagerAdmin.setMessageFilterLevel((String)string);
    }

    public Level getLevel() {
        return WsLevel.DETAIL;
    }

    public void processEvent(LogRecord logRecord) {
        int n = logRecord.getLevel().intValue();
        if (n < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[15]]) {
            this.sendEvent(NOTIFICATION_LOG_FATAL, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]]) {
            this.sendEvent(NOTIFICATION_LOG_ERROR, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]]) {
            this.sendEvent(NOTIFICATION_LOG_WARNING, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[11]]) {
            this.sendEvent(NOTIFICATION_LOG_AUDIT, logRecord);
        } else {
            this.sendEvent(NOTIFICATION_LOG_INFO, logRecord);
        }
    }

    private static synchronized void registerWithRas(RasLoggingServiceMBean rasLoggingServiceMBean) {
        if (registered) {
            return;
        }
        try {
            ManagerAdmin.addJmxListener((WsHandler)rasLoggingServiceMBean);
            registered = true;
        }
        catch (RasException rasException) {
            FFDCFilter.processException((Throwable)rasException, (String)"com.ibm.ws.management.RasLoggingServiceMBean.registerWithRas", (String)"193", (Object)((Object)rasLoggingServiceMBean));
        }
    }

    private void sendEvent(String string, LogRecord logRecord) {
        try {
            LogRecordRasMessageAdapter logRecordRasMessageAdapter = new LogRecordRasMessageAdapter(logRecord);
            Notification notification = new Notification(string, this.getObjectName(), this.ntfySeqNum++);
            notification.setUserData(logRecordRasMessageAdapter);
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.RasLoggingServiceMBean.sendEvent", (String)"203", (Object)((Object)this));
        }
    }
}

