/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.jms.JMSConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.runtime.component.binder.J2CBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.component.collaborator.JMSResourceMBean;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import java.util.Properties;

public abstract class JMSBinder
extends J2CBinder {
    protected static boolean mqTraceInitialised = false;
    private static TraceComponent tc = Tr.register((Class)JMSBinder.class, (String)"ResourceBinders", (String)"com.ibm.ejs.jms.messaging");
    private static Boolean baseServer = null;
    protected static boolean mqDisabled = false;
    protected static boolean mqExistenceTested = false;
    protected boolean wasUsed = false;
    protected boolean mqUsed = false;

    protected void addJMSServerProperties(Properties properties, String string) throws ResourceBindingException {
        if (string == null) {
            throw new ResourceBindingException("No node name property set for resource");
        }
        EndPointMgr.NodeEndPoints nodeEndPoints = null;
        EndPoint endPoint = null;
        EndPoint endPoint2 = null;
        String string2 = null;
        Integer n = null;
        Integer n2 = null;
        try {
            EndPointMgr endPointMgr = (EndPointMgr)this.getService(EndPointMgr.class);
            if (endPointMgr != null) {
                EndPointMgr.ServerEndPoints serverEndPoints;
                nodeEndPoints = endPointMgr.getNodeEndPoints(string);
                this.releaseService(endPointMgr);
                if (nodeEndPoints != null && (serverEndPoints = nodeEndPoints.getServerEndPoints(JMSBinder.isBaseServer() ? "@" : "jmsserver")) != null) {
                    endPoint = serverEndPoints.getEndPoint("JMSSERVER_DIRECT_ADDRESS");
                    endPoint2 = serverEndPoints.getEndPoint("JMSSERVER_QUEUED_ADDRESS");
                }
                if (endPoint != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("JMSServer direct endpoint: " + endPoint.getHost() + ":" + endPoint.getPort()));
                    }
                    string2 = endPoint.getHost();
                    n = new Integer(endPoint.getPort());
                }
                if (endPoint2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("JMSServer queued endpoint: " + endPoint2.getHost() + ":" + endPoint2.getPort()));
                    }
                    if (string2 == null) {
                        string2 = endPoint2.getHost();
                    }
                    n2 = new Integer(endPoint2.getPort());
                }
            }
        }
        catch (Throwable throwable) {
            Tr.audit((TraceComponent)tc, (String)"Exception reading node endpoints", (Object)throwable);
        }
        if (string2 == null || string2.equals("")) {
            string2 = "localhost";
        }
        if (n2 == null) {
            n2 = new Integer(5558);
        }
        if (n == null) {
            n = new Integer(5559);
        }
        this.setProperty(properties, "NODH", string2, true);
        this.setProperty(properties, "QUEUEDPORT", n2.toString(), true);
        this.setProperty(properties, "DIRECTPORT", n.toString(), true);
    }

    public String getNamePrefix() {
        return "jms";
    }

    public void activateProviderMBean(J2EEResourceProvider j2EEResourceProvider, String string) {
        new JMSResourceMBean((JMSProvider)j2EEResourceProvider, string);
    }

    protected void checkRequiredProperty(String string, String string2, Object object) throws ResourceBindingException {
        this.checkRequiredProperty(object, "Invalid Configuration! The JMS Resource: " + string + " has a null " + string2 + " property.");
    }

    protected static void testForMqInstallation() {
        if (!mqExistenceTested) {
            mqExistenceTested = true;
            try {
                mqDisabled = false;
                Class.forName("com.ibm.mq.jms.admin.AdminObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.event((TraceComponent)tc, (String)"MQ and WAS Binders disabled as JMS client not installed");
                mqDisabled = true;
            }
        }
    }

    protected void setAuthenticationProperties(JMSConnectionFactory jMSConnectionFactory, Properties properties) {
        AuthDataCredential authDataCredential;
        String string;
        block4: {
            string = jMSConnectionFactory.getAuthDataAlias();
            try {
                authDataCredential = WSDefaultPrincipalMapping.getAuthData((String)string);
                if (authDataCredential != null) {
                    this.setProperty(properties, "UserName", authDataCredential.getUserName(), true);
                    this.setProperty(properties, "Password", authDataCredential.getPassword(), true);
                }
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)("Failed to get auth data for alias " + string), (Object)exception);
            }
        }
        this.setProperty(properties, "OptionC_authDataAlias", string, true);
        authDataCredential = jMSConnectionFactory.getMapping();
        if (authDataCredential != null) {
            this.setProperty(properties, "mappingConfigAlias", authDataCredential.getMappingConfigAlias(), true);
            this.setProperty(properties, "authDataAlias", authDataCredential.getAuthDataAlias(), true);
        }
    }

    private static boolean isBaseServer() {
        if (baseServer == null) {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string = adminService.getProcessType();
            baseServer = string.equals("UnManagedProcess") ? Boolean.TRUE : Boolean.FALSE;
        }
        return baseServer;
    }
}

