/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.javascript;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.BSFFunctions;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class JavaScriptEngine
extends BSFEngineImpl {
    private Scriptable global;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        Object object2 = null;
        try {
            Context context = Context.enter();
            Object object3 = this.global.get(string, this.global);
            if (object3 == Scriptable.NOT_FOUND) {
                throw new EvaluatorException("function " + string + " not found.");
            }
            context.setOptimizationLevel(-1);
            context.setGeneratingDebug(false);
            context.setGeneratingSource(false);
            context.setOptimizationLevel(0);
            object2 = ScriptRuntime.call((Context)context, (Object)object3, (Object)this.global, (Object[])objectArray, null);
            if (object2 instanceof Wrapper) {
                object2 = ((Wrapper)object2).unwrap();
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        finally {
            Context.exit();
        }
        return object2;
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (bSFDeclaredBean.bean instanceof Number || bSFDeclaredBean.bean instanceof String || bSFDeclaredBean.bean instanceof Boolean) {
            this.global.put(bSFDeclaredBean.name, this.global, bSFDeclaredBean.bean);
        } else {
            Scriptable scriptable = Context.toObject((Object)bSFDeclaredBean.bean, (Scriptable)this.global);
            this.global.put(bSFDeclaredBean.name, this.global, (Object)scriptable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        String string2 = object.toString();
        Object object2 = null;
        try {
            Context context = Context.enter();
            context.setOptimizationLevel(-1);
            context.setGeneratingDebug(false);
            context.setGeneratingSource(false);
            context.setOptimizationLevel(0);
            object2 = context.evaluateString(this.global, string2, string, n, null);
            if (object2 instanceof NativeJavaObject) {
                object2 = ((NativeJavaObject)object2).unwrap();
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        finally {
            Context.exit();
        }
        return object2;
    }

    private void handleError(Throwable throwable) throws BSFException {
        if (throwable instanceof WrappedException) {
            throwable = ((WrappedException)throwable).getWrappedException();
        }
        String string = null;
        Throwable throwable2 = throwable;
        if (throwable instanceof JavaScriptException) {
            string = throwable.getLocalizedMessage();
            Object object = ((JavaScriptException)throwable).getValue();
            if (object instanceof Throwable) {
                throwable2 = (Throwable)object;
            }
        } else if (throwable instanceof EvaluatorException || throwable instanceof SecurityException) {
            string = throwable.getLocalizedMessage();
        } else if (throwable instanceof RuntimeException) {
            string = "Internal Error: " + throwable.toString();
        } else if (throwable instanceof StackOverflowError) {
            string = "Stack Overflow";
        }
        if (string == null) {
            string = throwable.toString();
        }
        if (throwable instanceof Error && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, "JavaScript Error: " + string, throwable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        try {
            Context context = Context.enter();
            this.global = new ImporterTopLevel(context);
            Scriptable scriptable = Context.toObject((Object)new BSFFunctions(bSFManager, this), (Scriptable)this.global);
            this.global.put("bsf", this.global, (Object)scriptable);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.declareBean((BSFDeclaredBean)vector.elementAt(i));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            Context.exit();
        }
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.global.delete(bSFDeclaredBean.name);
    }
}

