/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca.util;

import com.ibm.wsdl.extensions.format.TypeMapping;
import com.ibm.wsif.format.WSIFFormatHandler;
import com.ibm.wsif.jca.log.JCAResource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.cci.ConnectionFactory;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public class JCAUtil {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2002, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final long serialVersionUID = 5L;
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String FORMAT_HANDLER = "FormatHandler";
    private static final String ELEMENT_FORMAT_HANDLER = "ElementFormatHandler";
    private static final String PHYSICALREP = "physicalrep/";
    private static final String FORMATBINDING = "formatbinding/";
    private static final String XMLSEPARATORS = "-.:_\u00b7\u0387\u06dd\u06de";
    private static final String lookupPrefix = "java:comp/env/";
    private static final String emptyString = "";

    public static WSIFFormatHandler getFormatHandler(Part part, Definition definition, Binding binding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string;
        WSIFFormatHandler wSIFFormatHandler = null;
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = part.getElementName();
        }
        if (qName == null) {
            throw new ClassNotFoundException(part.getName());
        }
        String string2 = string = JCAUtil.getPackageNameFromNamespaceURI(qName.getNamespaceURI());
        String string3 = JCAUtil.getPackageNameFromXMLName(definition.getPrefix(JCAUtil.getBindingNamespace(binding)));
        if (string3 != null) {
            string2 = string2 + DOT + string3;
        }
        if (JCAUtil.getFormatStylePackage(binding) != null) {
            string2 = string2 + DOT + JCAUtil.getFormatStylePackage(binding);
        }
        String string4 = string2 + DOT + JCAUtil.getJavaClassNameFromXMLName(qName.getLocalPart());
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            wSIFFormatHandler = (WSIFFormatHandler)classLoader.loadClass(string4 + FORMAT_HANDLER).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                wSIFFormatHandler = (WSIFFormatHandler)classLoader.loadClass(string4 + ELEMENT_FORMAT_HANDLER).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    wSIFFormatHandler = (WSIFFormatHandler)Class.forName(string4 + FORMAT_HANDLER).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    try {
                        wSIFFormatHandler = (WSIFFormatHandler)Class.forName(string4 + ELEMENT_FORMAT_HANDLER).newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException4) {
                        throw new ClassNotFoundException(JCAResource.get("IWAA0101E", string2));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new ClassNotFoundException(JCAResource.get("IWAA0102E", string2, throwable.getLocalizedMessage()));
        }
        if (wSIFFormatHandler == null) {
            throw new ClassNotFoundException(JCAResource.get("IWAA0101E", string2));
        }
        return wSIFFormatHandler;
    }

    public static String getJNDILookupName(Service service, Port port) {
        String string = JCAUtil.getPackageNameFromNamespaceURI(service.getQName().getNamespaceURI());
        if (!string.endsWith(DOT)) {
            string = string + DOT;
        }
        string = string.replace('.', '/');
        string = string + JCAUtil.getJavaNameFromXMLName(service.getQName().getLocalPart());
        string = string + JCAUtil.getJavaNameFromXMLName(port.getName());
        return string;
    }

    public static String getPackageNameFromNamespaceURI(String string) {
        List list = JCAUtil.getNamespaceURISegments(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            String string2;
            if (n == 0) {
                string2 = JCAUtil.getPackageNameFromXMLName((String)list.get(n));
                StringTokenizer stringTokenizer = new StringTokenizer(string2, DOT);
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(0, stringTokenizer.nextToken());
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    if (stringBuffer2.length() != 0) {
                        stringBuffer2.append('.');
                    }
                    if (!Character.isJavaIdentifierStart((string3 = (String)iterator.next()).toCharArray()[0])) {
                        string3 = "_" + string3;
                    }
                    stringBuffer2.append(string3);
                }
                string2 = stringBuffer2.toString();
            } else {
                string2 = JCAUtil.getJavaNameFromXMLName((String)list.get(n));
                if (!Character.isJavaIdentifierStart(string2.toCharArray()[0])) {
                    string2 = "_" + string2;
                }
            }
            if (string2.length() != 0) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getJavaNameFromXMLName(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        String string3 = stringBuffer.toString();
        if (!Character.isJavaIdentifierStart(string3.toCharArray()[0])) {
            string3 = "_" + string3;
        }
        return string3;
    }

    public static String getJavaNameFromXMLName(String string) {
        return JCAUtil.getJavaNameFromXMLName(string, XMLSEPARATORS);
    }

    public static String getPackageNameFromXMLName(String string) {
        String string2 = JCAUtil.getJavaNameFromXMLName(string, "-:_\u00b7\u0387\u06dd\u06de");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DOT);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            if (!Character.isJavaIdentifierStart((string3 = stringTokenizer.nextToken()).toCharArray()[0])) {
                string3 = "_" + string3;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static List getNamespaceURISegments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (!arrayList.isEmpty()) {
            try {
                URL uRL = new URL(string);
                if (arrayList.get(0).equals(uRL.getProtocol())) {
                    arrayList.remove(0);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static String getBindingNamespace(Binding binding) {
        Iterator iterator = binding.getExtensibilityElements().iterator();
        String string = null;
        while (iterator.hasNext()) {
            String string2;
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (string != null || (string2 = extensibilityElement.getElementType().getNamespaceURI()).endsWith(PHYSICALREP) || string2.endsWith(FORMATBINDING)) continue;
            string = string2;
        }
        return string;
    }

    public static String getFormatStylePackage(Binding binding) {
        Iterator iterator = binding.getExtensibilityElements().iterator();
        String string = null;
        while (iterator.hasNext()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (extensibilityElement instanceof TypeMapping) {
                TypeMapping typeMapping = (TypeMapping)extensibilityElement;
                string = typeMapping.getEncoding();
                if (typeMapping.getStyle() != null) {
                    string = string + typeMapping.getStyle();
                }
            }
            if (string != null) break;
        }
        if (string != null) {
            return JCAUtil.getPackageNameFromXMLName(string);
        }
        return string;
    }

    public static String getFormatHandlerName(Part part, Definition definition, Binding binding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string;
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = part.getElementName();
        }
        if (qName == null) {
            throw new ClassNotFoundException(part.getName());
        }
        String string2 = string = JCAUtil.getPackageNameFromNamespaceURI(qName.getNamespaceURI());
        String string3 = JCAUtil.getPackageNameFromXMLName(definition.getPrefix(JCAUtil.getBindingNamespace(binding)));
        if (string3 != null) {
            string2 = string2 + DOT + string3;
        }
        if (JCAUtil.getFormatStylePackage(binding) != null) {
            string2 = string2 + DOT + JCAUtil.getFormatStylePackage(binding);
        }
        string2 = string2 + DOT + JCAUtil.getJavaClassNameFromXMLName(qName.getLocalPart()) + FORMAT_HANDLER;
        return string2;
    }

    public static ConnectionFactory lookupConnectionFactory(String string, String string2) {
        ConnectionFactory connectionFactory = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            if (initialContext == null) {
                return null;
            }
            connectionFactory = (ConnectionFactory)initialContext.lookup(lookupPrefix + string);
            if (connectionFactory == null) {
                throw new NamingException();
            }
            try {
                if (!Class.forName(string2).isInstance(connectionFactory)) {
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            initialContext.close();
        }
        catch (NamingException namingException) {
            try {
                if (initialContext == null) {
                    return null;
                }
                connectionFactory = (ConnectionFactory)initialContext.lookup(string);
                if (connectionFactory == null) {
                    return null;
                }
                try {
                    if (!Class.forName(string2).isInstance(connectionFactory)) {
                        return null;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                initialContext.close();
            }
            catch (NamingException namingException2) {
                return null;
            }
        }
        return connectionFactory;
    }

    public static String getJavaClassNameFromXMLName(String string) {
        return JCAUtil.getJavaClassNameFromXMLName(string, XMLSEPARATORS);
    }

    public static String getJavaClassNameFromXMLName(String string, String string2) {
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.length() > 0) {
                string3 = Character.toUpperCase(string3.toCharArray()[0]) + string3.substring(1);
            }
            stringBuffer.append(string3);
        }
        string3 = stringBuffer.toString();
        if (!Character.isJavaIdentifierStart(string3.toCharArray()[0])) {
            string3 = "_" + string3;
        }
        return string3;
    }
}

