/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca.screenable;

import com.ibm.connector2.screen.BuildFieldException;
import com.ibm.connector2.screen.FieldProtectedException;
import com.ibm.connector2.screen.FieldTextOverflowException;
import com.ibm.connector2.screen.IFieldAttrInfo;
import com.ibm.connector2.screen.ITextAttrInfo;
import com.ibm.connector2.screen.ScreenException;
import com.ibm.wsif.jca.screenable.FieldPaddingException;
import com.ibm.wsif.jca.screenable.FieldRecord;
import com.ibm.wsif.jca.screenable.IPaddedFieldType;

public class CustomFieldRecord
extends FieldRecord
implements IPaddedFieldType {
    private static String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private char padCharacter_;
    private int padPolicy_;
    private static final long serialVersionUID = 5L;

    protected CustomFieldRecord() {
    }

    public CustomFieldRecord(String string, int n, int n2, int n3, String string2, int n4, IFieldAttrInfo iFieldAttrInfo, ITextAttrInfo iTextAttrInfo) throws BuildFieldException {
        super(string, n, n2, n3, string2, n4, iFieldAttrInfo, iTextAttrInfo);
        this.padCharacter_ = (char)32;
        this.padPolicy_ = 0;
    }

    public CustomFieldRecord(String string, int n, int n2, int n3, String string2, int n4, IFieldAttrInfo iFieldAttrInfo, ITextAttrInfo iTextAttrInfo, char c, int n5) throws BuildFieldException {
        super(string, n, n2, n3, string2, n4, iFieldAttrInfo, iTextAttrInfo);
        this.padCharacter_ = c;
        if (n5 != 3 && n5 != 2 && n5 != 1 && n5 != 0) {
            throw new BuildFieldException();
        }
        this.padPolicy_ = n5;
    }

    public Object clone() throws CloneNotSupportedException {
        CustomFieldRecord customFieldRecord = (CustomFieldRecord)super.clone();
        return customFieldRecord;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof CustomFieldRecord)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CustomFieldRecord customFieldRecord = (CustomFieldRecord)object;
        if (this.padCharacter_ != customFieldRecord.getPaddingCharacter()) {
            return false;
        }
        return this.padPolicy_ == customFieldRecord.getPaddingPolicy();
    }

    private static String extractText(String string, int n, char c) throws FieldPaddingException {
        int[] nArray = CustomFieldRecord.numberOfPadsToBeRemoved(string, n, c);
        return string.substring(nArray[0], string.length() - nArray[1]);
    }

    public char getPaddingCharacter() {
        return this.padCharacter_;
    }

    public int getPaddingPolicy() {
        return this.padPolicy_;
    }

    public String getText() {
        if (this.padPolicy_ != 0) {
            return CustomFieldRecord.extractText(this.text_, this.padPolicy_, this.padCharacter_);
        }
        return this.text_;
    }

    private static String injectCharacters(String string, int n, int n2, char c) throws FieldPaddingException {
        int[] nArray = CustomFieldRecord.numberOfPadsToBeAdded(string, n, n2, c);
        StringBuffer stringBuffer = new StringBuffer(n);
        int n3 = 0;
        while (n3 < nArray[0]) {
            stringBuffer.append(c);
            ++n3;
        }
        stringBuffer.append(string);
        int n4 = 0;
        while (n4 < nArray[1]) {
            stringBuffer.append(c);
            ++n4;
        }
        return stringBuffer.toString();
    }

    private static int[] numberOfPadsToBeAdded(String string, int n, int n2, char c) throws FieldPaddingException {
        if (string == null) {
            throw new FieldPaddingException();
        }
        int[] nArray = new int[]{0, 0};
        int n3 = n - string.length();
        if (n3 < 0) {
            throw new FieldPaddingException();
        }
        switch (n2) {
            case 1: {
                nArray[1] = n3;
                break;
            }
            case 2: {
                nArray[0] = n3;
                break;
            }
            case 3: {
                nArray[0] = n3 / 2;
                nArray[1] = n3 - nArray[0];
            }
        }
        return nArray;
    }

    private static int[] numberOfPadsToBeRemoved(String string, int n, char c) throws FieldPaddingException {
        int n2 = 0;
        int n3 = string.length() - 1;
        try {
            if (n == 2 || n == 3) {
                while (n2 <= n3 && string.charAt(n2) == c) {
                    ++n2;
                }
            }
            if (n == 1 || n == 3) {
                while (n2 <= n3 && string.charAt(n3) == c) {
                    --n3;
                }
            }
        }
        catch (Exception exception) {
            throw new FieldPaddingException();
        }
        int[] nArray = new int[]{n2, string.length() - n3 - 1};
        return nArray;
    }

    public void setPaddingCharacter(char c) {
        this.padCharacter_ = c;
    }

    public void setPaddingPolicy(int n) throws FieldPaddingException {
        if (n != 3 && n != 2 && n != 1 && n != 0) {
            throw new FieldPaddingException();
        }
        this.padPolicy_ = n;
    }

    protected void setPosition(int n) {
        this.fieldPos_ = n;
    }

    public void setText(String string) throws ScreenException {
        if (this.isProtected()) {
            throw new FieldProtectedException();
        }
        this.setTextPriv(string);
        if (this.fieldAttributes_ != null) {
            this.fieldAttributes_.setModified(true);
        } else {
            this.modified = true;
        }
    }

    protected void setTextPriv(String string) throws ScreenException {
        int n = string.length();
        if (n > this.maxLength_) {
            throw new FieldTextOverflowException();
        }
        if (n != this.maxLength_ && this.padPolicy_ != 0) {
            string = CustomFieldRecord.injectCharacters(string, this.maxLength_, this.padPolicy_, this.padCharacter_);
        }
        this.text_ = string;
    }
}

