/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.format.jca;

import com.ibm.wsif.format.jca.IRangeObject;

public class ByteRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2002.";
    static final long serialVersionUID = -1979628129376064778L;
    protected byte lowerRange_;
    protected byte upperRange_;

    public ByteRange() {
        this.lowerRange_ = 0;
        this.upperRange_ = 0;
    }

    public ByteRange(byte by, byte by2) throws IllegalArgumentException {
        if (by2 < by) {
            throw new IllegalArgumentException(Byte.toString(by2));
        }
        this.lowerRange_ = by;
        this.upperRange_ = by2;
    }

    public Object clone() {
        try {
            ByteRange byteRange = (ByteRange)super.clone();
            return byteRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteRange)) {
            return false;
        }
        ByteRange byteRange = (ByteRange)object;
        if (this.lowerRange_ != byteRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == byteRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Byte(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Byte(this.upperRange_);
    }

    public static boolean isInRange(byte by, byte by2, byte by3) throws IllegalArgumentException {
        if (by2 < by) {
            throw new IllegalArgumentException(Byte.toString(by2));
        }
        return by3 >= by && by3 <= by2;
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof Byte)) {
            return false;
        }
        byte by = (Byte)object;
        return ByteRange.isInRange(this.lowerRange_, this.upperRange_, by);
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Byte)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = (Byte)object;
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Byte)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = (Byte)object;
    }
}

