/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;

public class HtmlUtils {
    private static final int MAX_BYTES_PER_CHAR = 10;
    private static final BitSet DONT_ENCODE_SET;
    private static String[] sISO8859_1_Entities;
    private static final byte[] encodingTestBytes;
    private static char _LAST_EMPTY_ELEMENT_START;
    private static String[][] emptyElementArr;
    private static String[] aNames;
    private static String[] bNames;
    private static String[] cNames;
    private static String[] fNames;
    private static String[] hNames;
    private static String[] iNames;
    private static String[] lNames;
    private static String[] mNames;
    private static String[] pNames;

    public static void writeText(Writer writer, char[] cArray, char[] cArray2) throws IOException {
        HtmlUtils.writeText(writer, cArray, cArray2, 0, cArray2.length);
    }

    public static void writeText(Writer writer, char[] cArray, char[] cArray2, int n, int n2) throws IOException {
        int n3 = cArray.length;
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            char c = cArray2[i];
            if (c < '\u00a0') {
                if (c >= '?') {
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                    continue;
                }
                if (c >= '\'') {
                    if (c < '<') {
                        n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                        continue;
                    }
                    if (c == '<') {
                        n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                        writer.write("&gt;");
                        continue;
                    }
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                    continue;
                }
                if (c == '&') {
                    n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                    writer.write("&amp;");
                    continue;
                }
                n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                continue;
            }
            if (c <= '\u00ff') {
                n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                writer.write(38);
                writer.write(sISO8859_1_Entities[c - 160]);
                writer.write(59);
                continue;
            }
            n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
            HtmlUtils._writeDecRef(writer, c);
        }
        HtmlUtils.flushBuffer(writer, cArray, n4);
    }

    public static void writeText(Writer writer, char[] cArray, String string) throws IOException {
        int n = cArray.length;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c < '\u00a0') {
                if (c >= '?') {
                    n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                    continue;
                }
                if (c >= '\'') {
                    if (c < '<') {
                        n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                        continue;
                    }
                    if (c == '<') {
                        n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                        writer.write("&gt;");
                        continue;
                    }
                    n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                    continue;
                }
                if (c == '&') {
                    n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                    writer.write("&amp;");
                    continue;
                }
                n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                continue;
            }
            if (c <= '\u00ff') {
                n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                writer.write(38);
                writer.write(sISO8859_1_Entities[c - 160]);
                writer.write(59);
                continue;
            }
            n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
            HtmlUtils._writeDecRef(writer, c);
        }
        HtmlUtils.flushBuffer(writer, cArray, n2);
    }

    public static void writeAttribute(Writer writer, char[] cArray, String string) throws IOException {
        int n = cArray.length;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c < '\u00a0') {
                if (c >= '?') {
                    n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                    continue;
                }
                if (c >= '\'') {
                    if (c < '<') {
                        n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                        continue;
                    }
                    if (c == '>') {
                        n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                        writer.write("&gt;");
                        continue;
                    }
                    n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                    continue;
                }
                if (c == '&') {
                    n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                    if (i + 1 < n3 && string.charAt(i + 1) == '{') {
                        writer.write(c);
                        continue;
                    }
                    writer.write("&amp;");
                    continue;
                }
                if (c == '\"') {
                    n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                    writer.write("&quot;");
                    continue;
                }
                n2 = HtmlUtils.addToBuffer(writer, cArray, n2, n, c);
                continue;
            }
            if (c <= '\u00ff') {
                n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
                writer.write(38);
                writer.write(sISO8859_1_Entities[c - 160]);
                writer.write(59);
                continue;
            }
            n2 = HtmlUtils.flushBuffer(writer, cArray, n2);
            HtmlUtils._writeDecRef(writer, c);
        }
        HtmlUtils.flushBuffer(writer, cArray, n2);
    }

    public static void writeAttribute(Writer writer, char[] cArray, char[] cArray2) throws IOException {
        HtmlUtils.writeAttribute(writer, cArray, cArray2, 0, cArray2.length);
    }

    public static void writeAttribute(Writer writer, char[] cArray, char[] cArray2, int n, int n2) throws IOException {
        int n3 = cArray.length;
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            char c = cArray2[i];
            if (c < '\u00a0') {
                if (c >= '?') {
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                    continue;
                }
                if (c >= '\'') {
                    if (c < '<') {
                        n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                        continue;
                    }
                    if (c == '>') {
                        n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                        writer.write("&gt;");
                        continue;
                    }
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                    continue;
                }
                if (c == '&') {
                    n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                    if (i + 1 < n5 && cArray2[i + 1] == '{') {
                        writer.write(c);
                        continue;
                    }
                    writer.write("&amp;");
                    continue;
                }
                if (c == '\"') {
                    n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                    writer.write("&quot;");
                    continue;
                }
                n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                continue;
            }
            if (c <= '\u00ff') {
                n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
                writer.write(38);
                writer.write(sISO8859_1_Entities[c - 160]);
                writer.write(59);
                continue;
            }
            n4 = HtmlUtils.flushBuffer(writer, cArray, n4);
            HtmlUtils._writeDecRef(writer, c);
        }
        HtmlUtils.flushBuffer(writer, cArray, n4);
    }

    private static void _writeDecRef(Writer writer, char n) throws IOException {
        if (n == 8364) {
            writer.write("&euro;");
            return;
        }
        writer.write("&#");
        int n2 = n;
        if (n2 > 10000) {
            writer.write(48 + n2 / 10000);
            writer.write(48 + (n2 %= 10000) / 1000);
            writer.write(48 + (n2 %= 1000) / 100);
            writer.write(48 + (n2 %= 100) / 10);
            writer.write(48 + (n2 %= 10));
        } else if (n2 > 1000) {
            writer.write(48 + n2 / 1000);
            writer.write(48 + (n2 %= 1000) / 100);
            writer.write(48 + (n2 %= 100) / 10);
            writer.write(48 + (n2 %= 10));
        } else {
            writer.write(48 + n2 / 100);
            writer.write(48 + (n2 %= 100) / 10);
            writer.write(48 + (n2 %= 10));
        }
        writer.write(59);
    }

    private static int addToBuffer(Writer writer, char[] cArray, int n, int n2, char c) throws IOException {
        if (n >= n2) {
            writer.write(cArray, 0, n);
            n = 0;
        }
        cArray[n] = c;
        return n + 1;
    }

    private static int flushBuffer(Writer writer, char[] cArray, int n) throws IOException {
        if (n > 0) {
            writer.write(cArray, 0, n);
        }
        return 0;
    }

    private HtmlUtils() {
    }

    public static void writeURL(Writer writer, String string, String string2) throws IOException, UnsupportedEncodingException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '!' || c > '~') {
                if (c == ' ') {
                    writer.write(43);
                    continue;
                }
                HtmlUtils.writeURIDoubleHex(writer, c);
                continue;
            }
            if (c == '\"') {
                writer.write("%22");
                continue;
            }
            if (c == '?') {
                writer.write(63);
                HtmlUtils.encodeURIString(writer, string, string2, i + 1);
                return;
            }
            writer.write(c);
        }
    }

    private static void encodeURIString(Writer writer, String string, String string2, int n) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        char[] cArray = null;
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (DONT_ENCODE_SET.get(c)) {
                writer.write(c);
                continue;
            }
            if (byteArrayOutputStream == null) {
                byteArrayOutputStream = new ByteArrayOutputStream(10);
                outputStreamWriter = string2 != null ? new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2) : new OutputStreamWriter(byteArrayOutputStream);
                cArray = new char[1];
            }
            try {
                cArray[0] = c;
                outputStreamWriter.write(cArray, 0, 1);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                HtmlUtils.writeURIDoubleHex(writer, byArray[j] + 256);
            }
            byteArrayOutputStream.reset();
        }
    }

    private static void writeURIDoubleHex(Writer writer, int n) throws IOException {
        writer.write(37);
        writer.write(HtmlUtils.intToHex((n >> 4) % 16));
        writer.write(HtmlUtils.intToHex(n % 16));
    }

    private static char intToHex(int n) {
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public static void validateEncoding(String string) throws UnsupportedEncodingException {
        if (string != null) {
            new String(encodingTestBytes, string);
        }
    }

    public static boolean isEmptyElement(String string) {
        char c = string.charAt(0);
        if (c > _LAST_EMPTY_ELEMENT_START) {
            return false;
        }
        String[] stringArray = emptyElementArr[string.charAt(0)];
        if (stringArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    static {
        int n;
        DONT_ENCODE_SET = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            DONT_ENCODE_SET.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            DONT_ENCODE_SET.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            DONT_ENCODE_SET.set(n);
        }
        DONT_ENCODE_SET.set(37);
        DONT_ENCODE_SET.set(43);
        DONT_ENCODE_SET.set(35);
        DONT_ENCODE_SET.set(38);
        DONT_ENCODE_SET.set(61);
        DONT_ENCODE_SET.set(45);
        DONT_ENCODE_SET.set(95);
        DONT_ENCODE_SET.set(46);
        DONT_ENCODE_SET.set(42);
        DONT_ENCODE_SET.set(126);
        DONT_ENCODE_SET.set(47);
        DONT_ENCODE_SET.set(39);
        DONT_ENCODE_SET.set(33);
        DONT_ENCODE_SET.set(40);
        DONT_ENCODE_SET.set(41);
        sISO8859_1_Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
        encodingTestBytes = new byte[]{65};
        _LAST_EMPTY_ELEMENT_START = (char)112;
        emptyElementArr = new String[_LAST_EMPTY_ELEMENT_START + '\u0001'][];
        aNames = new String[]{"area"};
        bNames = new String[]{"br", "base", "basefont"};
        cNames = new String[]{"col"};
        fNames = new String[]{"frame"};
        hNames = new String[]{"hr"};
        iNames = new String[]{"img", "input", "isindex"};
        lNames = new String[]{"link"};
        mNames = new String[]{"meta"};
        pNames = new String[]{"param"};
        HtmlUtils.emptyElementArr[97] = aNames;
        HtmlUtils.emptyElementArr[65] = aNames;
        HtmlUtils.emptyElementArr[98] = bNames;
        HtmlUtils.emptyElementArr[66] = bNames;
        HtmlUtils.emptyElementArr[99] = cNames;
        HtmlUtils.emptyElementArr[67] = cNames;
        HtmlUtils.emptyElementArr[102] = fNames;
        HtmlUtils.emptyElementArr[70] = fNames;
        HtmlUtils.emptyElementArr[104] = hNames;
        HtmlUtils.emptyElementArr[72] = hNames;
        HtmlUtils.emptyElementArr[105] = iNames;
        HtmlUtils.emptyElementArr[73] = iNames;
        HtmlUtils.emptyElementArr[108] = lNames;
        HtmlUtils.emptyElementArr[76] = lNames;
        HtmlUtils.emptyElementArr[109] = mNames;
        HtmlUtils.emptyElementArr[77] = mNames;
        HtmlUtils.emptyElementArr[112] = pNames;
        HtmlUtils.emptyElementArr[80] = pNames;
    }
}

