/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class HtmlResponseWriter
extends ResponseWriter {
    private String contentType = "text/html";
    private String encoding = null;
    private Writer writer = null;
    private boolean closeStart;
    private boolean dontEscape;
    private char[] buffer = new char[1028];
    private char[] charHolder = new char[1];

    public HtmlResponseWriter(Writer writer, String string, String string2) throws FacesException {
        this.writer = writer;
        if (null != string) {
            this.contentType = string;
        }
        this.encoding = string2;
        try {
            HtmlUtils.validateEncoding(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(Util.getExceptionMessageString("com.sun.faces.ENCODING_ERROR"));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        this.writer.flush();
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
    }

    public void startElement(String string, UIComponent uIComponent) throws IOException {
        if (string == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        char c = string.charAt(0);
        if ((c == 's' || c == 'S') && ("script".equalsIgnoreCase(string) || "style".equalsIgnoreCase(string))) {
            this.dontEscape = true;
        }
        this.writer.write("<");
        this.writer.write(string);
        this.closeStart = true;
    }

    public void endElement(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.dontEscape = false;
        if (this.closeStart) {
            boolean bl = HtmlUtils.isEmptyElement(string);
            if (bl) {
                this.writer.write(" />");
                this.closeStart = false;
                return;
            }
            this.writer.write(">");
            this.closeStart = false;
        }
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(">");
    }

    public void writeAttribute(String string, Object object, String string2) throws IOException {
        if (string == null || object == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        Class<?> clazz = object.getClass();
        if (clazz == Boolean.class) {
            if (Boolean.TRUE.equals(object)) {
                this.writer.write(" ");
                this.writer.write(string);
            }
        } else {
            this.writer.write(" ");
            this.writer.write(string);
            this.writer.write("=\"");
            HtmlUtils.writeAttribute(this.writer, this.buffer, object.toString());
            this.writer.write("\"");
        }
    }

    public void writeURIAttribute(String string, Object object, String string2) throws IOException {
        if (string == null || object == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.writer.write(" ");
        this.writer.write(string);
        this.writer.write("=\"");
        String string3 = object.toString();
        if (string3.startsWith("javascript:")) {
            HtmlUtils.writeAttribute(this.writer, this.buffer, string3);
        } else {
            HtmlUtils.writeURL(this.writer, string3, this.encoding);
        }
        this.writer.write("\"");
    }

    public void writeComment(Object object) throws IOException {
        if (object == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        this.writer.write("<!-- ");
        this.writer.write(object.toString());
        this.writer.write(" -->");
    }

    public void writeText(Object object, String string) throws IOException {
        if (object == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(object.toString());
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, object.toString());
        }
    }

    public void writeText(char c) throws IOException {
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(c);
        } else {
            this.charHolder[0] = c;
            HtmlUtils.writeText(this.writer, this.buffer, this.charHolder);
        }
    }

    public void writeText(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(cArray);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, cArray);
        }
    }

    public void writeText(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(cArray, n, n2);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, cArray, n, n2);
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            return new HtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
        }
        catch (FacesException facesException) {
            throw new IllegalStateException();
        }
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.writer.write(">");
            this.closeStart = false;
        }
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void write(char c) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(c);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(n);
    }

    public void write(String string) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(string);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(string, n, n2);
    }
}

