/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.LifecycleImpl;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class LifecycleFactoryImpl
extends LifecycleFactory {
    static final int FIRST_PHASE = PhaseId.RESTORE_VIEW.getOrdinal();
    static final int LAST_PHASE = PhaseId.RENDER_RESPONSE.getOrdinal();
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.lifecycle.LifecycleFactoryImpl";
    protected HashMap lifecycleMap = new HashMap();
    protected Object lock = null;

    public LifecycleFactoryImpl() {
        this.lifecycleMap.put("DEFAULT", new LifecycleWrapper(new LifecycleImpl(), false));
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "LifecycleFactoryImpl", "Created Default Lifecycle");
        }
        this.lock = new Object();
    }

    boolean alreadyCreated(String string) {
        LifecycleWrapper lifecycleWrapper = (LifecycleWrapper)this.lifecycleMap.get(string);
        return null != lifecycleWrapper && lifecycleWrapper.created;
    }

    Lifecycle verifyRegisterArgs(String string, int n, Phase phase) {
        String string2 = null;
        LifecycleWrapper lifecycleWrapper = null;
        Lifecycle lifecycle = null;
        Object[] objectArray = new Object[]{string};
        if (null == string || null == phase) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        lifecycleWrapper = (LifecycleWrapper)this.lifecycleMap.get(string);
        if (null == lifecycleWrapper) {
            string2 = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_NOT_FOUND", objectArray);
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "verifyRegisterArgs", "Error: " + string2);
            }
            throw new IllegalArgumentException(string2);
        }
        lifecycle = lifecycleWrapper.instance;
        Util.doAssert(null != lifecycle);
        if (this.alreadyCreated(string)) {
            string2 = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", objectArray);
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "verifyRegisterArgs", "Error: " + string2);
            }
            throw new IllegalStateException(string2);
        }
        if (FIRST_PHASE > n || n > LAST_PHASE) {
            objectArray = new Object[]{Integer.toString(n)};
            string2 = Util.getExceptionMessageString("com.sun.faces.PHASE_ID_OUT_OF_BOUNDS", objectArray);
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "verifyRegisterArgs", "Error: " + string2);
            }
            throw new IllegalArgumentException(string2);
        }
        return lifecycle;
    }

    public void addLifecycle(String string, Lifecycle lifecycle) {
        if (string == null || lifecycle == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (null != this.lifecycleMap.get(string)) {
            Object[] objectArray = new Object[]{string};
            String string2 = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", objectArray);
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "addLifecycle", "addLifecycle: " + string2);
            }
            throw new IllegalArgumentException(string2);
        }
        this.lifecycleMap.put(string, new LifecycleWrapper(lifecycle, false));
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addLifecycle", "addedLifecycle: " + string + " " + lifecycle);
        }
    }

    public Lifecycle getLifecycle(String string) throws FacesException {
        Lifecycle lifecycle = null;
        LifecycleWrapper lifecycleWrapper = null;
        if (null == string) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (null == this.lifecycleMap.get(string)) {
            Object[] objectArray = new Object[]{string};
            String string2 = Util.getExceptionMessageString("com.sun.faces.CANT_CREATE_LIFECYCLE_ERROR", objectArray);
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "getLifecycle", "LifecycleId " + string + " does not exist");
            }
            throw new IllegalArgumentException(string2);
        }
        lifecycleWrapper = (LifecycleWrapper)this.lifecycleMap.get(string);
        lifecycle = lifecycleWrapper.instance;
        lifecycleWrapper.created = true;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getLifecycle", "getLifecycle: " + string + " " + lifecycle);
        }
        return lifecycle;
    }

    public Iterator getLifecycleIds() {
        return this.lifecycleMap.keySet().iterator();
    }

    static class LifecycleWrapper {
        Lifecycle instance = null;
        boolean created = false;

        LifecycleWrapper(Lifecycle lifecycle, boolean bl) {
            this.instance = lifecycle;
            this.created = bl;
        }
    }
}

