/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.MessageUtil;
import com.sun.faces.el.impl.PrimitiveObjects;
import com.sun.faces.el.impl.UnaryOperator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnaryMinusOperator
extends UnaryOperator {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.UnaryMinusOperator";
    public static final UnaryMinusOperator SINGLETON = new UnaryMinusOperator();

    public String getOperatorSymbol() {
        return "-";
    }

    public Object apply(Object object) throws ElException {
        if (object == null) {
            return PrimitiveObjects.getInteger(0);
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).negate();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).negate();
        }
        if (object instanceof String) {
            if (Coercions.isFloatingPointString(object)) {
                double d = Coercions.coerceToPrimitiveNumber(object, Double.class).doubleValue();
                return PrimitiveObjects.getDouble(-d);
            }
            long l = Coercions.coerceToPrimitiveNumber(object, Long.class).longValue();
            return PrimitiveObjects.getLong(-l);
        }
        if (object instanceof Byte) {
            return PrimitiveObjects.getByte(-((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return PrimitiveObjects.getShort(-((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return PrimitiveObjects.getInteger(-((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return PrimitiveObjects.getLong(-((Long)object).longValue());
        }
        if (object instanceof Float) {
            return PrimitiveObjects.getFloat(-((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return PrimitiveObjects.getDouble(-((Double)object).doubleValue());
        }
        if (log.isLoggable(Level.SEVERE)) {
            String string = MessageUtil.getMessageWithArgs(Constants.UNARY_OP_BAD_TYPE, this.getOperatorSymbol(), object.getClass().getName());
            log.logp(Level.SEVERE, CLASS_NAME, "apply", string);
            throw new ElException(string);
        }
        return PrimitiveObjects.getInteger(0);
    }
}

