/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

class PrimitiveObjects {
    static int BYTE_LOWER_BOUND = 0;
    static int BYTE_UPPER_BOUND = 255;
    static int CHARACTER_LOWER_BOUND = 0;
    static int CHARACTER_UPPER_BOUND = 255;
    static int SHORT_LOWER_BOUND = -1000;
    static int SHORT_UPPER_BOUND = 1000;
    static int INTEGER_LOWER_BOUND = -1000;
    static int INTEGER_UPPER_BOUND = 1000;
    static int LONG_LOWER_BOUND = -1000;
    static int LONG_UPPER_BOUND = 1000;
    static Byte[] mBytes = PrimitiveObjects.createBytes();
    static Character[] mCharacters = PrimitiveObjects.createCharacters();
    static Short[] mShorts = PrimitiveObjects.createShorts();
    static Integer[] mIntegers = PrimitiveObjects.createIntegers();
    static Long[] mLongs = PrimitiveObjects.createLongs();

    private PrimitiveObjects() {
        throw new IllegalArgumentException("Instantiation of this class is not permitted");
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Byte getByte(byte by) {
        if (by >= BYTE_LOWER_BOUND && by <= BYTE_UPPER_BOUND) {
            return mBytes[by - BYTE_LOWER_BOUND];
        }
        return new Byte(by);
    }

    public static Character getCharacter(char c) {
        if (c >= CHARACTER_LOWER_BOUND && c <= CHARACTER_UPPER_BOUND) {
            return mCharacters[c - CHARACTER_LOWER_BOUND];
        }
        return new Character(c);
    }

    public static Short getShort(short s) {
        if (s >= SHORT_LOWER_BOUND && s <= SHORT_UPPER_BOUND) {
            return mShorts[s - SHORT_LOWER_BOUND];
        }
        return new Short(s);
    }

    public static Integer getInteger(int n) {
        if (n >= INTEGER_LOWER_BOUND && n <= INTEGER_UPPER_BOUND) {
            return mIntegers[n - INTEGER_LOWER_BOUND];
        }
        return new Integer(n);
    }

    public static Long getLong(long l) {
        if (l >= (long)LONG_LOWER_BOUND && l <= (long)LONG_UPPER_BOUND) {
            return mLongs[(int)l - LONG_LOWER_BOUND];
        }
        return new Long(l);
    }

    public static Float getFloat(float f) {
        return new Float(f);
    }

    public static Double getDouble(double d) {
        return new Double(d);
    }

    public static Class getPrimitiveObjectClass(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    static Byte[] createBytes() {
        int n = BYTE_UPPER_BOUND - BYTE_LOWER_BOUND + 1;
        Byte[] byteArray = new Byte[n];
        byte by = (byte)BYTE_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            byteArray[n2] = new Byte(by);
            ++n2;
            by = (byte)(by + 1);
        }
        return byteArray;
    }

    static Character[] createCharacters() {
        int n = CHARACTER_UPPER_BOUND - CHARACTER_LOWER_BOUND + 1;
        Character[] characterArray = new Character[n];
        char c = (char)CHARACTER_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            characterArray[n2] = new Character(c);
            ++n2;
            c = (char)(c + '\u0001');
        }
        return characterArray;
    }

    static Short[] createShorts() {
        int n = SHORT_UPPER_BOUND - SHORT_LOWER_BOUND + 1;
        Short[] shortArray = new Short[n];
        short s = (short)SHORT_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            shortArray[n2] = new Short(s);
            ++n2;
            s = (short)(s + 1);
        }
        return shortArray;
    }

    static Integer[] createIntegers() {
        int n = INTEGER_UPPER_BOUND - INTEGER_LOWER_BOUND + 1;
        Integer[] integerArray = new Integer[n];
        int n2 = INTEGER_LOWER_BOUND;
        int n3 = 0;
        while (n3 < n) {
            integerArray[n3] = new Integer(n2);
            ++n3;
            ++n2;
        }
        return integerArray;
    }

    static Long[] createLongs() {
        int n = LONG_UPPER_BOUND - LONG_LOWER_BOUND + 1;
        Long[] longArray = new Long[n];
        long l = LONG_LOWER_BOUND;
        int n2 = 0;
        while (n2 < n) {
            longArray[n2] = new Long(l);
            ++n2;
            ++l;
        }
        return longArray;
    }
}

