/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.FunctionMapper;
import com.sun.faces.el.impl.MessageUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionInvocation
extends Expression {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.FunctionInvocation";
    private String functionName;
    private List argumentList;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String string) {
        this.functionName = string;
    }

    public List getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List list) {
        this.argumentList = list;
    }

    public FunctionInvocation(String string, List list) {
        this.functionName = string;
        this.argumentList = list;
    }

    public String getExpressionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.functionName);
        stringBuffer.append("(");
        Iterator iterator = this.argumentList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Expression)iterator.next()).getExpressionString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Object evaluate(ExpressionInfo expressionInfo) throws ElException {
        FunctionMapper functionMapper = expressionInfo.getFunctionMapper();
        if (functionMapper == null && log.isLoggable(Level.SEVERE)) {
            String string = MessageUtil.getMessageWithArgs(Constants.UNKNOWN_FUNCTION, this.functionName);
            log.logp(Level.SEVERE, CLASS_NAME, "evaluate", string);
            throw new ElException(string);
        }
        String string = null;
        String string2 = null;
        int n = this.functionName.indexOf(58);
        if (n == -1) {
            string = "";
            string2 = this.functionName;
        } else {
            string = this.functionName.substring(0, n);
            string2 = this.functionName.substring(n + 1);
        }
        Method method = functionMapper.resolve(string, string2);
        if (method == null && log.isLoggable(Level.SEVERE)) {
            String string3 = MessageUtil.getMessageWithArgs(Constants.UNKNOWN_FUNCTION, this.functionName);
            log.logp(Level.SEVERE, CLASS_NAME, "evaluate", string3);
            throw new ElException(string3);
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != this.argumentList.size() && log.isLoggable(Level.SEVERE)) {
            String string4 = MessageUtil.getMessageWithArgs(Constants.INAPPROPRIATE_FUNCTION_ARG_COUNT, this.functionName, new Integer(classArray.length), new Integer(this.argumentList.size()));
            log.logp(Level.SEVERE, CLASS_NAME, "evaluate", string4);
            throw new ElException(string4);
        }
        Object[] objectArray = new Object[this.argumentList.size()];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = ((Expression)this.argumentList.get(i)).evaluate(expressionInfo);
            objectArray[i] = Coercions.coerce(objectArray[i], classArray[i]);
        }
        try {
            return method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (log.isLoggable(Level.SEVERE)) {
                String string5 = MessageUtil.getMessageWithArgs(Constants.FUNCTION_INVOCATION_ERROR, this.functionName);
                Throwable throwable = invocationTargetException.getTargetException();
                log.logp(Level.SEVERE, CLASS_NAME, "evaluate", string5, throwable);
                throw new ElException(string5, throwable);
            }
            return null;
        }
        catch (Throwable throwable) {
            if (log.isLoggable(Level.SEVERE)) {
                String string6 = MessageUtil.getMessageWithArgs(Constants.FUNCTION_INVOCATION_ERROR, this.functionName);
                log.logp(Level.SEVERE, CLASS_NAME, "evaluate", string6, throwable);
                throw new ElException(string6, throwable);
            }
            return null;
        }
    }
}

