/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;

public class ValueBindingImpl
extends ValueBinding
implements StateHolder {
    private static final String[] FACES_IMPLICIT_OBJECTS = new String[]{"applicationScope", "sessionScope", "requestScope", "facesContext", "cookies", "header", "headerValues", "initParam", "param", "paramValues", "view"};
    private static final Logger log;
    private static final String CLASS_NAME = "com.sun.faces.el.ValueBindingImpl";
    protected String ref = null;
    protected Application application = null;
    protected static Map applicationMap;
    private boolean isTransient = false;

    public ValueBindingImpl() {
    }

    public ValueBindingImpl(Application application) {
        Util.parameterNonNull(application);
        this.application = application;
        if (null == applicationMap) {
            applicationMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        }
        Util.doAssert(null != applicationMap);
    }

    public void setRef(String string) {
        this.reset();
        Util.parameterNonEmpty(string);
        this.ref = string;
    }

    public void reset() {
        this.ref = null;
    }

    public Object getValue(FacesContext facesContext) throws EvaluationException, PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        Object object = null;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue(ref=" + this.ref + ")");
        }
        object = this.getValue(facesContext, this.ref);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getValue", "-->Returning " + object);
        }
        return object;
    }

    protected Object getValue(FacesContext facesContext, String string) throws EvaluationException, PropertyNotFoundException {
        Object object = null;
        try {
            ExpressionInfo expressionInfo = new ExpressionInfo();
            expressionInfo.setExpressionString(string);
            expressionInfo.setExpectedType(Object.class);
            expressionInfo.setFacesContext(facesContext);
            expressionInfo.setVariableResolver(this.application.getVariableResolver());
            expressionInfo.setPropertyResolver(this.application.getPropertyResolver());
            object = Util.getExpressionEvaluator().evaluate(expressionInfo);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Result:" + object);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
        return object;
    }

    public void setValue(FacesContext facesContext, Object object) throws EvaluationException, PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        if (this.isReservedIdentifier(this.ref)) {
            throw new ReferenceSyntaxException(Util.getExceptionMessageString("com.sun.faces.ILLEGAL_IDENTIFIER_LVALUE_MODE", new Object[]{this.ref}));
        }
        try {
            ExpressionInfo expressionInfo = new ExpressionInfo();
            expressionInfo.setExpressionString(this.ref);
            expressionInfo.setFacesContext(facesContext);
            expressionInfo.setVariableResolver(this.application.getVariableResolver());
            expressionInfo.setPropertyResolver(this.application.getPropertyResolver());
            Expression expression = Util.getExpressionEvaluator().parseExpression(expressionInfo);
            expression.setValue(expressionInfo, object);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "setValue", "setValue Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "setValue", "setValue Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "setValue", "setValue Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
    }

    public boolean isReadOnly(FacesContext facesContext) throws PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        try {
            ExpressionInfo expressionInfo = new ExpressionInfo();
            expressionInfo.setExpressionString(this.ref);
            expressionInfo.setFacesContext(facesContext);
            expressionInfo.setVariableResolver(this.application.getVariableResolver());
            expressionInfo.setPropertyResolver(this.application.getPropertyResolver());
            Expression expression = Util.getExpressionEvaluator().parseExpression(expressionInfo);
            return expression.isReadOnly(expressionInfo);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "isReadOnly", "isReadOnly Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "isReadOnly", "isReadOnly Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "isReadOnly", "isReadOnly Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
    }

    public Class getType(FacesContext facesContext) throws PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        try {
            ExpressionInfo expressionInfo = new ExpressionInfo();
            expressionInfo.setExpressionString(this.ref);
            expressionInfo.setFacesContext(facesContext);
            expressionInfo.setVariableResolver(this.application.getVariableResolver());
            expressionInfo.setPropertyResolver(this.application.getPropertyResolver());
            Expression expression = Util.getExpressionEvaluator().parseExpression(expressionInfo);
            return expression.getType(expressionInfo);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getType", "getType Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getType", "getType Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getType", "getType Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
    }

    public String getExpressionString() {
        return "#{" + this.ref + "}";
    }

    public String getScope(String string) {
        string = this.ref;
        if (string == null) {
            return null;
        }
        int n = this.getFirstSegmentIndex(string);
        String string2 = string;
        String string3 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            if ((n = this.getFirstSegmentIndex(string3)) > 0) {
                string3 = string3.substring(0, n);
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (string2.equalsIgnoreCase("requestScope")) {
            if (string3 != null && externalContext.getRequestMap().get(string3) != null) {
                return "request";
            }
            return null;
        }
        if (string2.equalsIgnoreCase("sessionScope")) {
            if (string3 != null && Util.getSessionMap(facesContext).get(string3) != null) {
                return "session";
            }
            return null;
        }
        if (string2.equalsIgnoreCase("applicationScope")) {
            if (string3 != null && externalContext.getApplicationMap().get(string3) != null) {
                return "application";
            }
            return null;
        }
        if (externalContext.getRequestMap().get(string2) != null) {
            return "request";
        }
        if (Util.getSessionMap(facesContext).get(string2) != null) {
            return "session";
        }
        if (externalContext.getApplicationMap().get(string2) != null) {
            return "application";
        }
        return null;
    }

    private int getFirstSegmentIndex(String string) {
        int n = string.indexOf(".");
        int n2 = string.indexOf("[");
        if (n < 0) {
            n = n2;
        } else if (n2 > 0 && n > n2) {
            n = n2;
        }
        return n;
    }

    private boolean isReservedIdentifier(String string) {
        return Arrays.binarySearch(FACES_IMPLICIT_OBJECTS, string) >= 0;
    }

    public Object saveState(FacesContext facesContext) {
        String string = this.ref;
        return string;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        this.ref = object.toString();
        if (null == this.application) {
            this.application = facesContext.getApplication();
        }
        if (null == applicationMap) {
            applicationMap = facesContext.getExternalContext().getApplicationMap();
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    static {
        Arrays.sort(FACES_IMPLICIT_OBJECTS);
        log = Logger.getLogger("com.ibm.ws.jsf");
        applicationMap = null;
    }
}

