/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;

public class MethodBindingImpl
extends MethodBinding
implements StateHolder {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.MethodBindingImpl";
    private Class[] args;
    private String name;
    private String rawRef;
    private ValueBinding vb;
    private boolean transientFlag = false;

    public MethodBindingImpl() {
    }

    public MethodBindingImpl(Application application, String string, Class[] classArray) {
        if (application == null || string == null) {
            throw new NullPointerException();
        }
        if (!string.startsWith("#{") || !string.endsWith("}")) {
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "MethodBindingImpl", " Expression " + string + " does not follow the syntax #{...}");
            }
            throw new ReferenceSyntaxException(string);
        }
        this.rawRef = string;
        string = Util.stripBracketsIfNecessary(string);
        this.args = classArray;
        String string2 = null;
        if (string.endsWith("]")) {
            int n = string.lastIndexOf("[");
            if (n < 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "MethodBindingImpl", "Expression syntax error: Missing '[' in " + string);
                }
                throw new ReferenceSyntaxException(string);
            }
            string2 = "#{" + string.substring(0, n) + "}";
            this.vb = application.createValueBinding(string2);
            this.name = string.substring(n + 1);
            this.name = this.name.substring(0, this.name.length() - 1);
        } else {
            int n = string.lastIndexOf(".");
            if (n < 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "MethodBindingImpl", "Expression syntax error: Missing '.' in " + string);
                }
                throw new ReferenceSyntaxException(string);
            }
            string2 = "#{" + string.substring(0, n) + "}";
            this.vb = application.createValueBinding(string2);
            this.name = string.substring(n + 1);
        }
        if (this.name.length() < 1) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "MethodBindingImpl", "Expression syntax error: Missing name after period in:" + string);
            }
            throw new ReferenceSyntaxException(string);
        }
    }

    public Object invoke(FacesContext facesContext, Object[] objectArray) throws EvaluationException, MethodNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        Object object = this.vb.getValue(facesContext);
        Method method = this.method(object);
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvaluationException((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EvaluationException(invocationTargetException.getTargetException());
        }
    }

    public Class getType(FacesContext facesContext) {
        Object object = this.vb.getValue(facesContext);
        Method method = this.method(object);
        Class<?> clazz = method.getReturnType();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getType", "Method return type:" + clazz.getName());
        }
        if ("void".equals(clazz.getName())) {
            return null;
        }
        return clazz;
    }

    public String getExpressionString() {
        return this.rawRef;
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.name, UIComponentBase.saveAttachedState((FacesContext)facesContext, (Object)this.vb), this.args, this.rawRef};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.name = (String)objectArray[0];
        this.vb = (ValueBinding)UIComponentBase.restoreAttachedState((FacesContext)facesContext, (Object)objectArray[1]);
        this.args = (Class[])objectArray[2];
        this.rawRef = (String)objectArray[3];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    private Method method(Object object) {
        if (null == object) {
            throw new MethodNotFoundException(this.name);
        }
        Class<?> clazz = object.getClass();
        try {
            return clazz.getMethod(this.name, this.args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MethodNotFoundException(this.name + ": " + noSuchMethodException.getMessage());
        }
    }
}

