/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.beans;

import com.sun.faces.config.beans.ApplicationBean;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.ConverterBean;
import com.sun.faces.config.beans.FactoryBean;
import com.sun.faces.config.beans.LifecycleBean;
import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.beans.NavigationRuleBean;
import com.sun.faces.config.beans.ReferencedBeanBean;
import com.sun.faces.config.beans.RenderKitBean;
import com.sun.faces.config.beans.ValidatorBean;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FacesConfigBean {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.config.beans.FacesConfigBean";
    private ApplicationBean application;
    private FactoryBean factory;
    private LifecycleBean lifecycle;
    private Map components = new TreeMap();
    private Map convertersByClass = new TreeMap();
    private Map convertersById = new TreeMap();
    private Map managedBeans = new TreeMap();
    private Map navigationRules = new TreeMap();
    private Map referencedBeans = new TreeMap();
    private Map renderKits = new TreeMap();
    private Map validators = new TreeMap();

    public ApplicationBean getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationBean applicationBean) {
        this.application = applicationBean;
    }

    public FactoryBean getFactory() {
        return this.factory;
    }

    public void setFactory(FactoryBean factoryBean) {
        this.factory = factoryBean;
    }

    public LifecycleBean getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(LifecycleBean lifecycleBean) {
        this.lifecycle = lifecycleBean;
    }

    public void addComponent(ComponentBean componentBean) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addComponent", "addComponent(" + componentBean.getComponentType() + ")");
        }
        this.components.put(componentBean.getComponentType(), componentBean);
    }

    public ComponentBean getComponent(String string) {
        return (ComponentBean)this.components.get(string);
    }

    public ComponentBean[] getComponents() {
        ComponentBean[] componentBeanArray = new ComponentBean[this.components.size()];
        return this.components.values().toArray(componentBeanArray);
    }

    public void removeComponent(ComponentBean componentBean) {
        this.components.remove(componentBean.getComponentType());
    }

    public void addConverter(ConverterBean converterBean) {
        if (converterBean.getConverterId() != null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "addConverter", "addConverterById(" + converterBean.getConverterId() + ")");
            }
            this.convertersById.put(converterBean.getConverterId(), converterBean);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "addConverter", "addConverterByClass(" + converterBean.getConverterForClass() + ")");
            }
            this.convertersByClass.put(converterBean.getConverterForClass(), converterBean);
        }
    }

    public ConverterBean getConverterByClass(String string) {
        return (ConverterBean)this.convertersByClass.get(string);
    }

    public ConverterBean getConverterById(String string) {
        return (ConverterBean)this.convertersById.get(string);
    }

    public ConverterBean[] getConvertersByClass() {
        ConverterBean[] converterBeanArray = new ConverterBean[this.convertersByClass.size()];
        return this.convertersByClass.values().toArray(converterBeanArray);
    }

    public ConverterBean[] getConvertersById() {
        ConverterBean[] converterBeanArray = new ConverterBean[this.convertersById.size()];
        return this.convertersById.values().toArray(converterBeanArray);
    }

    public void removeConverter(ConverterBean converterBean) {
        if (converterBean.getConverterId() != null) {
            this.convertersById.remove(converterBean.getConverterId());
        } else {
            this.convertersByClass.remove(converterBean.getConverterForClass());
        }
    }

    public void addManagedBean(ManagedBeanBean managedBeanBean) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addManagedBean", "addManagedBean(" + managedBeanBean.getManagedBeanName() + ")");
        }
        this.managedBeans.put(managedBeanBean.getManagedBeanName(), managedBeanBean);
    }

    public ManagedBeanBean getManagedBean(String string) {
        return (ManagedBeanBean)this.managedBeans.get(string);
    }

    public ManagedBeanBean[] getManagedBeans() {
        ManagedBeanBean[] managedBeanBeanArray = new ManagedBeanBean[this.managedBeans.size()];
        return this.managedBeans.values().toArray(managedBeanBeanArray);
    }

    public void removeManagedBean(ManagedBeanBean managedBeanBean) {
        this.managedBeans.remove(managedBeanBean.getManagedBeanName());
    }

    public void addNavigationRule(NavigationRuleBean navigationRuleBean) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addNavigationRule", "addNavigationRule(" + navigationRuleBean.getFromViewId() + ")");
        }
        this.navigationRules.put(navigationRuleBean.getFromViewId(), navigationRuleBean);
    }

    public NavigationRuleBean getNavigationRule(String string) {
        return (NavigationRuleBean)this.navigationRules.get(string);
    }

    public NavigationRuleBean[] getNavigationRules() {
        NavigationRuleBean[] navigationRuleBeanArray = new NavigationRuleBean[this.navigationRules.size()];
        return this.navigationRules.values().toArray(navigationRuleBeanArray);
    }

    public void removeNavigationRule(NavigationRuleBean navigationRuleBean) {
        this.navigationRules.remove(navigationRuleBean.getFromViewId());
    }

    public void addReferencedBean(ReferencedBeanBean referencedBeanBean) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addReferencedBean", "addReferencedBean(" + referencedBeanBean.getReferencedBeanName() + ")");
        }
        this.referencedBeans.put(referencedBeanBean.getReferencedBeanName(), referencedBeanBean);
    }

    public ReferencedBeanBean getReferencedBean(String string) {
        return (ReferencedBeanBean)this.referencedBeans.get(string);
    }

    public ReferencedBeanBean[] getReferencedBeans() {
        ReferencedBeanBean[] referencedBeanBeanArray = new ReferencedBeanBean[this.referencedBeans.size()];
        return this.referencedBeans.values().toArray(referencedBeanBeanArray);
    }

    public void removeReferencedBean(ReferencedBeanBean referencedBeanBean) {
        this.referencedBeans.remove(referencedBeanBean.getReferencedBeanName());
    }

    public void addRenderKit(RenderKitBean renderKitBean) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addRenderKit", "addRenderKit(" + renderKitBean.getRenderKitId() + ")");
        }
        this.renderKits.put(renderKitBean.getRenderKitId(), renderKitBean);
    }

    public RenderKitBean getRenderKit(String string) {
        return (RenderKitBean)this.renderKits.get(string);
    }

    public RenderKitBean[] getRenderKits() {
        RenderKitBean[] renderKitBeanArray = new RenderKitBean[this.renderKits.size()];
        return this.renderKits.values().toArray(renderKitBeanArray);
    }

    public void removeRenderKit(RenderKitBean renderKitBean) {
        this.renderKits.remove(renderKitBean.getRenderKitId());
    }

    public void addValidator(ValidatorBean validatorBean) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addValidator", "addValidator(" + validatorBean.getValidatorId() + ")");
        }
        this.validators.put(validatorBean.getValidatorId(), validatorBean);
    }

    public ValidatorBean getValidator(String string) {
        return (ValidatorBean)this.validators.get(string);
    }

    public ValidatorBean[] getValidators() {
        ValidatorBean[] validatorBeanArray = new ValidatorBean[this.validators.size()];
        return this.validators.values().toArray(validatorBeanArray);
    }

    public void removeValidator(ValidatorBean validatorBean) {
        this.validators.remove(validatorBean.getValidatorId());
    }
}

