/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.ibm.ws.jsf.util.FacesBeanUtils;
import com.sun.faces.config.beans.ListEntriesBean;
import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.beans.ManagedPropertyBean;
import com.sun.faces.config.beans.MapEntriesBean;
import com.sun.faces.config.beans.MapEntryBean;
import com.sun.faces.util.Util;
import java.beans.Beans;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;

public class ManagedBeanFactory {
    private static Map scopeMap = null;
    private static final int TYPE_IS_LIST = 0;
    private static final int TYPE_IS_MAP = 1;
    private static final int TYPE_IS_BEAN = 2;
    private static final int TYPE_IS_UICOMPONENT = 3;
    private static final int TYPE_IS_SIMPLE = 3;
    private static final String MANAGED_BEAN_CREATED_STACK = "com.sun.faces.managedBeanStack";
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.config.ManagedBeanFactory";
    ManagedBeanBean managedBean;
    String scope;
    private Map managedBeanFactoryMap = null;

    public ManagedBeanFactory(ManagedBeanBean managedBeanBean) {
        this.managedBean = managedBeanBean;
        this.scope = managedBeanBean.getManagedBeanScope();
        if (null == scopeMap) {
            scopeMap = new HashMap();
            scopeMap.put("request", new Integer(1));
            scopeMap.put("session", new Integer(2));
            scopeMap.put("application", new Integer(3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagedBeanBean(ManagedBeanBean managedBeanBean) {
        ManagedBeanFactory managedBeanFactory = this;
        synchronized (managedBeanFactory) {
            this.managedBean = managedBeanBean;
            this.scope = this.managedBean.getManagedBeanScope();
        }
    }

    public Map getManagedBeanFactoryMap() {
        if (null == this.managedBeanFactoryMap && log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getManagedBeanFactoryMap", "Contract violation: ManagedBeanFactory must be initialized with managedBeanFactoryMap after instantiation.");
        }
        return this.managedBeanFactoryMap;
    }

    public void setManagedBeanFactoryMap(Map map) {
        this.managedBeanFactoryMap = map;
    }

    public Object newInstance(FacesContext facesContext) throws FacesException {
        Object object = null;
        int n = -1;
        Map map = facesContext.getExternalContext().getRequestMap();
        ArrayList<String> arrayList = (ArrayList<String>)map.get(MANAGED_BEAN_CREATED_STACK);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            map.put(MANAGED_BEAN_CREATED_STACK, arrayList);
        }
        if (arrayList.contains(this.managedBean.getManagedBeanName())) {
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "newInstance", "Possible cyclic reference to managedBean " + this.managedBean.getManagedBeanName() + " ");
            }
            Object[] objectArray = new Object[]{this.managedBean.getManagedBeanName()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CYCLIC_REFERENCE_ERROR", objectArray));
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = FacesContext.getCurrentInstance().getClass().getClassLoader();
            }
            object = Beans.instantiate(classLoader, this.managedBean.getManagedBeanClass());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{this.managedBean.getManagedBeanClass(), this.managedBean.getManagedBeanName()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray) + ". " + exception.getMessage(), (Throwable)exception);
        }
        arrayList.add(this.managedBean.getManagedBeanName());
        try {
            n = this.getBeanType(object);
            switch (n) {
                case 0: {
                    this.copyListEntriesFromConfigToList(this.managedBean.getListEntries(), (List)object);
                    break;
                }
                case 1: {
                    this.copyMapEntriesFromConfigToMap(this.managedBean.getMapEntries(), (Map)object);
                    break;
                }
                case 2: 
                case 3: {
                    this.setPropertiesIntoBean(object, n, this.managedBean);
                    break;
                }
                default: {
                    Util.doAssert(false);
                    break;
                }
            }
        }
        catch (FacesException facesException) {
            throw facesException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{this.managedBean.getManagedBeanClass()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray), (Throwable)classNotFoundException);
        }
        arrayList.remove(this.managedBean.getManagedBeanName());
        return object;
    }

    protected int getBeanType(Object object) {
        int n = -1;
        ListEntriesBean listEntriesBean = null;
        MapEntriesBean mapEntriesBean = null;
        listEntriesBean = this.managedBean.getListEntries();
        if (null != listEntriesBean) {
            if (null != this.managedBean.getMapEntries() || null != this.managedBean.getManagedProperties() && this.managedBean.getManagedProperties().length > 0) {
                Object[] objectArray = new Object[]{this.managedBean.getManagedBeanClass()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
            }
            n = 0;
        }
        if (null != (mapEntriesBean = this.managedBean.getMapEntries())) {
            Util.doAssert(-1 == n);
            if (null != this.managedBean.getListEntries() || null != this.managedBean.getManagedProperties() && this.managedBean.getManagedProperties().length > 0) {
                Object[] objectArray = new Object[]{this.managedBean.getManagedBeanClass()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
            }
            n = 1;
        }
        if (0 != n && 1 != n) {
            Util.doAssert(-1 == n);
            n = object instanceof UIComponent ? 3 : 2;
        }
        Util.doAssert(-1 != n);
        return n;
    }

    protected int getPropertyType(ManagedPropertyBean managedPropertyBean) {
        int n = -1;
        ListEntriesBean listEntriesBean = null;
        MapEntriesBean mapEntriesBean = null;
        listEntriesBean = managedPropertyBean.getListEntries();
        if (null != listEntriesBean) {
            if (null != managedPropertyBean.getMapEntries() || null != managedPropertyBean.getValue() || managedPropertyBean.isNullValue()) {
                Object[] objectArray = new Object[]{managedPropertyBean.getPropertyName()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
            }
            n = 0;
        }
        if (null != (mapEntriesBean = managedPropertyBean.getMapEntries())) {
            Util.doAssert(-1 == n);
            if (null != managedPropertyBean.getListEntries() || null != managedPropertyBean.getValue() || managedPropertyBean.isNullValue()) {
                Object[] objectArray = new Object[]{managedPropertyBean.getPropertyName()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
            }
            n = 1;
        }
        if (0 != n && 1 != n) {
            Util.doAssert(-1 == n);
            if (null != managedPropertyBean.getValue() || managedPropertyBean.isNullValue()) {
                n = 3;
            }
        }
        if (-1 == n && !managedPropertyBean.isNullValue()) {
            Object[] objectArray = new Object[]{managedPropertyBean.getPropertyName()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
        }
        return n;
    }

    protected Class copyListEntriesFromConfigToList(ListEntriesBean listEntriesBean, List list) throws ClassNotFoundException {
        String[] stringArray = listEntriesBean.getValues();
        Class clazz = String.class;
        Object object = null;
        String string = null;
        int n = 0;
        n = stringArray.length;
        if (0 == n) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "copyListEntriesFromConfigToList", "zero length array");
            }
            return null;
        }
        clazz = this.getValueClassConsideringPrimitives(listEntriesBean.getValueClass());
        for (int i = 0; i < n; ++i) {
            string = stringArray[i];
            object = Util.isVBExpression(string) ? this.evaluateValueBindingGet(string) : (null == string ? null : string);
            object = this.getConvertedValueConsideringPrimitives(object, clazz);
            list.add(object);
        }
        return clazz;
    }

    void copyMapEntriesFromConfigToMap(MapEntriesBean mapEntriesBean, Map map) throws ClassNotFoundException {
        Object object = null;
        Object object2 = null;
        MapEntryBean[] mapEntryBeanArray = mapEntriesBean.getMapEntries();
        MapEntryBean mapEntryBean = null;
        Class clazz = String.class;
        Class clazz2 = String.class;
        String string = null;
        String string2 = null;
        if (null == mapEntriesBean || 0 == mapEntryBeanArray.length) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "copyMapEntriesFromConfigToMap", "null or zero length array");
            }
            return;
        }
        clazz = this.getValueClassConsideringPrimitives(mapEntriesBean.getKeyClass());
        clazz2 = this.getValueClassConsideringPrimitives(mapEntriesBean.getValueClass());
        int n = mapEntryBeanArray.length;
        for (int i = 0; i < n; ++i) {
            mapEntryBean = mapEntryBeanArray[i];
            string = mapEntryBean.getKey();
            string2 = mapEntryBean.getValue();
            object = Util.isVBExpression(string) ? this.evaluateValueBindingGet(string) : (null == string ? null : this.getConvertedValueConsideringPrimitives(string, clazz));
            object2 = Util.isVBExpression(string2) ? this.evaluateValueBindingGet(string2) : (null == string2 ? null : this.getConvertedValueConsideringPrimitives(string2, clazz2));
            map.put(object, object2);
        }
    }

    protected void setPropertiesIntoBean(Object object, int n, ManagedBeanBean managedBeanBean) {
        Object object2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n2 = -1;
        Class clazz = null;
        ManagedPropertyBean[] managedPropertyBeanArray = managedBeanBean.getManagedProperties();
        if (null == managedPropertyBeanArray) {
            return;
        }
        int n3 = managedPropertyBeanArray.length;
        for (int i = 0; i < n3; ++i) {
            if (null == managedPropertyBeanArray[i] || null == (string2 = managedPropertyBeanArray[i].getPropertyName())) continue;
            try {
                n2 = this.getPropertyType(managedPropertyBeanArray[i]);
                switch (n2) {
                    case 0: {
                        object2 = this.getArrayOrListToSetIntoBean(object, managedPropertyBeanArray[i]);
                        FacesBeanUtils.setProperty(object, string2, object2);
                        break;
                    }
                    case 1: {
                        object2 = this.getMapToSetIntoBean(object, managedPropertyBeanArray[i]);
                        FacesBeanUtils.setProperty(object, string2, object2);
                        break;
                    }
                    case 3: {
                        string = managedPropertyBeanArray[i].getPropertyClass();
                        if (null == string) {
                            clazz = FacesBeanUtils.getPropertyType(object, string2);
                            if (null == clazz) {
                                clazz = this.getValueClassConsideringPrimitives(string);
                            }
                        } else {
                            clazz = this.getValueClassConsideringPrimitives(string);
                        }
                        object2 = Util.isVBExpression(string3 = managedPropertyBeanArray[i].getValue()) ? this.evaluateValueBindingGet(string3) : (null == string3 && managedPropertyBeanArray[i].isNullValue() ? null : string3);
                        object2 = this.getConvertedValueConsideringPrimitives(object2, clazz);
                        FacesBeanUtils.setSimpleProperty(object, string2, object2);
                        break;
                    }
                    default: {
                        Util.doAssert(false);
                        break;
                    }
                }
                continue;
            }
            catch (FacesException facesException) {
                throw facesException;
            }
            catch (Exception exception) {
                if (3 == n) {
                    this.setComponentAttribute(object, string2, object2);
                    continue;
                }
                Object[] objectArray = new Object[]{string2};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.ERROR_SETTING_BEAN_PROPERTY", objectArray), (Throwable)exception);
            }
        }
    }

    private Object getArrayOrListToSetIntoBean(Object object, ManagedPropertyBean managedPropertyBean) throws Exception {
        int n;
        Object object2 = null;
        boolean bl = true;
        boolean bl2 = false;
        List<Object> list = null;
        Object var7_7 = null;
        Class clazz = String.class;
        Class clazz2 = null;
        Object var10_10 = null;
        String string = managedPropertyBean.getPropertyName();
        try {
            object2 = FacesBeanUtils.getProperty(object, string);
            bl = null == object2;
            clazz2 = FacesBeanUtils.getPropertyType(object, string);
            bl2 = clazz2.isArray();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (!bl2 && null != clazz2 && !List.class.isAssignableFrom(clazz2)) {
            Object[] objectArray = new Object[]{string};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
        }
        if (!bl) {
            if (bl2) {
                list = new ArrayList();
                n = Array.getLength(object2);
                for (int i = 0; i < n; ++i) {
                    list.add(Array.get(object2, i));
                }
            } else {
                if (!(object2 instanceof List)) {
                    Object[] objectArray = new Object[]{string};
                    throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
                }
                list = (List)object2;
            }
        } else {
            list = new ArrayList();
            object2 = list;
        }
        clazz = this.copyListEntriesFromConfigToList(managedPropertyBean.getListEntries(), list);
        if (bl2) {
            object2 = Array.newInstance(clazz, list.size());
            n = list.size();
            for (int i = 0; i < n; ++i) {
                if (clazz == Boolean.TYPE) {
                    Array.setBoolean(object2, i, (Boolean)list.get(i));
                    continue;
                }
                if (clazz == Byte.TYPE) {
                    Array.setByte(object2, i, (Byte)list.get(i));
                    continue;
                }
                if (clazz == Double.TYPE) {
                    Array.setDouble(object2, i, (Double)list.get(i));
                    continue;
                }
                if (clazz == Float.TYPE) {
                    Array.setFloat(object2, i, ((Float)list.get(i)).floatValue());
                    continue;
                }
                if (clazz == Integer.TYPE) {
                    Array.setInt(object2, i, (Integer)list.get(i));
                    continue;
                }
                if (clazz == Character.TYPE) {
                    Array.setChar(object2, i, ((Character)list.get(i)).charValue());
                    continue;
                }
                if (clazz == Short.TYPE) {
                    Array.setShort(object2, i, (Short)list.get(i));
                    continue;
                }
                if (clazz == Long.TYPE) {
                    Array.setLong(object2, i, (Long)list.get(i));
                    continue;
                }
                Array.set(object2, i, list.get(i));
            }
        } else {
            object2 = list;
        }
        return object2;
    }

    private Map getMapToSetIntoBean(Object object, ManagedPropertyBean managedPropertyBean) throws Exception {
        HashMap hashMap = null;
        boolean bl = true;
        Class clazz = null;
        Object var6_6 = null;
        Object var7_7 = null;
        String string = managedPropertyBean.getPropertyName();
        try {
            hashMap = (HashMap)FacesBeanUtils.getProperty(object, string);
            bl = null == hashMap;
            clazz = FacesBeanUtils.getPropertyType(object, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (null != clazz && !Map.class.isAssignableFrom(clazz)) {
            Object[] objectArray = new Object[]{string};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
        }
        if (bl) {
            hashMap = new HashMap();
        }
        this.copyMapEntriesFromConfigToMap(managedPropertyBean.getMapEntries(), hashMap);
        return hashMap;
    }

    private Class getValueClassConsideringPrimitives(String string) throws ClassNotFoundException {
        Class<Serializable> clazz;
        Class<Long> clazz2 = clazz = String.class;
        if (null != string && 0 < string.length()) {
            clazz = string.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (string.equals(Byte.TYPE.getName()) ? Byte.TYPE : (string.equals(Double.TYPE.getName()) ? Double.TYPE : (string.equals(Float.TYPE.getName()) ? Float.TYPE : (string.equals(Integer.TYPE.getName()) ? Integer.TYPE : (string.equals(Character.TYPE.getName()) ? Character.TYPE : (string.equals(Short.TYPE.getName()) ? Short.TYPE : (string.equals(Long.TYPE.getName()) ? Long.TYPE : Util.loadClass(string, this))))))));
        }
        return clazz;
    }

    private Object getConvertedValueConsideringPrimitives(Object object, Class clazz) throws FacesException {
        if (null != object && null != clazz) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                object = object.toString().toLowerCase().equals("true") ? Boolean.TRUE : Boolean.FALSE;
            } else if (clazz == Byte.TYPE || clazz == Byte.class) {
                object = new Byte(object.toString());
            } else if (clazz == Double.TYPE || clazz == Double.class) {
                object = new Double(object.toString());
            } else if (clazz == Float.TYPE || clazz == Float.class) {
                object = new Float(object.toString());
            } else if (clazz == Integer.TYPE || clazz == Integer.class) {
                object = new Integer(object.toString());
            } else if (clazz == Character.TYPE || clazz == Character.class) {
                object = new Character(object.toString().charAt(0));
            } else if (clazz == Short.TYPE || clazz == Short.class) {
                object = new Short(object.toString());
            } else if (clazz == Long.TYPE || clazz == Long.class) {
                object = new Long(object.toString());
            } else if (clazz != String.class && !clazz.isAssignableFrom(object.getClass())) {
                Object[] objectArray = new Object[]{object.toString()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray));
            }
        }
        return object;
    }

    public String getScope() {
        return this.scope;
    }

    private Object evaluateValueBindingGet(String string) throws FacesException {
        Object object = null;
        if (!this.hasValidLifespan(string)) {
            Object[] objectArray = new Object[]{string};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.INVALID_SCOPE_LIFESPAN", objectArray));
        }
        ValueBinding valueBinding = Util.getValueBinding(string);
        if (valueBinding != null) {
            try {
                object = valueBinding.getValue(FacesContext.getCurrentInstance());
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                Object[] objectArray = new Object[]{string};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUEREF_VALUE", objectArray));
            }
        } else {
            Object[] objectArray = new Object[]{string};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUE_BINDING", objectArray));
        }
        return object;
    }

    private boolean hasValidLifespan(String string) throws EvaluationException, ReferenceSyntaxException {
        String string2 = null;
        string2 = Util.isMixedVBExpression(string) ? this.getNarrowestScopeFromExpression(string) : this.getScopeForSingleExpression(string);
        if (this.scope == null || this.scope.equalsIgnoreCase("NONE")) {
            return string2 == null || string2.equalsIgnoreCase("NONE");
        }
        if (this.scope.equalsIgnoreCase("request")) {
            return true;
        }
        if (this.scope.equalsIgnoreCase("session")) {
            return string2 == null || !string2.equalsIgnoreCase("request");
        }
        if (this.scope.equalsIgnoreCase("application")) {
            return string2 == null || !string2.equalsIgnoreCase("request") && !string2.equalsIgnoreCase("session");
        }
        Util.doAssert(false);
        return false;
    }

    private String getScopeForSingleExpression(String string) throws ReferenceSyntaxException, EvaluationException {
        String[] stringArray = new String[1];
        String string2 = Util.getScope(string, stringArray);
        if (null == string2) {
            ManagedBeanFactory managedBeanFactory = null;
            if (null != stringArray[0] && null != (managedBeanFactory = (ManagedBeanFactory)this.getManagedBeanFactoryMap().get(stringArray[0]))) {
                string2 = managedBeanFactory.getScope();
            } else {
                log.logp(Level.FINER, CLASS_NAME, "getScopeForSingleExpression", "Unable to locate scope for value [" + string + "]");
            }
        }
        return string2;
    }

    private String getNarrowestScopeFromExpression(String string) throws ReferenceSyntaxException {
        List list = Util.getExpressionsFromString(string);
        Iterator iterator = list.iterator();
        Integer n = null;
        Integer n2 = null;
        String string2 = null;
        String string3 = null;
        while (iterator.hasNext()) {
            string2 = this.getScopeForSingleExpression((String)iterator.next());
            if (null == string2 || string2.equalsIgnoreCase("NONE")) continue;
            n2 = (Integer)scopeMap.get(string2);
            if (null == n) {
                n = n2;
                string3 = string2;
                continue;
            }
            if (n2 >= n) continue;
            n = n2;
            string3 = string2;
        }
        return string3;
    }

    public void setComponentAttribute(Object object, String string, Object object2) {
        ((UIComponent)object).getAttributes().put(string, object2);
    }
}

