/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationImpl;
import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class NavigationHandlerImpl
extends NavigationHandler {
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.application.NavigationHandlerImpl";
    private ApplicationImpl application = null;

    public NavigationHandlerImpl() {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "NavigationHandlerImpl", "Created NavigationHandler instance ");
        }
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = (ApplicationImpl)applicationFactory.getApplication();
    }

    public void handleNavigation(FacesContext facesContext, String string, String string2) {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (string2 == null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "No navigation rule found for outcome " + string2 + "and viewId " + facesContext.getViewRoot().getViewId() + " Explicitly remain on the current view ");
            }
            return;
        }
        CaseStruct caseStruct = this.getViewId(facesContext, string, string2);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (caseStruct != null) {
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            Util.doAssert(null != viewHandler);
            if (caseStruct.navCase.hasRedirect()) {
                String string3 = viewHandler.getActionURL(facesContext, caseStruct.viewId);
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "Redirecting to path " + string3 + " for outcome " + string2 + "and viewId " + caseStruct.viewId);
                    }
                    externalContext.redirect(string3);
                }
                catch (IOException iOException) {
                    String string4 = "Redirect to " + string3 + " failed.";
                    if (log.isLoggable(Level.SEVERE)) {
                        log.logp(Level.SEVERE, CLASS_NAME, "handleNavigation", string4);
                    }
                    throw new FacesException(string4, (Throwable)iOException);
                }
                facesContext.responseComplete();
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot uIViewRoot = viewHandler.createView(facesContext, caseStruct.viewId);
                facesContext.setViewRoot(uIViewRoot);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct getViewId(FacesContext facesContext, String string, String string2) {
        Object var4_4 = null;
        String string3 = facesContext.getViewRoot().getViewId();
        CaseStruct caseStruct = null;
        NavigationHandlerImpl navigationHandlerImpl = this;
        synchronized (navigationHandlerImpl) {
            caseStruct = this.findExactMatch(string3, string, string2);
            if (caseStruct == null) {
                caseStruct = this.findWildCardMatch(string3, string, string2);
            }
            if (caseStruct == null) {
                caseStruct = this.findDefaultMatch(string, string2);
            }
        }
        return caseStruct;
    }

    private synchronized CaseStruct findExactMatch(String string, String string2, String string3) {
        Object var4_4 = null;
        Map map = this.application.getNavigationCaseListMappings();
        Util.doAssert(null != map);
        List list = (List)map.get(string);
        if (list == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(list, string2, string3);
    }

    private synchronized CaseStruct findWildCardMatch(String string, String string2, String string3) {
        CaseStruct caseStruct = null;
        Map map = this.application.getNavigationCaseListMappings();
        Util.doAssert(null != map);
        TreeSet treeSet = this.application.getNavigationWildCardList();
        Util.doAssert(null != treeSet);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (string.indexOf(string4, 0) == -1) continue;
            String string5 = string4 + "*";
            List list = (List)map.get(string5);
            if (list == null) {
                return null;
            }
            caseStruct = this.determineViewFromActionOutcome(list, string2, string3);
            if (caseStruct == null) continue;
            break;
        }
        return caseStruct;
    }

    private synchronized CaseStruct findDefaultMatch(String string, String string2) {
        Object var3_3 = null;
        Map map = this.application.getNavigationCaseListMappings();
        Util.doAssert(null != map);
        List list = (List)map.get("*");
        if (list == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(list, string, string2);
    }

    private synchronized CaseStruct determineViewFromActionOutcome(List list, String string, String string2) {
        ConfigNavigationCase configNavigationCase;
        int n;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        CaseStruct caseStruct = new CaseStruct();
        for (n = 0; n < list.size(); ++n) {
            configNavigationCase = (ConfigNavigationCase)list.get(n);
            string3 = configNavigationCase.getFromAction();
            string4 = configNavigationCase.getFromOutcome();
            string5 = configNavigationCase.getToViewId();
            if (string3 == null || string4 == null || !string3.equals(string) || !string4.equals(string2)) continue;
            caseStruct.viewId = string5;
            caseStruct.navCase = configNavigationCase;
            return caseStruct;
        }
        for (n = 0; n < list.size(); ++n) {
            configNavigationCase = (ConfigNavigationCase)list.get(n);
            string3 = configNavigationCase.getFromAction();
            string4 = configNavigationCase.getFromOutcome();
            string5 = configNavigationCase.getToViewId();
            if (string3 != null && string3 != "*" || string4 == null || !string4.equals(string2)) continue;
            caseStruct.viewId = string5;
            caseStruct.navCase = configNavigationCase;
            return caseStruct;
        }
        for (n = 0; n < list.size(); ++n) {
            configNavigationCase = (ConfigNavigationCase)list.get(n);
            string3 = configNavigationCase.getFromAction();
            string4 = configNavigationCase.getFromOutcome();
            string5 = configNavigationCase.getToViewId();
            if (string3 == null || !string4.equals("*") || !string3.equals(string)) continue;
            caseStruct.viewId = string5;
            caseStruct.navCase = configNavigationCase;
            return caseStruct;
        }
        for (n = 0; n < list.size(); ++n) {
            configNavigationCase = (ConfigNavigationCase)list.get(n);
            string3 = configNavigationCase.getFromAction();
            string4 = configNavigationCase.getFromOutcome();
            string5 = configNavigationCase.getToViewId();
            if (!string3.equals("*") || !string4.equals("*")) continue;
            caseStruct.viewId = string5;
            caseStruct.navCase = configNavigationCase;
            return caseStruct;
        }
        return null;
    }

    class CaseStruct {
        String viewId;
        ConfigNavigationCase navCase;

        CaseStruct() {
        }
    }
}

