/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.ws.jsf.util.FacesMessages;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

public class FacesBeanUtils {
    private static final Map standardClasses = new HashMap();
    protected static Logger log;
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.FacesBeanUtils";

    public static Object convert(String string, Class clazz) {
        Object object = null;
        if (clazz.isPrimitive()) {
            clazz = (Class)standardClasses.get(clazz);
        }
        object = FacesBeanUtils.convertFromString(string, clazz);
        return object;
    }

    public static Object convertFromString(String string, Class clazz) {
        Object object = null;
        object = clazz.equals(Boolean.TYPE) ? Boolean.valueOf(string) : (clazz.equals(Byte.TYPE) ? Byte.valueOf(string) : (clazz.equals(Character.TYPE) ? new Character(string.charAt(0)) : (clazz.equals(Double.TYPE) ? Double.valueOf(string) : (clazz.equals(Float.TYPE) ? Float.valueOf(string) : (clazz.equals(Integer.TYPE) ? Integer.valueOf(string) : (clazz.equals(Long.TYPE) ? Long.valueOf(string) : (clazz.equals(Short.TYPE) ? Short.valueOf(string) : Beans.getInstanceOf(string, clazz))))))));
        return object;
    }

    public static void setProperty(Object object, String string, Object object2) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "setProperty", "property =[" + string + "] bean =[" + object + "] value =[" + object2 + "]");
        if (object == null || string == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{object, string, object2}));
        }
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string, object.getClass());
            Method method = propertyDescriptor.getWriteMethod();
            Object[] objectArray = new Object[]{object2};
            if (method == null || !FacesBeanUtils.paramsAssignableMatch(method, objectArray)) {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.write.method", new Object[]{string, object.getClass().getName()}));
            }
            method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.logp(Level.SEVERE, CLASS_NAME, "setProperty", "Failed to invoke method " + string);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.invoke.write.method", new Object[]{string, object.getClass().getName()}), (Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.logp(Level.SEVERE, CLASS_NAME, "setProperty", "Failed to access method " + string);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.access.write.method", new Object[]{string, object.getClass().getName()}), (Throwable)illegalAccessException);
        }
        catch (IntrospectionException introspectionException) {
            log.logp(Level.SEVERE, CLASS_NAME, "setProperty", "Failed to create property descriptor " + string);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.create.property.descriptor", new Object[]{string, object.getClass().getName()}), (Throwable)introspectionException);
        }
    }

    public static void setSimpleProperty(Object object, String string, Object object2) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "setSimpleProperty", "property =[" + string + "] bean =[" + object + "] value =[" + object2 + "]");
        if (object == null || string == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{object, string}));
        }
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string, object.getClass());
            Method method = propertyDescriptor.getWriteMethod();
            Object[] objectArray = new Object[]{object2};
            if (method == null || !FacesBeanUtils.paramsAssignableMatch(method, objectArray)) {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.write.method", new Object[]{string, object.getClass().getName()}));
            }
            method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.logp(Level.SEVERE, CLASS_NAME, "setSimpleProperty", "Failed to invoke write method " + string);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.invoke.write.method", new Object[]{string, object.getClass().getName()}), (Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.logp(Level.SEVERE, CLASS_NAME, "setSimpleProperty", "Failed to access write method " + string);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.access.write.method", new Object[]{string, object.getClass().getName()}), (Throwable)illegalAccessException);
        }
        catch (IntrospectionException introspectionException) {
            log.logp(Level.SEVERE, CLASS_NAME, "setSimpleProperty", "Failed to introspect write method " + string);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.introspect.write.method", new Object[]{string, object.getClass().getName()}), (Throwable)introspectionException);
        }
    }

    public static Class getPropertyType(Object object, String string) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "getPropertyType", "property =[" + string + "] bean =[" + object + "]");
        if (object == null || string == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{object, string}));
        }
        Class<?> clazz = null;
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string, object.getClass());
            if (propertyDescriptor == null) {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.property.descriptor", new Object[]{string, object.getClass().getName()}));
            }
            clazz = propertyDescriptor.getPropertyType();
        }
        catch (IntrospectionException introspectionException) {
            log.logp(Level.SEVERE, CLASS_NAME, "getPropertyType", "Failed to create property descriptor " + string, introspectionException);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.create.property.descriptor", new Object[]{string, object.getClass().getName()}), (Throwable)introspectionException);
        }
        log.logp(Level.FINER, CLASS_NAME, "getPropertyType", "propertyTypeClass =[" + clazz + "]");
        return clazz;
    }

    public static Object getProperty(Object object, String string) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "getProperty", "property =[" + string + "] bean =[" + object + "]");
        if (object == null || string == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{object, string}));
        }
        Object object2 = null;
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string, object.getClass());
            if (propertyDescriptor == null) {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.property.descriptor", new Object[]{string, object.getClass().getName()}));
            }
            Method method = propertyDescriptor.getReadMethod();
            object2 = method.invoke(object, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.logp(Level.SEVERE, CLASS_NAME, "getProperty", "Failed to invoke read method " + string, invocationTargetException);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.invoke.read.method", new Object[]{string, object.getClass().getName()}), (Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.logp(Level.SEVERE, CLASS_NAME, "getProperty", "Failed to access read method " + string, illegalAccessException);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.access.read.method", new Object[]{string, object.getClass().getName()}), (Throwable)illegalAccessException);
        }
        catch (IntrospectionException introspectionException) {
            log.logp(Level.SEVERE, CLASS_NAME, "getProperty", "Failed to create property descriptor " + string, introspectionException);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.create.property.descriptor", new Object[]{string, object.getClass().getName()}), (Throwable)introspectionException);
        }
        log.logp(Level.FINER, CLASS_NAME, "getProperty", "property =[" + object2 + "]");
        return object2;
    }

    private static boolean paramsAssignableMatch(Method method, Object[] objectArray) {
        Class<?>[] classArray = method.getParameterTypes();
        boolean bl = true;
        if (classArray.length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = FacesBeanUtils.getWrapperClass(classArray[i]);
            Object object = objectArray[i];
            if (object == null) continue;
            bl = clazz.isAssignableFrom(object.getClass());
        }
        return bl;
    }

    private static Class getWrapperClass(Class clazz) {
        if (clazz.isPrimitive()) {
            return (Class)standardClasses.get(clazz);
        }
        return clazz;
    }

    static {
        standardClasses.put(Boolean.TYPE, Boolean.class);
        standardClasses.put(Byte.TYPE, Byte.class);
        standardClasses.put(Character.TYPE, Character.class);
        standardClasses.put(Short.TYPE, Short.class);
        standardClasses.put(Integer.TYPE, Integer.class);
        standardClasses.put(Long.TYPE, Long.class);
        standardClasses.put(Float.TYPE, Float.class);
        standardClasses.put(Double.TYPE, Double.class);
        log = Logger.getLogger("com.ibm.ws.jsf");
    }
}

