/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import org.apache.soap.util.xml.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static String getAttribute(Element element, String string) {
        String string2 = null;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue();
        }
        return string2;
    }

    public static String getAttributeNS(Element element, String string, String string2) {
        String string3 = null;
        Attr attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            string3 = attr.getValue();
        }
        return string3;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Element getFirstChildElement(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element element) {
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element findChildElementWithAttribute(Element element, String string, String string2) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !string2.equals(DOMUtils.getAttribute((Element)node, string))) continue;
            return (Element)node;
        }
        return null;
    }

    public static int countKids(Element element, short s) {
        int n = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != s) continue;
            ++n;
        }
        return n;
    }

    public static String getNamespaceURIFromPrefix(Node node, String string) {
        short s = node.getNodeType();
        Node node2 = null;
        switch (s) {
            case 2: {
                node2 = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                node2 = node;
                break;
            }
            default: {
                node2 = node.getParentNode();
            }
        }
        while (node2 != null && node2.getNodeType() == 1) {
            String string2;
            Element element = (Element)node2;
            String string3 = string2 = string == null ? DOMUtils.getAttribute(element, "xmlns") : DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string);
            if (string2 != null) {
                return string2;
            }
            node2 = element.getParentNode();
        }
        return null;
    }

    public static Element getElementByID(Element element, String string) {
        if (element == null) {
            return null;
        }
        String string2 = element.getAttribute("id");
        if (string.equals(string2)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (element2 = DOMUtils.getElementByID((Element)node, string)) == null) continue;
            return element2;
        }
        return null;
    }

    public static QName getQualifiedAttributeValue(Element element, String string) throws IllegalArgumentException {
        return DOMUtils.getQualifiedAttributeValue(element, string, false);
    }

    public static QName getQualifiedAttributeValue(Element element, String string, boolean bl) throws IllegalArgumentException {
        String string2 = DOMUtils.getAttribute(element, string);
        if (string2 != null) {
            int n = string2.indexOf(58);
            String string3 = n != -1 ? string2.substring(0, n) : null;
            String string4 = string2.substring(n + 1);
            String string5 = DOMUtils.getNamespaceURIFromPrefix(element, string3);
            if (string5 == null && bl) {
                string5 = "";
            }
            if (string5 != null) {
                return new QName(string5, string4);
            }
            throw new IllegalArgumentException("Unable to determine namespace of '" + (string3 != null ? string3 + ":" : "") + string4 + "'.");
        }
        return null;
    }
}

