/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.soap.util.ObjectRegistry;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOM2Writer.serializeAsXML(node, stringWriter);
        return stringWriter.toString();
    }

    public static void serializeAsXML(Node node, Writer writer) {
        DOM2Writer.print(node, null, new PrintWriter(writer));
    }

    private static void print(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                printWriter.println("<?xml version=\"1.0\"?>");
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    DOM2Writer.print(nodeList.item(i), objectRegistry, printWriter);
                }
                break;
            }
            case 1: {
                NamedNodeMap namedNodeMap;
                objectRegistry = new ObjectRegistry(objectRegistry);
                printWriter.print('<' + node.getNodeName());
                String string = node.getPrefix();
                String string2 = node.getNamespaceURI();
                if (string != null && string2 != null) {
                    boolean bl2 = false;
                    try {
                        String string3 = (String)objectRegistry.lookup(string);
                        if (string2.equals(string3)) {
                            bl2 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl2) {
                        DOM2Writer.printNamespaceDecl(node, objectRegistry, printWriter);
                    }
                }
                int n = (namedNodeMap = node.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    printWriter.print(' ' + attr.getNodeName() + "=\"" + DOM2Writer.normalize(attr.getValue()) + '\"');
                    String string4 = attr.getPrefix();
                    String string5 = attr.getNamespaceURI();
                    if (string4 == null || string5 == null) continue;
                    boolean bl3 = false;
                    try {
                        String string6 = (String)objectRegistry.lookup(string4);
                        if (string5.equals(string6)) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (bl3) continue;
                    DOM2Writer.printNamespaceDecl(attr, objectRegistry, printWriter);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n2 = nodeList.getLength();
                    boolean bl4 = bl = n2 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    for (int i = 0; i < n2; ++i) {
                        DOM2Writer.print(nodeList.item(i), objectRegistry, printWriter);
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string);
                }
                printWriter.println("?>");
            }
        }
        if (s == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    private static void printNamespaceDecl(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, objectRegistry, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, objectRegistry, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element, Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        String string = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (!string.equals(NS_URI_XMLNS) || !string2.equals("xmlns")) {
            if (DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string2) == null) {
                printWriter.print(" xmlns:" + string2 + "=\"" + string + '\"');
            }
        } else {
            string2 = node.getLocalName();
            string = node.getNodeValue();
        }
        objectRegistry.register(string2, string);
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            continue block7;
                        }
                        stringBuffer.append('\n');
                        continue block7;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

