/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.mime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import org.apache.soap.util.mime.MimeUtils;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;

    public ByteArrayDataSource(File file, String string) throws IOException {
        this(new FileInputStream(file), string);
        if (this.type == null) {
            this.type = FileTypeMap.getDefaultFileTypeMap().getContentType(file);
        }
    }

    public ByteArrayDataSource(InputStream inputStream, String string) throws IOException {
        int n;
        this.type = string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.data = byteArrayOutputStream.toByteArray();
    }

    public ByteArrayDataSource(byte[] byArray, String string) {
        this.type = string;
        this.data = byArray;
    }

    public ByteArrayDataSource(String string, String string2) {
        this.type = string2;
        try {
            this.data = string.getBytes(MimeUtils.getEncoding(string2, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("No data.");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream() not supported.");
    }

    public String getContentType() {
        return this.type;
    }

    public void setContentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "";
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public int getSize() {
        if (this.data == null) {
            return -1;
        }
        return this.data.length;
    }

    public String getText() {
        try {
            return new String(this.data, MimeUtils.getEncoding(this.type, "iso-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return new String(this.data, "iso-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return null;
            }
        }
    }
}

