/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TransportMessage
implements Serializable {
    protected String contentType = null;
    protected int offset = 0;
    protected byte[] bytes = null;
    protected String envelope = null;
    protected Hashtable headers = null;
    protected SOAPContext ctx = null;

    public TransportMessage() {
    }

    public TransportMessage(String string, SOAPContext sOAPContext, Hashtable hashtable) throws IllegalArgumentException, MessagingException, IOException, SOAPException {
        this.envelope = string;
        this.ctx = sOAPContext;
        this.headers = hashtable != null ? hashtable : new Hashtable();
    }

    public TransportMessage(InputStream inputStream, int n, String string, SOAPContext sOAPContext, Hashtable hashtable) throws IllegalArgumentException, MessagingException, IOException, SOAPException {
        int n2;
        this.headers = hashtable != null ? hashtable : new Hashtable();
        this.ctx = sOAPContext;
        this.contentType = string;
        if (n < 0) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Content length must be specified.");
        }
        this.bytes = new byte[n];
        int n3 = 0;
        for (n2 = 0; n2 < n && n3 >= 0; n2 += n3) {
            n3 = inputStream.read(this.bytes, n2, n - n2);
        }
        if (n2 < n) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Premature end of stream. Data is truncated. Read " + n2 + " bytes successfully, expected " + n);
        }
    }

    public void editIncoming(EnvelopeEditor envelopeEditor) throws SOAPException, IOException, MessagingException {
        this.editEnvelope(envelopeEditor, true);
    }

    public void editOutgoing(EnvelopeEditor envelopeEditor) throws SOAPException, IOException, MessagingException {
        this.editEnvelope(envelopeEditor, false);
    }

    protected void editEnvelope(EnvelopeEditor envelopeEditor, boolean bl) throws SOAPException, IOException, MessagingException {
        if (envelopeEditor != null) {
            if (this.getEnvelope() == null) {
                return;
            }
            StringWriter stringWriter = new StringWriter();
            if (bl) {
                envelopeEditor.editIncoming(this.getEnvelopeReader(), stringWriter);
            } else {
                envelopeEditor.editOutgoing(this.getEnvelopeReader(), stringWriter);
            }
            stringWriter.flush();
            this.envelope = stringWriter.toString();
        }
    }

    public String read() throws IllegalArgumentException, MessagingException, IOException, SOAPException {
        byte[] byArray;
        ContentType contentType;
        Object object;
        ContentType contentType2 = null;
        try {
            int n = this.contentType.indexOf(";;");
            if (n != -1) {
                this.contentType = this.contentType.substring(0, n) + this.contentType.substring(n + 1);
            }
            contentType2 = new ContentType(this.contentType);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (contentType2 == null) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Missing content type.");
        }
        if (contentType2.match("multipart/*")) {
            object = new ByteArrayDataSource(this.bytes, this.contentType);
            this.ctx.readMultipart((DataSource)object);
            MimeBodyPart mimeBodyPart = this.ctx.getRootPart();
            contentType = new ContentType(mimeBodyPart.getContentType());
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(mimeBodyPart.getInputStream(), null);
            byArray = byteArrayDataSource.toByteArray();
        } else {
            byArray = this.bytes;
            contentType = contentType2;
            object = new ByteArrayDataSource(this.bytes, this.contentType);
            DataHandler dataHandler = new DataHandler((DataSource)object);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(dataHandler);
            this.ctx.addBodyPart(mimeBodyPart);
        }
        if (contentType.match("text/*")) {
            object = contentType.getParameter("charset");
            if (object == null || ((String)object).equals("")) {
                object = "iso-8859-1";
            }
            this.envelope = new String(byArray, MimeUtility.javaCharset((String)object));
        }
        return this.envelope;
    }

    public Envelope unmarshall(DocumentBuilder documentBuilder) throws SOAPException {
        Document document;
        try {
            document = documentBuilder.parse(new InputSource(this.getEnvelopeReader()));
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "parsing error: " + exception);
        }
        if (document == null) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "parsing error: received empty document");
        }
        return Envelope.unmarshall(document.getDocumentElement());
    }

    public void save() throws IllegalArgumentException, MessagingException, IOException {
        Object object;
        String string = null;
        if (this.ctx.isRootPartSet() && (object = this.ctx.getRootPart()) != null) {
            string = object.getHeader("Content-Type", null);
        }
        if (string == null) {
            string = "text/xml;charset=utf-8";
        }
        if (this.getEnvelope() != null) {
            this.ctx.setRootPart(this.envelope, string);
        }
        object = new ByteArrayOutputStream();
        this.ctx.writeTo((OutputStream)object);
        this.bytes = ((ByteArrayOutputStream)object).toByteArray();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = true;
        this.offset = 0;
        while (this.offset < this.bytes.length) {
            if (this.bytes[this.offset] == 10) {
                if (this.bytes[this.offset + 1] == 32 || this.bytes[this.offset + 1] == 9) {
                    while (this.bytes[++this.offset + 1] == 32 || this.bytes[this.offset + 1] == 9) {
                    }
                } else {
                    if (stringBuffer.length() == 0) {
                        ++this.offset;
                        break;
                    }
                    String string2 = stringBuffer.toString();
                    if (string2.equals("Content-Type")) {
                        this.contentType = stringBuffer2.toString();
                        if (this.ctx.getCount() > 1) {
                            String string3 = this.ctx.getRootPart().getContentID();
                            string3 = string3.substring(1, string3.length() - 1);
                            this.contentType = this.contentType + "; type=\"text/xml\"; start=\"" + string3 + '\"';
                        }
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    bl = true;
                }
            } else if (this.bytes[this.offset] != 13) {
                if (bl) {
                    if (this.bytes[this.offset] == 58) {
                        bl = false;
                        ++this.offset;
                    } else {
                        stringBuffer.append((char)this.bytes[this.offset]);
                    }
                } else {
                    stringBuffer2.append((char)this.bytes[this.offset]);
                }
            }
            ++this.offset;
        }
    }

    public SOAPContext getSOAPContext() {
        return this.ctx;
    }

    public String getEnvelope() throws MessagingException, IOException {
        MimeBodyPart mimeBodyPart;
        if (this.envelope == null && (mimeBodyPart = this.ctx.getRootPart()) != null && mimeBodyPart.isMimeType("text/*")) {
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(mimeBodyPart.getInputStream(), mimeBodyPart.getContentType());
            this.envelope = byteArrayDataSource.getText();
        }
        return this.envelope;
    }

    public Reader getEnvelopeReader() throws MessagingException, IOException {
        if (this.getEnvelope() == null) {
            return null;
        }
        return new StringReader(this.envelope);
    }

    public void setEnvelope(String string) {
        this.envelope = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public int getContentLength() {
        return this.bytes.length - this.offset;
    }

    public void setHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes, this.offset, this.bytes.length - this.offset);
        outputStream.flush();
    }

    public void setBytes(byte[] byArray) {
        this.offset = 0;
        this.bytes = byArray;
    }

    public void readFully(InputStream inputStream) throws IOException {
        this.offset = 0;
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(inputStream, null);
        this.bytes = byteArrayDataSource.toByteArray();
    }

    public byte[] getBytes() {
        if (this.offset != 0) {
            byte[] byArray = new byte[this.bytes.length - this.offset];
            System.arraycopy(this.bytes, this.offset, byArray, 0, byArray.length);
            this.bytes = byArray;
            this.offset = 0;
        }
        return this.bytes;
    }
}

