/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.File;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.DefaultConfigManager;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServiceManager {
    protected String configFilename = "soap.xml";
    protected DeploymentDescriptor smsdd;
    protected ConfigManager configMgr = null;
    protected ServletContext context = null;
    protected DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
    protected boolean soapInterfaceEnabled = true;
    static /* synthetic */ Class class$org$apache$soap$util$ConfigManager;

    public ServiceManager(ServletContext servletContext, String string) {
        this.context = servletContext;
        if (string != null && !string.equals("")) {
            this.configFilename = string;
        }
        this.readConfigFile();
        if (this.soapInterfaceEnabled) {
            this.smsdd = new DeploymentDescriptor();
            this.smsdd.setID("urn:xml-soap-service-management-service");
            String[] stringArray = new String[]{"deploy", "undeploy", "list", "query"};
            this.smsdd.setMethods(stringArray);
            this.smsdd.setScope(2);
            this.smsdd.setProviderType((byte)0);
            this.smsdd.setProviderClass("org.apache.soap.server.ServiceManager");
            this.smsdd.setIsStatic(false);
            this.smsdd.setMappings(new TypeMapping[]{new TypeMapping("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "DeploymentDescriptor"), "org.apache.soap.server.DeploymentDescriptor", "org.apache.soap.encoding.soapenc.BeanSerializer", "org.apache.soap.encoding.soapenc.BeanSerializer"), new TypeMapping("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "TypeMapping"), "org.apache.soap.server.TypeMapping", "org.apache.soap.server.TypeMappingSerializer", "org.apache.soap.server.TypeMappingSerializer")});
        }
    }

    public void setConfigFilename(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.configFilename = string;
        this.readConfigFile();
    }

    private void readConfigFile() {
        block12: {
            InputStreamReader inputStreamReader = null;
            Document document = null;
            Element element = null;
            NodeList nodeList = null;
            Hashtable<String, String> hashtable = null;
            try {
                File file = ServerHTTPUtils.getFileFromNameAndContext(this.configFilename, this.context);
                document = this.xdb.parse(new InputSource("file:///" + file.getAbsolutePath()));
                element = document.getDocumentElement();
                if (!"soapServer".equals(element.getTagName())) {
                    throw new Exception("Root element must be 'soapServer'");
                }
                nodeList = element.getChildNodes();
                for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
                    int n;
                    Object object;
                    Object object2;
                    String string = null;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    element = (Element)node;
                    string = element.getTagName();
                    if (string.equals("configManager")) {
                        object2 = element.getAttribute("value");
                        object = null;
                        Class<?> clazz = null;
                        if (!(class$org$apache$soap$util$ConfigManager == null ? ServiceManager.class$("org.apache.soap.util.ConfigManager") : class$org$apache$soap$util$ConfigManager).isAssignableFrom(clazz = (object = ServerHTTPUtils.getServletClassLoaderFromContext(this.context)) == null ? Class.forName((String)object2) : Class.forName((String)object2, true, (ClassLoader)object))) {
                            throw new IllegalArgumentException("Class '" + (String)object2 + "' isn't a ConfigManager.");
                        }
                        this.configMgr = (ConfigManager)clazz.newInstance();
                        this.configMgr.setContext(this.context);
                        NodeList nodeList2 = element.getElementsByTagName("option");
                        for (n = 0; nodeList2 != null && n < nodeList2.getLength(); ++n) {
                            element = (Element)nodeList2.item(n);
                            string = element.getAttribute("name");
                            String string2 = element.getAttribute("value");
                            if (hashtable == null) {
                                hashtable = new Hashtable<String, String>();
                            }
                            if (string == null || string2 == null) continue;
                            hashtable.put(string, string2);
                        }
                        if (hashtable == null) continue;
                        this.configMgr.setOptions(hashtable);
                        continue;
                    }
                    if (!string.equals("serviceManager")) continue;
                    object2 = element.getElementsByTagName("option");
                    for (n = 0; object2 != null && n < object2.getLength(); ++n) {
                        element = (Element)object2.item(n);
                        string = element.getAttribute("name");
                        object = element.getAttribute("value");
                        if (string == null || object == null || !string.equalsIgnoreCase("SOAPInterfaceEnabled") || !((String)object).equalsIgnoreCase("false")) continue;
                        this.soapInterfaceEnabled = false;
                    }
                }
                inputStreamReader.close();
            }
            catch (Throwable throwable) {
                if (inputStreamReader == null) break block12;
                System.err.println("Error processing configuration file (" + this.configFilename + ")");
                System.err.println("Error was: " + throwable);
                System.err.println("Using DefaultConfigManager");
            }
        }
        if (this.configMgr == null) {
            this.configMgr = new DefaultConfigManager();
            this.configMgr.setContext(this.context);
        }
        try {
            this.configMgr.init();
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
        }
    }

    public void deploy(DeploymentDescriptor deploymentDescriptor) throws SOAPException {
        String string = deploymentDescriptor.getID();
        if (string.equals("urn:xml-soap-service-management-service")) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "service management service 'urn:xml-soap-service-management-service' cannot be user deployed");
        }
        this.configMgr.deploy(deploymentDescriptor);
    }

    public DeploymentDescriptor undeploy(String string) throws SOAPException {
        return this.configMgr.undeploy(string);
    }

    public DeploymentDescriptor query(String string) throws SOAPException {
        if (string == null) {
            return null;
        }
        if (string.equals("urn:xml-soap-service-management-service")) {
            return this.smsdd;
        }
        DeploymentDescriptor deploymentDescriptor = this.configMgr.query(string);
        if (deploymentDescriptor != null) {
            return deploymentDescriptor;
        }
        throw new SOAPException(Constants.FAULT_CODE_SERVER, "service '" + string + "' unknown");
    }

    public String[] list() throws SOAPException {
        return this.configMgr.list();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

