/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class MessageFactory {
    static Class clz = null;
    private static final String DEFAULT_MESSAGE_FACTORY = "com.ibm.ws.webservices.engine.soap.MessageFactoryImpl";
    private static final String MESSAGE_FACTORY_PROPERTY = "javax.xml.soap.MessageFactory";

    public static MessageFactory newInstance() throws SOAPException {
        try {
            String factoryPropertyName = MESSAGE_FACTORY_PROPERTY;
            String defaultFactoryClassName = DEFAULT_MESSAGE_FACTORY;
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            String factoryClassName = System.getProperty(factoryPropertyName);
            if (factoryClassName == null) {
                String factoryResource = "META-INF/services/" + factoryPropertyName;
                InputStream inputstream = null;
                inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(factoryResource) : classloader.getResourceAsStream(factoryResource);
                if (inputstream != null) {
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                    factoryClassName = bufferedreader.readLine();
                    bufferedreader.close();
                }
            }
            if (factoryClassName == null) {
                factoryClassName = defaultFactoryClassName;
            }
            if (factoryClassName == null) {
                throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
            }
            Class<?> factoryClass = classloader == null ? Class.forName(factoryClassName) : classloader.loadClass(factoryClassName);
            Object factory = factoryClass.newInstance();
            return (MessageFactory)factory;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.MessageFactory.newInstance", (String)"157");
            throw new SOAPException("Unable to create message factory for SOAP: " + exception.getMessage());
        }
    }

    public abstract SOAPMessage createMessage() throws SOAPException;

    public abstract SOAPMessage createMessage(MimeHeaders var1, InputStream var2) throws IOException, SOAPException;
}

