/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import com.ibm.security.x509.SerialNumber;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.misc.HexDumpEncoder;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateInfo;
import sun.plugin.security.TableKeyActions;
import sun.plugin.util.DialogFactory;
import sun.plugin.util.PluginUIManager;
import sun.plugin.util.Trace;

public class CertificateDialog {
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private Component parentComponent;
    JTree certChainTree = null;
    final JTable certInfoTable = new JTable();
    final JTextArea textArea = new JTextArea();
    Object[] msg;
    Object[] options;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CertificateDialog(Certificate[] certificateArray, int n, int n2) {
        this(null, certificateArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateDialog(Component component, Certificate[] certificateArray, int n, int n2) {
        if (!($assertionsDisabled || certificateArray != null && n >= 0 && n2 >= 0 && n <= n2)) {
            throw new AssertionError();
        }
        LookAndFeel lookAndFeel = null;
        this.certInfoTable.registerKeyboardAction(TableKeyActions.decColumnAction, KeyStroke.getKeyStroke(114, 0), 0);
        this.certInfoTable.registerKeyboardAction(TableKeyActions.incColumnAction, KeyStroke.getKeyStroke(115, 0), 0);
        try {
            lookAndFeel = PluginUIManager.setTheme();
            this.certs = certificateArray;
            this.start = n;
            this.end = n2;
            this.parentComponent = component;
            UIManager.getBorder("TableHeader.cellBorder");
            UIManager.getBorder("Table.focusCellHighlightBorder");
            UIManager.getColor("Table.focusCellForeground");
            UIManager.getColor("Table.focusCellBackground");
            JTable jTable = new JTable();
            jTable.getDefaultRenderer(String.class);
            jTable.getDefaultRenderer(Object.class);
            if (certificateArray.length > n && certificateArray[n] instanceof X509Certificate) {
                Border border = BorderFactory.createEtchedBorder();
                this.certChainTree = this.buildCertChainTree(certificateArray, n, n2);
                this.certChainTree.addTreeSelectionListener(new TreeSelectionListener(){

                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CertificateDialog.this.certChainTree.getLastSelectedPathComponent();
                        CertificateDialog.this.certChainTree.getAccessibleContext().setAccessibleName(defaultMutableTreeNode.toString());
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        CertificateInfo certificateInfo = (CertificateInfo)defaultMutableTreeNode.getUserObject();
                        CertificateDialog.this.showCertificateInfo(certificateInfo.getCertificate());
                    }
                });
                this.showCertificateInfo((X509Certificate)certificateArray[n]);
                this.certInfoTable.setSelectionMode(0);
                ListSelectionModel listSelectionModel = this.certInfoTable.getSelectionModel();
                listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n = CertificateDialog.this.certInfoTable.getSelectedRow();
                        if (n == -1) {
                            return;
                        }
                        String string = (String)CertificateDialog.this.certInfoTable.getValueAt(n, 1);
                        CertificateDialog.this.textArea.setText(string);
                        CertificateDialog.this.textArea.getAccessibleContext().setAccessibleName(CertificateDialog.getMessage("cert_dialog.fieldDetails") + " " + CertificateDialog.this.textArea.getText());
                        CertificateDialog.this.textArea.getAccessibleContext().setAccessibleDescription(CertificateDialog.getMessage("cert_dialog.fieldDetails"));
                        CertificateDialog.this.textArea.repaint();
                    }
                });
                HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
                hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
                this.textArea.setFocusTraversalKeys(0, hashSet);
                hashSet.clear();
                hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
                this.textArea.setFocusTraversalKeys(1, hashSet);
                class FocusHandler
                extends FocusAdapter {
                    private JTextArea text;

                    public FocusHandler(JTextArea jTextArea) {
                        this.text = jTextArea;
                    }

                    public void focusGained(FocusEvent focusEvent) {
                        this.text.getCaret().setVisible(true);
                    }
                }
                this.textArea.addFocusListener(new FocusHandler(this.textArea));
                this.textArea.setLineWrap(false);
                this.textArea.setEditable(false);
                this.textArea.setColumns(40);
                this.textArea.setRows(15);
                this.certInfoTable.setRowSelectionInterval(6, 6);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                Dimension dimension = this.certInfoTable.getPreferredScrollableViewportSize();
                dimension.setSize(dimension.getWidth(), 120.0);
                this.certInfoTable.setPreferredScrollableViewportSize(dimension);
                JScrollPane jScrollPane = new JScrollPane(this.certInfoTable);
                jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), jScrollPane.getBorder()));
                jPanel.add((Component)jScrollPane, "Center");
                jPanel.add((Component)new JScrollPane(this.textArea), "South");
                jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                dimension = this.certChainTree.getPreferredScrollableViewportSize();
                dimension.setSize(200.0, 100.0);
                jScrollPane = new JScrollPane(this.certChainTree);
                jScrollPane.setPreferredSize(dimension);
                jPanel2.add((Component)jScrollPane, "West");
                jPanel2.add((Component)jPanel, "East");
                this.msg = new Object[]{jPanel2};
                JButton jButton = new JButton(CertificateDialog.getMessage("cert_dialog.close"));
                jButton.setMnemonic(CertificateDialog.getAcceleratorKey("cert_dialog.close"));
                jButton.getAccessibleContext().setAccessibleName(CertificateDialog.getMessage("cert_dialog.close"));
                this.options = new Object[]{jButton};
            }
        }
        finally {
            PluginUIManager.restoreTheme(lookAndFeel);
        }
    }

    public void DoModal() {
        if (!Trace.isAutomationEnabled()) {
            DialogFactory.showOptionDialog(this.parentComponent, (Object)this.msg, CertificateDialog.getMessage("cert_dialog.caption"), this.options, this.options[0]);
        }
    }

    private String formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c == ',' && !bl2) {
                stringBuffer.append(",\n");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private JTree buildCertChainTree(Certificate[] certificateArray, int n, int n2) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = n; i < certificateArray.length && i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)certificateArray[i]));
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = defaultMutableTreeNode3;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                continue;
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        return jTree;
    }

    private void showCertificateInfo(X509Certificate x509Certificate) {
        String string = "V" + x509Certificate.getVersion();
        SerialNumber serialNumber = new SerialNumber(x509Certificate.getSerialNumber());
        String string2 = "[" + serialNumber.getNumber() + "]";
        String string3 = "[" + x509Certificate.getSigAlgName() + "]";
        String string4 = this.formatDNString(((Object)x509Certificate.getIssuerDN()).toString());
        String string5 = "[From: " + x509Certificate.getNotBefore() + ",\n To: " + x509Certificate.getNotAfter() + "]";
        String string6 = this.formatDNString(((Object)x509Certificate.getSubjectDN()).toString());
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string7 = hexDumpEncoder.encodeBuffer(x509Certificate.getSignature());
        Object[][] objectArray = new Object[][]{{CertificateDialog.getMessage("cert_dialog.field.Version"), string}, {CertificateDialog.getMessage("cert_dialog.field.SerialNumber"), string2}, {CertificateDialog.getMessage("cert_dialog.field.SignatureAlg"), string3}, {CertificateDialog.getMessage("cert_dialog.field.Issuer"), string4}, {CertificateDialog.getMessage("cert_dialog.field.Validity"), string5}, {CertificateDialog.getMessage("cert_dialog.field.Subject"), string6}, {CertificateDialog.getMessage("cert_dialog.field.Signature"), string7}};
        Object[] objectArray2 = new String[]{CertificateDialog.getMessage("cert_dialog.field"), CertificateDialog.getMessage("cert_dialog.value")};
        this.certInfoTable.setModel(new DefaultTableModel(objectArray, objectArray2){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        this.certInfoTable.getTableHeader().setReorderingAllowed(false);
        int n = this.certInfoTable.getColumnModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.certInfoTable.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component instanceof Component) {
                        component.getAccessibleContext().setAccessibleName(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                        component.getAccessibleContext().setAccessibleDescription(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                    }
                    return component;
                }
            });
        }
        this.certInfoTable.setRowSelectionInterval(6, 6);
        this.certInfoTable.repaint();
        this.textArea.repaint();
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceHandler.getAcceleratorKey(string);
    }

    static {
        $assertionsDisabled = !CertificateDialog.class.desiredAssertionStatus();
    }
}

