/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.proxy;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;
import sun.applet.AppletPanel;
import sun.plugin.net.protocol.http.HttpURLConnection;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.ProxyConfigException;
import sun.plugin.net.proxy.ProxyHandler;
import sun.plugin.net.proxy.ProxyInfo;
import sun.plugin.net.proxy.RemoveCommentReader;
import sun.plugin.services.BrowserService;
import sun.plugin.services.ServiceProvider;
import sun.plugin.services.ServiceUnavailableException;
import sun.plugin.util.Trace;
import sun.plugin.viewer.AppletPanelCache;
import sun.plugin.viewer.context.PluginAppletContext;

public class AutoProxyHandler
implements ProxyHandler {
    private BrowserProxyInfo bpi = null;
    private StringBuffer autoProxyScript = null;

    public boolean isSupported(int n) {
        return n == 2;
    }

    public boolean isProxyCacheSupported() {
        return true;
    }

    public void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        Object object;
        Trace.msgNetPrintln("net.proxy.loading.auto");
        if (!this.isSupported(browserProxyInfo.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + browserProxyInfo.getType());
        }
        this.bpi = browserProxyInfo;
        BrowserService browserService = ServiceProvider.getService();
        this.autoProxyScript = new StringBuffer();
        this.autoProxyScript.append("var _mon = new Array('JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC');var _day = new Array('SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT');function _isGmt(i) { return typeof i == 'string' && i == 'GMT'; }");
        this.autoProxyScript.append("function dnsDomainIs(host, domain) {if (domain != null && domain.charAt(0) != '.')return false;return shExpMatch(host, '*' + domain); }");
        this.autoProxyScript.append("function isPlainHostName(host){return (dnsDomainLevels(host) == 0); }");
        if (browserService.isIExplorer()) {
            this.autoProxyScript.append("function isInNet(host, pattern, mask){if (typeof host != 'string' || typeof pattern != 'string' || typeof mask != 'string') return false; if (dnsDomainLevels(pattern) != 3 || dnsDomainLevels(mask) != 3)return false;var hostInIpFormat = dnsResolve(host);var offset1 = 0, offset2 = 0, ofs1 = 0, ofs2 = 0;var m = '', result;for (var i=0; i < 4; i++){ofs1 = pattern.indexOf('.', offset1);ofs2 = mask.indexOf('.', offset2);if (i != 3)result = (pattern.substring(offset1, ofs1) - 0) & (mask.substring(offset2, ofs2) - 0);else result = (pattern.substring(offset1) & mask.substring(offset2));if (result == 0)result = '*';m = m + result;if (i != 3)m = m + '.';offset1 = ofs1 + 1;offset2 = ofs2 + 1;}return shExpMatch(hostInIpFormat, m); }");
            this.autoProxyScript.append("function dnsResolve(host){if (typeof host != 'string') return ''; var isIpFormat = false;if (dnsDomainLevels(host) == 3){for (var i=0; i < host.length; i++){if ((host.charAt(i) >= '0' && host.charAt(i) <= '9') || host.charAt(i) == '.') isIpFormat = true;else {isIpFormat = false;break;}}}if (isIpFormat == true) return host;else {var jpi = new ActiveXObject('JavaPlugin');return jpi.dnsResolve(host);}}");
        } else {
            this.autoProxyScript.append("function isInNet(host, pattern, mask){if (typeof host != 'string' || typeof pattern != 'string' || typeof mask != 'string') return false; if (dnsDomainLevels(pattern) != 3 || dnsDomainLevels(mask) != 3)return false;var offset1 = 0, offset2 = 0, ofs1 = 0, ofs2 = 0;var m = '', result;for (var i=0; i < 4; i++){ofs1 = pattern.indexOf('.', offset1);ofs2 = mask.indexOf('.', offset2);if (i != 3)result = (pattern.substring(offset1, ofs1) - 0) & (mask.substring(offset2, ofs2) - 0);else result = (pattern.substring(offset1) & mask.substring(offset2));if (result == 0)result = '*';m = m + result;if (i != 3)m = m + '.';offset1 = ofs1 + 1;offset2 = ofs2 + 1;}return shExpMatch(host, m); }");
            this.autoProxyScript.append("function dnsResolve(host){if (typeof host != 'string' || dnsDomainLevels(host) != 3) return ''; for (var i=0; i < host.length; i++) if ((host.charAt(i) < '0' || host.charAt(i) > '9') && host.charAt(i) != '.') return ''; return host; }");
        }
        this.autoProxyScript.append("function isResolvable(host){return (dnsResolve(host) != ''); }");
        this.autoProxyScript.append("function localHostOrDomainIs(host, hostdom){return shExpMatch(hostdom, host + '*'); }");
        this.autoProxyScript.append("function dnsDomainLevels(host){var s = host + '';for (var i=0, j=0; i < s.length; i++)if (s.charAt(i) == '.')j++;return j; }");
        this.autoProxyScript.append("function myIpAddress(){return '");
        try {
            object = InetAddress.getLocalHost();
            this.autoProxyScript.append(((InetAddress)object).getHostAddress());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.autoProxyScript.append("127.0.0.1");
        }
        this.autoProxyScript.append("'; }");
        this.autoProxyScript.append("function shExpMatch(str, shexp){  if (typeof str != 'string' || typeof shexp != 'string') return false;  if (shexp == '*') return true;  if (str == '' && shexp == '') return true;  str = str.toLowerCase(); shexp = shexp.toLowerCase(); var index = shexp.indexOf('*'); if (index == -1) { return (str == shexp); }  else if (index == 0) {  for (var i=0; i <= str.length; i++) {  if (shExpMatch(str.substring(i), shexp.substring(1))) return true;  } return false; } else { var sub = null, sub2 = null; sub = shexp.substring(0, index);if (index <= str.length) sub2 = str.substring(0, index); if (sub != '' && sub2 != '' && sub == sub2) { return shExpMatch(str.substring(index), shexp.substring(index)); }else {\treturn false; }} }");
        this.autoProxyScript.append("function _dateRange(day1, month1, year1, day2, month2, year2, gmt){if (typeof day1 != 'number' || day1 <= 0 || typeof month1 != 'string' || typeof year1 != 'number' || year1 <= 0 || typeof day2 != 'number' || day2 <= 0 || typeof month2 != 'string' || typeof year2 != 'number' || year2 <= 0 || typeof gmt != 'boolean') return false; var m1 = -1, m2 = -1;for (var i=0; i < _mon.length; i++){if (_mon[i] == month1)m1 = i;if (_mon[i] == month2)m2 = i;}var cur = new Date();var d1 = new Date(year1, m1, day1, 0, 0, 0);var d2 = new Date(year2, m2, day2, 23, 59, 59);if (gmt == true)cur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);return ((d1.getTime() <= cur.getTime()) && (cur.getTime() <= d2.getTime()));}function dateRange(p1, p2, p3, p4, p5, p6, p7){var cur = new Date();if (typeof p1 == 'undefined')return false;else if (typeof p2 == 'undefined' || _isGmt(p2)){if ((typeof p1) == 'string')return _dateRange(1, p1, cur.getFullYear(), 31, p1, cur.getFullYear(), _isGmt(p2));else if (typeof p1 == 'number' && p1 > 31)return _dateRange(1, 'JAN', p1, 31, 'DEC', p1, _isGmt(p2));else {for (var i=0; i < _mon.length; i++)if (_dateRange(p1, _mon[i], cur.getFullYear(), p1, _mon[i], cur.getFullYear(), _isGmt(p2))) return true;return false;}}else if (typeof p3 == 'undefined' || _isGmt(p3)){if ((typeof p1) == 'string')return _dateRange(1, p1, cur.getFullYear(), 31, p2, cur.getFullYear(), _isGmt(p3));else if (typeof p1 == 'number' && typeof p2 == 'number' && (p1 > 31 || p2 > 31))return _dateRange(1, 'JAN', p1, 31, 'DEC', p2, _isGmt(p3));else {if ((typeof p2) == 'string'){return _dateRange(p1, p2, cur.getFullYear(), p1, p2, cur.getFullYear(), _isGmt(p3));}else {for (var i=0; i < _mon.length; i++)if (_dateRange(p1, _mon[i], cur.getFullYear(), p2, _mon[i], cur.getFullYear(), _isGmt(p3)))return true;return false;}}}else if (typeof p4 == 'undefined' || _isGmt(p4))return _dateRange(p1, p2, p3, p1, p2, p3, _isGmt(p4));else if (typeof p5 == 'undefined' || _isGmt(p5)){if (typeof p2 == 'number')return _dateRange(1, p1, p2, 31, p3, p4, _isGmt(p5));else return _dateRange(p1, p2, cur.getFullYear(), p3, p4, cur.getFullYear(), _isGmt(p5))}else if (typeof p6 == 'undefined')return false;else return _dateRange(p1, p2, p3, p4, p5, p6, _isGmt(p7));}");
        this.autoProxyScript.append("function timeRange(p1, p2, p3, p4, p5, p6, p7) {if (typeof p1 == 'undefined')return false;else if (typeof p2 == 'undefined' || _isGmt(p2))return _timeRange(p1, 0, 0, p1, 59, 59, _isGmt(p2));else if (typeof p3 == 'undefined' || _isGmt(p3))return _timeRange(p1, 0, 0, p2, 0, 0, _isGmt(p3));else if (typeof p4 == 'undefined')return false;else if (typeof p5 == 'undefined' || _isGmt(p5))return _timeRange(p1, p2, 0, p3, p4, 0, _isGmt(p5));else if (typeof p6 == 'undefined')return false;else return _timeRange(p1, p2, p3, p4, p5, p6, _isGmt(p7));}function _timeRange(hour1, min1, sec1, hour2, min2, sec2, gmt) {if (typeof hour1 != 'number' || typeof min1 != 'number' || typeof sec1 != 'number' || hour1 < 0 || min1 < 0 || sec1 < 0 || typeof hour2 != 'number' || typeof min2 != 'number' || typeof sec2 != 'number' || hour2 < 0 || min2 < 0 || sec2 < 0 || typeof gmt != 'boolean')  return false; var cur = new Date();var d1 = new Date();var d2 = new Date();d1.setHours(hour1);d1.setMinutes(min1);d1.setSeconds(sec1);d2.setHours(hour2);d2.setMinutes(min2);d2.setSeconds(sec2);if (gmt == true)cur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);return ((d1.getTime() <= cur.getTime()) && (cur.getTime() <= d2.getTime()));}");
        this.autoProxyScript.append("function weekdayRange(wd1, wd2, gmt){if (typeof wd1 == 'undefined') return false;else if (typeof wd2 == 'undefined' || _isGmt(wd2)) return _weekdayRange(wd1, wd1, _isGmt(wd2)); else return _weekdayRange(wd1, wd2, _isGmt(gmt)); }function _weekdayRange(wd1, wd2, gmt) {if (typeof wd1 != 'string' || typeof wd2 != 'string' || typeof gmt != 'boolean') return false; var w1 = -1, w2 = -1;for (var i=0; i < _day.length; i++) {if (_day[i] == wd1)w1 = i;if (_day[i] == wd2)w2 = i; }var cur = new Date();if (gmt == true)cur = new Date(cur.getTime() - cur.getTimezoneOffset() * 60 * 1000);var w3 = cur.getDay();if (w1 > w2)w2 = w2 + 7;if (w1 > w3)w3 = w3 + 7;return (w1 <= w3 && w3 <= w2); }");
        object = this.bpi.getAutoConfigURL();
        try {
            URL uRL = new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ProxyConfigException("Auto config URL is malformed");
        }
        if (((String)object).toLowerCase().endsWith(".ins")) {
            object = this.getAutoConfigURLFromINS((String)object);
        }
        this.autoProxyScript.append(this.getJSFileFromURL((String)object));
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    public ProxyInfo[] getProxyInfo(URL uRL) throws ServiceUnavailableException {
        if (!AppletPanelCache.hasValidInstance()) {
            throw new ServiceUnavailableException("Proxy service unavailable");
        }
        Object[] objectArray = AppletPanelCache.getAppletPanels();
        AppletPanel appletPanel = (AppletPanel)objectArray[0];
        PluginAppletContext pluginAppletContext = (PluginAppletContext)appletPanel.getAppletContext();
        String string = null;
        try {
            JSObject jSObject = pluginAppletContext.getJSObject();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.autoProxyScript);
            stringBuffer.append("FindProxyForURL('");
            stringBuffer.append(uRL);
            stringBuffer.append("','");
            stringBuffer.append(uRL.getHost());
            stringBuffer.append("');");
            string = (String)jSObject.eval(stringBuffer.toString());
            return this.extractAutoProxySetting(string);
        }
        catch (Throwable throwable) {
            Trace.msgNetPrintln("net.proxy.auto.result.error");
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    private String fileurlNormalize(String string) {
        if (!string.startsWith("file")) {
            return string;
        }
        int n = string.indexOf(47);
        while (string.charAt(++n) == '/') {
        }
        return "file:/" + string.substring(n);
    }

    private String getAutoConfigURLFromINS(String string) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.auto.download.ins", new Object[]{string});
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            URLConnection uRLConnection = null;
            if (string2.equals("file")) {
                uRL = new URL(this.fileurlNormalize(string));
                uRLConnection = uRL.openConnection();
            } else {
                uRLConnection = new HttpURLConnection(uRL, null, -1, false);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string3 = null;
            String string4 = null;
            do {
                if ((string3 = bufferedReader.readLine()) == null || string3.indexOf("AutoConfigJSURL=") != 0) continue;
                string4 = string3.substring(16);
                break;
            } while (string3 != null);
            bufferedReader.close();
            if (string4 != null) {
                return string4;
            }
            throw new ProxyConfigException("Unable to locate 'AutoConfigJSURL' in INS file");
        }
        catch (ProxyConfigException proxyConfigException) {
            throw proxyConfigException;
        }
        catch (Throwable throwable) {
            throw new ProxyConfigException("Unable to obtain INS file from " + string, throwable);
        }
    }

    private String getJSFileFromURL(String string) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.auto.download.js", new Object[]{string});
        try {
            int n;
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            URLConnection uRLConnection = null;
            if (string2.equals("file")) {
                uRL = new URL(this.fileurlNormalize(string));
                uRLConnection = uRL.openConnection();
            } else {
                uRLConnection = new HttpURLConnection(uRL, null, -1, false);
            }
            RemoveCommentReader removeCommentReader = new RemoveCommentReader(new InputStreamReader(uRLConnection.getInputStream()));
            BufferedReader bufferedReader = new BufferedReader(removeCommentReader);
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            bufferedReader.close();
            ((Reader)removeCommentReader).close();
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (Throwable throwable) {
            throw new ProxyConfigException("Unable to obtain auto proxy file from " + string, throwable);
        }
    }

    private ProxyInfo[] extractAutoProxySetting(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            ProxyInfo[] proxyInfoArray = new ProxyInfo[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf("PROXY");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(string2.substring(n2 + 6));
                    continue;
                }
                n2 = string2.indexOf("SOCKS");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(null, string2.substring(n2 + 6));
                    continue;
                }
                proxyInfoArray[n++] = new ProxyInfo(null, -1);
            }
            return proxyInfoArray;
        }
        return new ProxyInfo[]{new ProxyInfo(null)};
    }
}

