/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters.streams;

import com.ibm.vap.converters.VapAbstractConverter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Vector;

abstract class VapStreamToObjectConverter
extends VapAbstractConverter {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 2000";

    VapStreamToObjectConverter() {
    }

    protected byte[] bytesFromInputStream(InputStream stream) {
        byte[] rawBytes = null;
        int rawBytesLength = 0;
        try {
            int bytesRead = 0;
            Vector<byte[]> byteBuffers = new Vector<byte[]>();
            Vector<Integer> byteBufferLengths = new Vector<Integer>();
            while (bytesRead != -1) {
                byte[] nextRawBytes = new byte[2000];
                bytesRead = stream.read(nextRawBytes);
                if (bytesRead <= 0) continue;
                rawBytesLength += bytesRead;
                byteBuffers.addElement(nextRawBytes);
                byteBufferLengths.addElement(new Integer(bytesRead));
            }
            if (rawBytesLength > 0) {
                rawBytes = new byte[rawBytesLength];
                int rawBytesPosition = 0;
                int byteBufferCount = byteBuffers.size();
                int i = 0;
                while (i < byteBufferCount) {
                    byte[] bytes = (byte[])byteBuffers.elementAt(i);
                    bytesRead = (Integer)byteBufferLengths.elementAt(i);
                    int j = 0;
                    while (j < bytesRead) {
                        rawBytes[rawBytesPosition + j] = bytes[j];
                        ++j;
                    }
                    rawBytesPosition += bytesRead;
                    ++i;
                }
            }
        }
        catch (IOException exc) {
            RuntimeException rtExc = new RuntimeException(exc.getMessage());
            rtExc.fillInStackTrace();
            throw rtExc;
        }
        return rawBytes;
    }

    public static String[] getSourceDatatype() {
        return VapStreamToObjectConverter.getStringDatatypes();
    }

    protected String stringFromClob(Clob aClob) {
        try {
            return aClob.getSubString(1L, (int)aClob.length());
        }
        catch (SQLException exc) {
            RuntimeException rtExc = new RuntimeException(exc.getMessage());
            rtExc.fillInStackTrace();
            throw rtExc;
        }
    }
}

