/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters.streams;

import com.ibm.vap.converters.streams.ContextObjectInputStream;
import com.ibm.vap.converters.streams.VapBinaryStreamToObjectConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;

public class VapBinaryStreamToSerializableObjectConverter
extends VapBinaryStreamToObjectConverter {
    static VapBinaryStreamToSerializableObjectConverter singleton = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2000";

    public Object dataFrom(Object anObject) {
        if (anObject == null) {
            return null;
        }
        byte[] result = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
            objStream.writeObject(anObject);
            objStream.flush();
            result = byteStream.toByteArray();
        }
        catch (Exception exc) {
            RuntimeException rtExc = new RuntimeException(exc.getMessage());
            rtExc.fillInStackTrace();
            throw rtExc;
        }
        return result;
    }

    public static String getTargetClassName() {
        return "java.io.Serializable";
    }

    public Object objectFrom(Object aField) {
        if (aField == null) {
            return null;
        }
        Object result = null;
        try {
            InputStream stream = null;
            stream = aField instanceof InputStream ? (InputStream)aField : (aField instanceof Blob ? ((Blob)aField).getBinaryStream() : new ByteArrayInputStream((byte[])aField));
            ContextObjectInputStream objStream = new ContextObjectInputStream(stream);
            result = objStream.readObject();
        }
        catch (Exception exc) {
            RuntimeException rtExc = new RuntimeException(exc.getMessage());
            rtExc.fillInStackTrace();
            throw rtExc;
        }
        return result;
    }

    public static void reset() {
        singleton = null;
    }

    public static VapBinaryStreamToSerializableObjectConverter singleton() {
        if (singleton == null) {
            singleton = new VapBinaryStreamToSerializableObjectConverter();
        }
        return singleton;
    }
}

