/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workarea;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentInitializationCollaborator;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.websphere.workarea.PartitionAlreadyExistsException;
import com.ibm.websphere.workarea.UserWorkArea;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.asynchbeans.AsynchBeansServiceCollaborator;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.util.AsynchBeansInvocationService;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import com.ibm.ws.workarea.ServiceWithContextImpl;
import com.ibm.ws.workarea.WorkAreaEJBCollaborator;
import com.ibm.ws.workarea.WorkAreaMessages;
import com.ibm.ws.workarea.WorkAreaPartitionManagerImpl;
import com.ibm.ws.workarea.WorkAreaService;
import com.ibm.ws.workarea.WorkAreaWebCollaborator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.eclipse.emf.common.util.EList;

public class WorkAreaServiceServer
extends ComponentImpl
implements PropertyChangeListener {
    private static final TraceComponent _tc = Tr.register((Class)WorkAreaServiceServer.class, null, (String)"com.ibm.ws.workarea.resources.acwa");
    private UserWorkArea _currentWorkArea = null;
    private int _maxSendSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
    private int _maxReceiveSize = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE;
    private boolean _enabled = true;
    private static Hashtable userPartitionProps;
    private static Vector names;
    private boolean _initialized = false;
    Properties userWorkAreaConfigurationProps = new Properties();

    public WorkAreaServiceServer() {
        this.userWorkAreaConfigurationProps.setProperty("cacheable", "false");
        this.userWorkAreaConfigurationProps.setProperty("maxSendSize", WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING);
        this.userWorkAreaConfigurationProps.setProperty("maxReceiveSize", WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING);
        this.userWorkAreaConfigurationProps.setProperty("Bidirectional", "false");
        this.userWorkAreaConfigurationProps.setProperty("isContextCORBAInteroperable", "true");
        this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", "false");
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        block13: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)"initialize", (Object)object);
            }
            WorkAreaService.setIsClientProcess(false);
            if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"WorkAreaServiceServer disabled in z/OS CRA.");
                }
                throw new ComponentDisabledException();
            }
            try {
                if (object instanceof com.ibm.websphere.models.config.workareaservice.WorkAreaService) {
                    com.ibm.websphere.models.config.workareaservice.WorkAreaService workAreaService = (com.ibm.websphere.models.config.workareaservice.WorkAreaService)object;
                    this._maxReceiveSize = workAreaService.getMaxReceiveSize();
                    this._maxSendSize = workAreaService.getMaxSendSize();
                    this._enabled = workAreaService.isEnable();
                    this.userWorkAreaConfigurationProps.setProperty("maxSendSize", new Integer(this._maxSendSize).toString());
                    this.userWorkAreaConfigurationProps.setProperty("maxReceiveSize", new Integer(this._maxReceiveSize).toString());
                    WorkAreaService.setEnabled(this._enabled);
                    EList eList = workAreaService.getProperties();
                    if (eList != null) {
                        this.processAdminConsoleProperties((List)eList);
                    }
                    break block13;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"parm is wrong type!  Going to use defaults!");
                }
                WorkAreaService.setEnabled(this._enabled);
                ConfigurationWarning configurationWarning = new ConfigurationWarning("");
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"initialize", (Object)("Throwing: " + configurationWarning));
                }
                throw configurationWarning;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.initialize", (String)"98", (Object)this);
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"initialize", (Object)exception);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"initialize", (Object)exception);
                }
                ConfigurationWarning configurationWarning = new ConfigurationWarning("");
                configurationWarning.initCause((Throwable)exception);
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"initialize", (Object)("Throwing: " + configurationWarning));
                }
                throw configurationWarning;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"initialize");
        }
    }

    public void start() {
        InitialContext initialContext;
        Server server;
        boolean bl;
        block39: {
            block37: {
                EJBContainer eJBContainer;
                block36: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)_tc, (String)"start");
                    }
                    if (this._initialized) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"Already initialized; returning");
                        }
                        if (_tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)_tc, (String)"start");
                        }
                        return;
                    }
                    this._initialized = true;
                    bl = true;
                    WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
                    workAreaPartitionManagerImpl.setServiceImlpRef(this);
                    server = (Server)this.getService(Server.class);
                    if (server != null) {
                        WorkAreaService.setServerName(server.getName());
                    }
                    eJBContainer = (EJBContainer)this.getService(EJBContainer.class);
                    if (this._enabled) {
                        try {
                            this._currentWorkArea = workAreaPartitionManagerImpl.createWorkAreaPartition(WorkAreaService.getServiceName(), this.userWorkAreaConfigurationProps);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"start", (Object)("Created partition " + WorkAreaService.getServiceName()));
                            }
                        }
                        catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                            FFDCFilter.processException((Throwable)partitionAlreadyExistsException, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.start", (String)"143", (Object)this);
                            bl = false;
                            if (_tc.isEventEnabled()) {
                                Tr.event((TraceComponent)_tc, (String)"start", (Object)partitionAlreadyExistsException);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"start", (Object)("The partition \"" + WorkAreaService.getServiceName() + "\" already has been defined."));
                            }
                            Tr.error((TraceComponent)_tc, (String)"ERR_PARTITION_ALREADY_EXISTS", (Object)WorkAreaService.getServiceName());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.start", (String)"149", (Object)this);
                            bl = false;
                            if (_tc.isEventEnabled()) {
                                Tr.event((TraceComponent)_tc, (String)"start", (Object)illegalAccessException);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"start", (Object)"Initialization complete, can't create a new partition.");
                            }
                            Tr.error((TraceComponent)_tc, (String)WorkAreaMessages.getMsg("INF_INITIALIZATION_COMPLETE", new Object[]{WorkAreaService.getServerName(), WorkAreaService.getServiceName()}));
                        }
                        if (this._currentWorkArea == null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"start", (Object)"The WorkArea returned by the PartitionManager is null!");
                            }
                            bl = false;
                        } else {
                            WorkAreaService.setUserWorkArea(this._currentWorkArea);
                        }
                    } else {
                        Tr.audit((TraceComponent)_tc, (String)"INF_WA_NOT_ENABLED", (Object)WorkAreaService.getServerName());
                    }
                    try {
                        initialContext = new InitialContext();
                        JndiHelper.recursiveRebind((Context)initialContext, (String)"services:websphere/WorkAreaPartitionManager", (Object)workAreaPartitionManagerImpl);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"start", (Object)"Bound the WorkAreaPartitionManager");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.start", (String)"177", (Object)this);
                        bl = false;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"Could not bind the WorkAreaPartitionManager on the server");
                        }
                        if (!_tc.isDebugEnabled()) break block36;
                        Tr.debug((TraceComponent)_tc, (String)"start", (Object)exception);
                    }
                }
                try {
                    eJBContainer.addCollaborator((EJBComponentInitializationCollaborator)WorkAreaEJBCollaborator.getInstance());
                    this.releaseService(eJBContainer);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"start", (Object)"BeforeActivationCollaborator added to ejb container");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.start", (String)"194", (Object)this);
                    bl = false;
                    exception.printStackTrace();
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"start", (Object)exception);
                    }
                    if (!_tc.isDebugEnabled()) break block37;
                    Tr.debug((TraceComponent)_tc, (String)"start", (Object)exception);
                }
            }
            try {
                block38: {
                    initialContext = (WebContainerService)this.getService(WebContainerService.class);
                    try {
                        initialContext.addWebAppCollaborator((WebAppCollaborator)WorkAreaWebCollaborator.getInstance());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"start", (Object)"WebAppInitializationCollaborator added to web container");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.start", (String)"215", (Object)this);
                        bl = false;
                        exception.printStackTrace();
                        if (_tc.isEventEnabled()) {
                            Tr.event((TraceComponent)_tc, (String)"start", (Object)exception);
                        }
                        if (!_tc.isDebugEnabled()) break block38;
                        Tr.debug((TraceComponent)_tc, (String)"start", (Object)exception);
                    }
                }
                this.releaseService(initialContext);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.start", (String)"238", (Object)this);
                bl = false;
                exception.printStackTrace();
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"start", (Object)exception);
                }
                if (!_tc.isDebugEnabled()) break block39;
                Tr.debug((TraceComponent)_tc, (String)"start", (Object)exception);
            }
        }
        initialContext = (ApplicationMgr)this.getService(ApplicationMgr.class);
        initialContext.addPropertyChangeListener("state", this);
        this.releaseService(initialContext);
        this.releaseService(server);
        this.createUserSpecifiedPartitions();
        if (bl && this._enabled) {
            Tr.audit((TraceComponent)_tc, (String)"INF_WA_READY", (Object)WorkAreaService.getServerName());
        }
        if (!bl && this._enabled) {
            Tr.audit((TraceComponent)_tc, (String)"INF_WA_DISABLED", (Object)WorkAreaService.getServerName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"start");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("propertyChange: " + propertyChangeEvent.getNewValue()));
        }
        if (propertyChangeEvent.getNewValue().equals("STARTING")) {
            WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
            workAreaPartitionManagerImpl.initializationComplete();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"propertyChange");
        }
    }

    public void doAsynchBeansRegistration() {
        AsynchBeansServiceCollaborator asynchBeansServiceCollaborator;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"doAsynchBeansRegistration");
        }
        if ((asynchBeansServiceCollaborator = (AsynchBeansServiceCollaborator)this.getService(AsynchBeansService.class)) != null) {
            asynchBeansServiceCollaborator.register((ServiceWithContext)ServiceWithContextImpl.getInstance());
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Registered " + ServiceWithContextImpl.getInstance().getServiceName() + " with Asynch Beans"));
            }
            AsynchBeansInvocationService.getInstance().registerWithAsynchBeans(asynchBeansServiceCollaborator);
            this.releaseService(asynchBeansServiceCollaborator);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"doAsynchBeansRegistration", (Object)"AsynchBeansService.getService returned null");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"doAsynchBeansRegistration");
        }
    }

    private void processAdminConsoleProperties(List list) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"processAdminConsoleProperties", (Object)list);
        }
        Properties properties = new Properties();
        String string = new String();
        userPartitionProps = new Hashtable();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Property property = (Property)iterator.next();
                String string2 = property.getName();
                String string3 = property.getValue();
                if (string2 == null || string3 == null) continue;
                if (string2.equals(WorkAreaService.INTEROP_40_STRING)) {
                    if (!string3.equals("true")) continue;
                    ActivityService.set40ContextInterop(null);
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "-", false);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=", false);
                if (stringTokenizer.countTokens() == 2 && stringTokenizer2.countTokens() == 2) {
                    string = stringTokenizer.nextToken().trim();
                    if (!string.equals("partition")) continue;
                    string = stringTokenizer.nextToken().trim();
                    properties = (Properties)userPartitionProps.get(string);
                    if (properties == null) {
                        properties = new Properties();
                        properties.put(stringTokenizer2.nextToken().trim(), stringTokenizer2.nextToken().trim());
                        userPartitionProps.put(string, properties);
                        continue;
                    }
                    properties.put(stringTokenizer2.nextToken().trim(), stringTokenizer2.nextToken().trim());
                    userPartitionProps.put(string, properties);
                    continue;
                }
                if (string2.equals("isContextBidirectional")) {
                    this.userWorkAreaConfigurationProps.setProperty("Bidirectional", string3);
                } else if (string2.equals("lazySerialization")) {
                    this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", string3);
                }
                if (string2.equals("Bidirectional")) {
                    this.userWorkAreaConfigurationProps.setProperty("Bidirectional", string3);
                    continue;
                }
                if (string2.equals("DeferredAttributeSerialization")) {
                    this.userWorkAreaConfigurationProps.setProperty("DeferredAttributeSerialization", string3);
                    continue;
                }
                if (!string2.equals("isContextCORBAInteroperable")) continue;
                this.userWorkAreaConfigurationProps.setProperty(string2, string3);
            }
            catch (Exception exception) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"processAdminConsoleProperties", (Object)"Invalid property entered, check the format of the property");
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)"processAdminConsoleProperties", (Object)exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"processAdminConsoleProperties");
        }
    }

    private void createUserSpecifiedPartitions() {
        Enumeration enumeration;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"createUserSpecifiedPartitions");
        }
        if ((enumeration = userPartitionProps.keys()).hasMoreElements()) {
            names = new Vector();
            WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Properties properties = (Properties)userPartitionProps.get(string);
                if ((string = (String)properties.get("name")) == null) continue;
                try {
                    UserWorkArea userWorkArea = workAreaPartitionManagerImpl.createWorkAreaPartition(string, properties);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"createUserSpecifiedPartitions", (Object)("Created partition " + string));
                    }
                    names.add(string);
                }
                catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                    FFDCFilter.processException((Throwable)partitionAlreadyExistsException, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", (String)"413", (Object)this);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createUserSpecifiedPartitions", (Object)partitionAlreadyExistsException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"createUserSpecifiedPartitions", (Object)("The partition \"" + string + "\" already has been defined."));
                    }
                    Tr.error((TraceComponent)_tc, (String)"ERR_PARTITION_ALREADY_EXISTS", (Object)string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", (String)"418", (Object)this);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createUserSpecifiedPartitions", (Object)illegalAccessException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"createUserSpecifiedPartitions", (Object)"Initialization complete, can't create a new partition.");
                    }
                    Tr.error((TraceComponent)_tc, (String)"INF_INITIALIZATION_COMPLETE", (Object)new Object[]{WorkAreaService.getServerName(), string});
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaServiceServer.createUserSpecifiedPartitions", (String)"443", (Object)this);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createUserSpecifiedPartitions", (Object)exception);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)_tc, (String)"createUserSpecifiedPartitions", (Object)exception);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"createUserSpecifiedPartitions");
        }
    }

    public static Vector getUserSpecifiedPartitionNames() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getUserSpecifiedPartitions");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getUserSpecifiedPartitions", (Object)names);
        }
        return names;
    }

    static {
        names = null;
    }
}

