/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workarea;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.workareaservice.WorkAreaPartition;
import com.ibm.websphere.models.config.workareaservice.WorkAreaPartitionService;
import com.ibm.websphere.workarea.PartitionAlreadyExistsException;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.workarea.WorkAreaPartitionManagerImpl;
import com.ibm.ws.workarea.WorkAreaService;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class WorkAreaPartitionServiceServer
extends ComponentImpl {
    private static final TraceComponent _tc = Tr.register((Class)WorkAreaPartitionServiceServer.class, null, (String)"com.ibm.ws.workarea.resources.acwa");
    private boolean _initialized = false;
    private boolean _enabled = true;
    List partitions = null;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"initialize", (Object)object);
        }
        try {
            if (!(object instanceof WorkAreaPartitionService)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"WorkAreaPartition parm is wrong type!  Going to use defaults!");
                }
                WorkAreaService.setEnabled(this._enabled);
                ConfigurationWarning configurationWarning = new ConfigurationWarning("");
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"initialize", (Object)("Throwing: " + configurationWarning));
                }
                throw configurationWarning;
            }
            WorkAreaPartitionService workAreaPartitionService = (WorkAreaPartitionService)object;
            this.partitions = workAreaPartitionService.getPartitions();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaPartitionServiceServer.initialize", (String)"72", (Object)((Object)this));
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"initialize", (Object)exception);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"initialize", (Object)exception);
            }
            ConfigurationWarning configurationWarning = new ConfigurationWarning("");
            configurationWarning.initCause((Throwable)exception);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"initialize", (Object)("Throwing: " + configurationWarning));
            }
            throw configurationWarning;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"initialize");
        }
    }

    public void start() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"start");
        }
        if (this._initialized) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Already initialized; returning");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"start");
            }
            return;
        }
        this._initialized = true;
        boolean bl = true;
        WorkAreaPartitionManagerImpl workAreaPartitionManagerImpl = WorkAreaPartitionManagerImpl.getInstance();
        String string = null;
        Properties properties = new Properties();
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = null;
        EList eList = null;
        Property property = null;
        Iterator iterator2 = this.partitions.iterator();
        while (iterator2.hasNext()) {
            bl = true;
            WorkAreaPartition workAreaPartition = (WorkAreaPartition)iterator2.next();
            if (workAreaPartition.isEnable()) {
                properties.clear();
                properties.put("maxSendSize", new Integer(workAreaPartition.getMaxSendSize()).toString());
                properties.put("maxReceiveSize", new Integer(workAreaPartition.getMaxReceiveSize()).toString());
                string = workAreaPartition.getName();
                if (string == null) {
                    Tr.error((TraceComponent)_tc, (String)"ERR_INVALID_PARTITION_NAME", (Object)string);
                    continue;
                }
                bl2 = workAreaPartition.isBidirectional();
                if (bl2) {
                    properties.put("Bidirectional", "true");
                } else {
                    properties.put("Bidirectional", "false");
                }
                bl3 = workAreaPartition.isDeferredAttributeSerialization();
                if (bl3) {
                    properties.put("DeferredAttributeSerialization", "true");
                } else {
                    properties.put("DeferredAttributeSerialization", "false");
                }
                eList = workAreaPartition.getProperties();
                if (eList != null) {
                    iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        property = (Property)iterator.next();
                        properties.put(property.getName(), property.getValue());
                    }
                }
                try {
                    workAreaPartitionManagerImpl.createWorkAreaPartition(string, properties);
                }
                catch (PartitionAlreadyExistsException partitionAlreadyExistsException) {
                    FFDCFilter.processException((Throwable)partitionAlreadyExistsException, (String)"com.ibm.ws.workarea.WorkAreaPartitionServiceServer.start", (String)"139", (Object)((Object)this));
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"start", (Object)partitionAlreadyExistsException);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)_tc, (String)"start", (Object)("The partition \"" + string + "\" has already been defined."));
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.workarea.WorkAreaPartitionServiceServer.start", (String)"145", (Object)((Object)this));
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"start", (Object)illegalAccessException);
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)_tc, (String)"start", (Object)"Initialization complete, can't create a new partition.");
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.workarea.WorkAreaPartitionServiceServer.start", (String)"151", (Object)((Object)this));
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"start", (Object)illegalArgumentException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"start", (Object)("Invalid parameter(s) on createWorkAreaPartition: " + illegalArgumentException));
                    }
                    bl = false;
                }
                if (bl) {
                    Tr.audit((TraceComponent)_tc, (String)"INF_WAP_READY", (Object)new Object[]{string, WorkAreaService.getServerName()});
                }
                if (bl) continue;
                Tr.audit((TraceComponent)_tc, (String)"INF_WAP_NOT_ENABLED", (Object)new Object[]{string, WorkAreaService.getServerName()});
                continue;
            }
            Tr.audit((TraceComponent)_tc, (String)"INF_WAP_NOT_ENABLED", (Object)new Object[]{workAreaPartition.getName(), WorkAreaService.getServerName()});
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"start");
        }
    }
}

