/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.dataaccess;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.ws.ejbpersistence.dataaccess.EJBExtractor;
import com.ibm.ws.ejbpersistence.utilpm.BadDataAccessResultType;
import com.ibm.ws.ejbpersistence.utilpm.ErrorProcessingResultCollectionRow;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.ResultSet;

public class RawBeanData {
    private Connection connection = null;
    private int currentBeanChunkOffset;
    private boolean weHaveANextRow = true;
    private boolean neverBeenKissed = true;
    private java.sql.ResultSet resultSet;
    private IndexedRecord resultRecord;
    private IndexedRecord currentSubRecord;
    private int resultRecordCursor = -1;
    private int resultRecordLength;
    private boolean lastObjectFetchedFromCurrentSubRecordsWasNull;
    private EJBExtractor currentRowExtractor;
    private static TraceComponent mytc = PMLogger.registerTC(class$com$ibm$ws$ejbpersistence$dataaccess$RawBeanData == null ? (class$com$ibm$ws$ejbpersistence$dataaccess$RawBeanData = RawBeanData.class$("com.ibm.ws.ejbpersistence.dataaccess.RawBeanData")) : class$com$ibm$ws$ejbpersistence$dataaccess$RawBeanData);
    static /* synthetic */ Class class$com$ibm$ws$ejbpersistence$dataaccess$RawBeanData;

    public void setResult(Record record) throws BadDataAccessResultType {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"setResult()");
            if (record == null) {
                Tr.debug((TraceComponent)mytc, (String)"Record result is null");
            }
        }
        if (record instanceof java.sql.ResultSet) {
            this.resultSet = (java.sql.ResultSet)record;
            this.resultRecord = null;
        } else if (record instanceof IndexedRecord) {
            this.resultRecord = (IndexedRecord)record;
            this.resultSet = null;
            this.currentSubRecord = null;
            this.resultRecordLength = this.resultRecord.size();
            this.resultRecordCursor = -1;
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
        } else {
            if (record instanceof MappedRecord) {
                throw new BadDataAccessResultType("PRGM6045 Result is MappedRecord, which is not supported. See ResultCollection doc for Resource Adapter standards on results of type cci.Record", new Object[]{record});
            }
            throw new BadDataAccessResultType("PMGR6046 Result is of an unknown type. See ResultCollection doc for Resource Adapter standards on results of type cci.Record", new Object[]{record});
        }
        this.currentBeanChunkOffset = 0;
        this.neverBeenKissed = true;
        this.weHaveANextRow = true;
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"setResult()");
        }
    }

    public boolean absolute(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        boolean bl = true;
        if (this.resultSet != null) {
            try {
                bl = this.resultSet.absolute(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.absolute", (String)"153", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"absolute(" + n + ")", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            if (n > 0) {
                this.resultRecordCursor = n - 1;
            } else if (n < 0) {
                this.resultRecordCursor = n + this.resultRecordLength;
            } else {
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"absolute(" + n + ")", this});
            }
            if (this.resultRecordCursor >= this.resultRecordLength) {
                bl = false;
                this.resultRecordCursor = this.resultRecordLength - 1;
            }
            this.currentSubRecord = (IndexedRecord)this.resultRecord.get(this.resultRecordCursor);
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
        return bl;
    }

    public void afterLast() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.afterLast();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.afterLast", (String)"200", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"afterLast()", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            this.resultRecordCursor = this.resultRecordLength;
            this.currentSubRecord = null;
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void beforeFirst() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.beforeFirst();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.beforeFirst", (String)"231", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"beforeFirst()", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            this.resultRecordCursor = -1;
            this.currentSubRecord = null;
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void clearData() {
        this.resultSet = null;
        this.resultRecord = null;
    }

    public void clearWarnings() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.clearWarnings();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.clearWarnings", (String)"260", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"clearWarnings()", this}, sQLException);
            }
        } else if (this.resultRecord == null) {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void close() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.close", (String)"295", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"close()", this}, sQLException);
            }
        } else if (this.resultRecord == null) {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public boolean first() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.first();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.first", (String)"324", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"first()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.absolute(0);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Array getArray(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getArray(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getArray", (String)"356", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "array", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Array array = (Array)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = array == null;
            return array;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public InputStream getAsciiStream(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getAsciiStream(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getAsciiStream", (String)"405", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "AsciiStream", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            InputStream inputStream = (InputStream)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = inputStream == null;
            return inputStream;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public BigDecimal getBigDecimal(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBigDecimal(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBigDecimal", (String)"445", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "BigDecimal", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            BigDecimal bigDecimal = (BigDecimal)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = bigDecimal == null;
            return bigDecimal;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public InputStream getBinaryStream(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBinaryStream(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBinaryStream", (String)"493", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "BinaryStream", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            InputStream inputStream = (InputStream)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = inputStream == null;
            return inputStream;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Blob getBlob(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBlob(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBlob", (String)"531", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Blob", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Blob blob = (Blob)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = blob == null;
            return blob;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean getBoolean(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBoolean(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBoolean", (String)"567", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "boolean", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Boolean bl = (Boolean)this.currentSubRecord.get(n - 1);
            if (bl == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return false;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return bl;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public byte getByte(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getByte(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getByte", (String)"604", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Byte by = (Byte)this.currentSubRecord.get(n - 1);
            if (by == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return by;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public byte[] getBytes(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBytes(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBytes", (String)"641", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte[]", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            byte[] byArray = (byte[])this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = byArray == null;
            return byArray;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public char getChar(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                String string = this.resultSet.getString(n);
                return string.charAt(0);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getChar", (String)"680", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "char", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            String string = (String)this.currentSubRecord.get(n - 1);
            if (string == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return '\u0000';
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return string.charAt(0);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Reader getCharacterStream(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getCharacterStream(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getCharacterStream", (String)"716", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "CharacterStream", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Reader reader = (Reader)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = reader == null;
            return reader;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Clob getClob(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getClob(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getClob", (String)"754", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Clob", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Clob clob = (Clob)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = clob == null;
            return clob;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getConcurrency() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getConcurrency();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getConcurrency", (String)"790", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getConcurrency()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 1007;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getCurrentBeanChunkOffset() {
        return this.currentBeanChunkOffset;
    }

    public String getCursorName() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getCursorName();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getCursorName", (String)"841", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getCursorName()", this}, sQLException);
            }
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Date getDate(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getDate(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getDate", (String)"871", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Date", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Date date = (Date)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = date == null;
            return date;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Date getDate(int n, Calendar calendar) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getDate(n, calendar);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getDate", (String)"913", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Date in Calendar", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Date date = (Date)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = date == null;
            return date;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public double getDouble(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getDouble(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getDouble", (String)"950", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "double", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Double d = (Double)this.currentSubRecord.get(n - 1);
            if (d == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0.0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return d;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getFetchDirection() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getFetchDirection();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getFetchDirection", (String)"986", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getFetchDirection()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 1000;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getFetchSize() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getFetchSize();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getFetchSize", (String)"1015", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getFetchSize()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 100;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public float getFloat(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getFloat(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getFloat", (String)"1045", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "float", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Float f = (Float)this.currentSubRecord.get(n - 1);
            if (f == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0.0f;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return f.floatValue();
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getInt(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getInt(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getInt", (String)"1082", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "int", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Integer n2 = (Integer)this.currentSubRecord.get(n - 1);
            if (n2 == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return n2;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public long getLong(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getLong(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getLong", (String)"1118", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "long", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Long l = (Long)this.currentSubRecord.get(n - 1);
            if (l == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0L;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return l;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public ResultSetMetaData getMetaData() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getMetaData();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getMetaData", (String)"1152", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getMetaData()", this}, sQLException);
            }
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Object getObject(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getObject(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getObject", (String)"1181", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Object", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Object object = this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = object == null;
            return object;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Object getObject(int n, Map map) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getObject(n, map);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getObject", (String)"1224", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Object with Map", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Object object = this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = object == null;
            return object;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Ref getRef(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getRef(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getRef", (String)"1261", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Ref", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Ref ref = (Ref)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = ref == null;
            return ref;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getRow() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getRow();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getRow", (String)"1297", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getRow()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor + 1;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public short getShort(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getShort(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getShort", (String)"1327", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "short", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Short s = (Short)this.currentSubRecord.get(n - 1);
            if (s == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return s;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Statement getStatement() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getStatement();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getStatement", (String)"1366", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getStatement()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return null;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public String getString(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getString(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getString", (String)"1395", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "String", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            String string = (String)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = string == null;
            return string;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Time getTime(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTime(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTime", (String)"1432", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Time", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Time time = (Time)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = time == null;
            return time;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Time getTime(int n, Calendar calendar) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTime(n, calendar);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTime", (String)"1472", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Time in Calendar", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Time time = (Time)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = time == null;
            return time;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Timestamp getTimestamp(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTimestamp(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTimestamp", (String)"1508", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Timestamp", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Timestamp timestamp = (Timestamp)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = timestamp == null;
            return timestamp;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTimestamp(n, calendar);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTimestamp", (String)"1548", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Timestamp in Calendar", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Timestamp timestamp = (Timestamp)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = timestamp == null;
            return timestamp;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getType() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getType();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getType", (String)"1585", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getType()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 1004;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public SQLWarning getWarnings() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getWarnings();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getWarnings", (String)"1622", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getWarnings()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return null;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean hasNext() throws ErrorProcessingResultCollectionRow {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"hasNext()");
        }
        if (this.neverBeenKissed) {
            this.neverBeenKissed = false;
            if (this.resultSet != null) {
                try {
                    this.weHaveANextRow = this.resultSet.next();
                }
                catch (ObjectClosedException objectClosedException) {
                    FFDCFilter.processException((Throwable)objectClosedException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.hasNext", (String)"1665", (Object)this);
                    ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6040 resultSet was found to be closed on first call to resultSet.next(). ResultSet is: {0}", new Object[]{this}, objectClosedException);
                    PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                    throw errorProcessingResultCollectionRow;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.hasNext", (String)"1669", (Object)this);
                    if (sQLException.getErrorCode() == 2 && sQLException.getSQLState().equals("57033")) {
                        ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6023E: Possible conflict between this transaction and another while accessing the same data, probably due to application design.", sQLException);
                        PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                        throw errorProcessingResultCollectionRow;
                    }
                    ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6041 SQLException on first call to resultSet.next(). ResultSet is: {0}", new Object[]{this}, sQLException);
                    PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                    throw errorProcessingResultCollectionRow;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.hasNext", (String)"1673", (Object)this);
                    ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6042 Non-SQL error on first call to resultSet.next(). ResultSet is: {0}", new Object[]{this}, throwable);
                    PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                    throw errorProcessingResultCollectionRow;
                }
            } else if (this.resultRecord != null) {
                boolean bl = this.weHaveANextRow = !this.resultRecord.isEmpty();
                if (this.weHaveANextRow) {
                    this.resultRecordCursor = 0;
                    this.currentSubRecord = (IndexedRecord)this.resultRecord.get(0);
                }
            } else {
                ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
                PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                throw errorProcessingResultCollectionRow;
            }
            if (!this.weHaveANextRow) {
                this.closeConnection();
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"hasNext(), returning {0}", (Object)new Object[]{new Boolean(this.weHaveANextRow)});
        }
        return this.weHaveANextRow;
    }

    public boolean isAfterLast() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isAfterLast();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isAfterLast", (String)"1709", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isAfterLast()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor >= this.resultRecordLength;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean isBeforeFirst() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isBeforeFirst();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isBeforeFirst", (String)"1743", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isBeforeFirst()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor < 0;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean isFirst() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isFirst();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isFirst", (String)"1775", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isFirst()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor == 0;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean isLast() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isLast();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isLast", (String)"1811", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isLast()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor == this.resultRecordLength - 1;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean last() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.last();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.last", (String)"1845", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"last()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            if (this.resultRecordLength == 0) {
                return false;
            }
            this.resultRecordCursor = this.resultRecordLength - 1;
            return true;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public void moveToCurrentRow() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.moveToCurrentRow();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.moveToCurrentRow", (String)"1882", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"moveToCurrentRow()", this}, sQLException);
            }
        } else if (this.resultRecord == null) {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public boolean next() throws ErrorProcessingResultCollectionRow {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"next()");
        }
        this.currentBeanChunkOffset = 0;
        if (this.resultSet != null) {
            try {
                this.weHaveANextRow = this.resultSet.next();
                this.neverBeenKissed = false;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.next", (String)"1925", (Object)this);
                if (sQLException.getErrorCode() == 2 && sQLException.getSQLState().equals("57033")) {
                    ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6023E: Possible conflict between this transaction and another while accessing the same data, probably due to application design.", sQLException);
                    PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                    throw errorProcessingResultCollectionRow;
                }
                ResultSet resultSet = null;
                if (this.resultSet instanceof ResultSet) {
                    resultSet = (ResultSet)this.resultSet;
                }
                ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6035 SQLException occurred while calling ResultSet.next()", new Object[]{this}, sQLException);
                PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                throw errorProcessingResultCollectionRow;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.next", (String)"1932", (Object)this);
                ResultSet resultSet = null;
                if (this.resultSet instanceof ResultSet) {
                    resultSet = (ResultSet)this.resultSet;
                }
                throw new ErrorProcessingResultCollectionRow("PMGR6036 Unexpected exception occurred while calling ResultSet.next()", new Object[]{this}, throwable);
            }
        } else {
            this.neverBeenKissed = false;
            if (this.resultRecordCursor == this.resultRecordLength - 1) {
                this.weHaveANextRow = false;
            } else {
                ++this.resultRecordCursor;
                this.currentSubRecord = (IndexedRecord)this.resultRecord.get(this.resultRecordCursor);
                this.weHaveANextRow = true;
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"next(), returning {0}", (Object)new Object[]{new Boolean(this.weHaveANextRow)});
        }
        return this.weHaveANextRow;
    }

    public boolean previous() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.previous();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.previous", (String)"1976", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"previous()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.absolute(this.resultRecordCursor - 1);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean relative(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.relative(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.relative", (String)"2016", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"relative(" + n + ")", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.absolute(this.resultRecordCursor + n);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public void setCurrentBeanChunkOffset(int n) {
        this.currentBeanChunkOffset = n;
    }

    public void setFetchDirection(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.setFetchDirection(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.setFetchDirection", (String)"2060", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"setFetchDirection(" + n + ")", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            if (n != 1000) {
                throw new ErrorProcessingResultCollectionRow("PMGR6055 Function not supported.");
            }
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void setFetchSize(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.setFetchSize(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.setFetchSize", (String)"2100", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"setFetchSize(" + n + ")", this}, sQLException);
            }
        } else {
            if (this.resultRecord != null) {
                return;
            }
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n currentBeanChunkOffset = " + this.currentBeanChunkOffset);
        if (this.resultSet != null) {
            stringBuffer.append("\n Result data is a ResultSet. /n " + this.resultSet.toString());
        }
        if (this.resultRecord != null) {
            stringBuffer.append("\n Result data is a cci.IndexedRecord. \n " + this.resultRecord.toString());
        }
        if (this.resultSet == null && this.resultRecord == null) {
            stringBuffer.append("\n Result data **** BAD **** both resultSet and resultRecord are null.\n ");
        }
        return stringBuffer.toString();
    }

    public boolean wasNull() throws PersistenceManagerInternalError, ErrorProcessingResultCollectionRow {
        if (this.resultSet != null) {
            try {
                return this.resultSet.wasNull();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.wasNull", (String)"2156", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"wasNull()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.lastObjectFetchedFromCurrentSubRecordsWasNull;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public void closeConnection() {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"closeConnection(), connection = ", (Object)new Object[]{this.connection});
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"closeConnection()");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setWeHaveANextRow(boolean bl) {
        this.weHaveANextRow = bl;
    }

    public byte[] getBlobAsByteArray(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"getBlobAsByteArray(int columnIndex)", (Object)new Object[]{new Integer(n)});
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                int n2;
                InputStream inputStream = this.resultSet.getBinaryStream(n);
                if (inputStream == null || this.resultSet.wasNull()) {
                    byArray = null;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n2 = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBlobAsByteArray", (String)"2308", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte[]", this}, exception);
            }
        } else if (this.resultRecord != null) {
            byte[] byArray2 = (byte[])this.currentSubRecord.get(n - 1);
            if (byArray2 == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                byArray = null;
            } else {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
                byArray = byArray2;
            }
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"getBlobAsByteArray(int columnIndex)", (Object)byArray);
        }
        return byArray;
    }

    public byte[] getClobAsByteArray(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"getClobAsByteArray(int columnIndex)", (Object)new Object[]{new Integer(n)});
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                int n2;
                InputStream inputStream = this.resultSet.getAsciiStream(n);
                if (inputStream == null || this.resultSet.wasNull()) {
                    byArray = null;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n2 = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getClobAsByteArray", (String)"2327", (Object)this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte[]", this}, exception);
            }
        } else if (this.resultRecord != null) {
            byte[] byArray2 = (byte[])this.currentSubRecord.get(n - 1);
            if (byArray2 == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                byArray = null;
            } else {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
                byArray = byArray2;
            }
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"getClobAsByteArray(int columnIndex)", (Object)byArray);
        }
        return byArray;
    }

    public final EJBExtractor getCurrentRowExtractor() {
        return this.currentRowExtractor;
    }

    public final void setCurrentRowExtractor(EJBExtractor eJBExtractor) {
        this.currentRowExtractor = eJBExtractor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

