/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.cache;

import com.ibm.ejs.jms.JMSSessionHandleInterface;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpmi.PMBeanInfo;
import com.ibm.websphere.cpmi.PersistenceManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ejbpersistence.PMCacheInvalidationRequest;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.api.jms.JmsManagedConnectionFactory;
import com.ibm.ws.ejbpersistence.associations.ForwardOneToOneLinkImpl;
import com.ibm.ws.ejbpersistence.associations.LinkImpl;
import com.ibm.ws.ejbpersistence.beanextensions.ConcreteBeanClassExtension;
import com.ibm.ws.ejbpersistence.beanextensions.PersistenceManagerImpl;
import com.ibm.ws.ejbpersistence.cache.CacheManager;
import com.ibm.ws.ejbpersistence.cache.InputStreamWithClassLoader;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerException;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SIJMSMessageFactory;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PMCacheInvalidationMessageListener
implements AsynchConsumerCallback,
MessageListener {
    private static PMCacheInvalidationMessageListener topicListener = null;
    private static boolean cacheInvalidationEnabled;
    private static String busName;
    private static final String topicConnectionFactoryUri = "com.ibm.websphere.ejbpersistence.InvalidateTCF";
    private static final String topicString = "com.ibm.websphere.ejbpersistence.invalidate";
    private static final boolean NON_TRANSACTIONAL_SESSION = false;
    private static LinkImpl helper;
    private static PMCacheInvalidationMessageListener singletonSelf;
    private static TopicConnectionFactory topicConnectionFactory;
    private PersistenceManagerImpl ourpm;
    private EJBContainer ejbContainer;
    private static ConsumerSession consumerSession;
    private static TopicSession topicSession;
    private static TopicConnection topicConnection;
    private static SICoreConnection siConnection;
    private static TraceComponent mytc;
    static /* synthetic */ Class class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener;

    public static void setupInvalidationReceiver() {
        block25: {
            if (mytc.isEntryEnabled()) {
                Tr.entry((TraceComponent)mytc, (String)"setupInvalidationReceiver()", (Object)new Object[0]);
            }
            if (cacheInvalidationEnabled && topicListener == null) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)mytc, (String)"Setting up a singleton PMCacheInvalidationMessageListener as a JMS topic listener.");
                }
                try {
                    InitialContext initialContext = new InitialContext();
                    topicConnectionFactory = (TopicConnectionFactory)initialContext.lookup(topicConnectionFactoryUri);
                    if (mytc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)mytc, (String)("JNDI lookup of topicConnectionFactory returns " + topicConnectionFactory));
                    }
                    if (!(topicConnectionFactory instanceof JmsManagedConnectionFactory)) {
                        if (mytc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)mytc, (String)"User configured V5 messaging resources");
                        }
                        try {
                            Topic topic = (Topic)initialContext.lookup(topicString);
                            topicConnection = topicConnectionFactory.createTopicConnection();
                            topicSession = topicConnection.createTopicSession(false, 1);
                            TopicSession topicSession = (TopicSession)((JMSSessionHandleInterface)PMCacheInvalidationMessageListener.topicSession).getSession();
                            TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
                            topicListener = new PMCacheInvalidationMessageListener();
                            topicSubscriber.setMessageListener((MessageListener)topicListener);
                            topicConnection.start();
                        }
                        catch (JMSException jMSException) {
                            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", jMSException);
                            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                            try {
                                if (topicConnection != null) {
                                    topicConnection.close();
                                }
                                break block25;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (NamingException namingException) {
                            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", namingException);
                            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                        }
                        catch (Throwable throwable) {
                            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR1000E: Exception occurred :", throwable);
                            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                        }
                        break block25;
                    }
                    busName = ((JmsManagedConnectionFactory)topicConnectionFactory).getBusName();
                    if (mytc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)mytc, (String)("User configured V6 embedded messaging resources, bus name (obtained from topicConnectionFactory resource) is " + busName));
                    }
                    SICoreConnectionFactory sICoreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("busName", busName);
                    siConnection = sICoreConnectionFactory.createConnection("", "", hashMap);
                    if (mytc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)mytc, (String)("SICoreConnection obtained is " + siConnection));
                    }
                    SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress("Default.Topic.Space", false);
                    SelectionCriteria selectionCriteria = SelectionCriteriaFactory.getInstance().createSelectionCriteria(topicString, null, SelectorDomain.JMS);
                    DestinationType destinationType = DestinationType.TOPICSPACE;
                    Reliability reliability = null;
                    Reliability reliability2 = null;
                    consumerSession = siConnection.createConsumerSession(sIDestinationAddress, destinationType, selectionCriteria, reliability, false, false, reliability2, false, null);
                    if (mytc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)mytc, (String)("consumerSession = s " + consumerSession));
                    }
                    if (singletonSelf == null) {
                        singletonSelf = new PMCacheInvalidationMessageListener();
                    }
                    OrderingContext orderingContext = null;
                    consumerSession.registerAsynchConsumerCallback((AsynchConsumerCallback)singletonSelf, 0, 0L, 1, orderingContext);
                    if (mytc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)mytc, (String)"...callback registered ");
                    }
                    consumerSession.start(false);
                }
                catch (Exception exception) {
                    PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", exception);
                    PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                    try {
                        if (consumerSession != null) {
                            consumerSession.stop();
                        }
                        if (siConnection != null) {
                            siConnection.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"setupInvalidationReceiver()");
        }
    }

    public static void shutdownInvalidation() {
        try {
            if (consumerSession != null) {
                consumerSession.stop();
            }
            if (siConnection != null) {
                siConnection.close();
            }
            if (topicConnection != null) {
                topicConnection.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isCacheInvalidationEnabled() {
        return cacheInvalidationEnabled;
    }

    public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"consumeMessages(LockedMessageEnumeration lockedMessages", (Object)new Object[]{lockedMessageEnumeration});
        }
        ObjectMessage objectMessage = null;
        PMCacheInvalidationRequest pMCacheInvalidationRequest = null;
        SIBusMessage sIBusMessage = null;
        try {
            sIBusMessage = lockedMessageEnumeration.nextLocked();
            objectMessage = (ObjectMessage)SIJMSMessageFactory.getInstance().createJMSMessage(sIBusMessage);
            pMCacheInvalidationRequest = (PMCacheInvalidationRequest)objectMessage.getObject();
            if (mytc.isDebugEnabled()) {
                Tr.debug((TraceComponent)mytc, (String)("PMCacheInvalidationRequest from siMsg = " + pMCacheInvalidationRequest));
            }
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"520", (Object)this);
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5021E: PM's invalidation listener received a message but the message parameter was not a PMCacheInvalidationRequest object as required.");
            PMExceptionHandler.logException(mytc, persistenceManagerException);
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"530", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PMCacheInvalidation error: " + exception});
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
            return;
        }
        try {
            this.invalidate(pMCacheInvalidationRequest);
            Topic topic = (Topic)objectMessage.getJMSReplyTo();
            SIDestinationAddress sIDestinationAddress = null;
            String string = null;
            List list = sIBusMessage.getReverseRoutingPath();
            if (list != null & list.size() == 1) {
                sIDestinationAddress = (SIDestinationAddress)list.get(0);
                string = sIBusMessage.getReplyDiscriminator();
            }
            Tr.debug((TraceComponent)mytc, (String)("SIDestinationAddress replyToDestAdr from ObjectMessage is " + sIDestinationAddress + "and replyDiscriminator is " + string));
            if (topic != null) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)mytc, (String)("About to send (publish) invalidation ACK to (non-null) reply-to Destination: " + topic));
                }
                TopicConnection topicConnection = topicConnectionFactory.createTopicConnection();
                TopicSession topicSession = topicConnection.createTopicSession(false, 1);
                TopicPublisher topicPublisher = topicSession.createPublisher(topic);
                Message message = topicSession.createMessage();
                message.setJMSType("cycle");
                message.setJMSCorrelationID(objectMessage.getJMSCorrelationID());
                topicPublisher.publish(message);
                lockedMessageEnumeration.deleteCurrent(null);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"560", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PMCacheInvalidation error: " + exception});
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
            return;
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"consumeMessages(LockedMessageEnumeration lockedMessages)");
        }
    }

    public void onMessage(Message message) {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"onMessage(javax.jms.Message msg)", (Object)new Object[]{message});
        }
        PMCacheInvalidationRequest pMCacheInvalidationRequest = null;
        try {
            ObjectMessage objectMessage = (ObjectMessage)message;
            pMCacheInvalidationRequest = (PMCacheInvalidationRequest)objectMessage.getObject();
            if (mytc.isDebugEnabled()) {
                Tr.debug((TraceComponent)mytc, (String)("PMCacheInvalidationRequest from msg = " + pMCacheInvalidationRequest));
            }
            this.invalidate(pMCacheInvalidationRequest);
            Topic topic = (Topic)objectMessage.getJMSReplyTo();
            if (topic != null) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)mytc, (String)("About to send (publish) invalidation ACK to (non-null) reply-to Destination: " + topic));
                }
                TopicPublisher topicPublisher = topicSession.createPublisher(topic);
                Message message2 = topicSession.createMessage();
                message2.setJMSType("cycle");
                message2.setJMSCorrelationID(message.getJMSCorrelationID());
                topicPublisher.publish(message2);
            }
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"2", (Object)this);
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5021E: PM's invalidation listener received a message but the message parameter was not a PMCacheInvalidationRequest object as required.");
            PMExceptionHandler.logException(mytc, persistenceManagerException);
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"10", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PMCacheInvalidation error: " + exception});
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
            return;
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"onMessage(javax.jms.Message msg)");
        }
    }

    public void invalidate(byte[] byArray) {
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"invalidate(byte[] requestInWireFormat)", (Object)new Object[]{byArray});
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"invalidate(byte[] requestInWireFormat)");
        }
    }

    public void invalidate(PMCacheInvalidationRequest pMCacheInvalidationRequest) {
        PersistenceManager[] persistenceManagerArray;
        if (mytc.isEntryEnabled()) {
            Tr.entry((TraceComponent)mytc, (String)"invalidate(PMCacheInvalidationRequest request)", (Object)new Object[]{pMCacheInvalidationRequest});
        }
        if (this.ourpm == null) {
            this.ejbContainer = helper.getContainerInterface();
            persistenceManagerArray = this.ejbContainer.getPersistenceManagers();
            for (int i = 0; i < persistenceManagerArray.length; ++i) {
                if (!(persistenceManagerArray[i] instanceof PersistenceManagerImpl)) continue;
                this.ourpm = (PersistenceManagerImpl)persistenceManagerArray[i];
                break;
            }
            if (this.ourpm == null) {
                PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PersistenceManagerImpl==null"});
                FFDCFilter.processException((Throwable)((Object)persistenceManagerInternalError), (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"810", (Object)this);
                PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                return;
            }
        }
        try {
            persistenceManagerArray = this.ourpm.getPMHomeInfo(pMCacheInvalidationRequest.getBeanHomeJNDIName());
            J2EEName j2EEName = persistenceManagerArray.getJ2EEName();
            PMBeanInfo pMBeanInfo = persistenceManagerArray.getPMBeanInfo();
            CacheManager cacheManager = ((ConcreteBeanClassExtension)pMBeanInfo).getCacheManager();
            switch (pMCacheInvalidationRequest.getInvalidationType()) {
                case 0: {
                    ClassLoader classLoader = this.ejbContainer.getClassLoader(j2EEName);
                    InputStreamWithClassLoader inputStreamWithClassLoader = new InputStreamWithClassLoader(classLoader, pMCacheInvalidationRequest.getKeyAsByteArray());
                    Serializable serializable = (Serializable)inputStreamWithClassLoader.readObject();
                    cacheManager.ejbInvalidate(serializable);
                    break;
                }
                case 1: {
                    ClassLoader classLoader = this.ejbContainer.getClassLoader(j2EEName);
                    InputStreamWithClassLoader inputStreamWithClassLoader = new InputStreamWithClassLoader(classLoader, pMCacheInvalidationRequest.getKeyAsByteArray());
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    try {
                        while (true) {
                            Object object = inputStreamWithClassLoader.readObject();
                            arrayList.add(object);
                        }
                    }
                    catch (EOFException eOFException) {
                        cacheManager.ejbInvalidate(arrayList);
                        break;
                    }
                }
                case 2: {
                    cacheManager.ejbInvalidateAll();
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"820", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5024E: IOException while accessing byte-array-ized key object {0}", new Object[]{pMCacheInvalidationRequest.getKeyAsByteArray()}, iOException);
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"830", (Object)this);
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5025E: ClassNotFoundException while deserializing bean primary key object passed by client code. Key object is not of the correct class for bean type with home JNDI name = {0}.", new Object[]{pMCacheInvalidationRequest.getBeanHomeJNDIName()}, classNotFoundException);
            PMExceptionHandler.logException(mytc, persistenceManagerException);
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit((TraceComponent)mytc, (String)"invalidate(PMCacheInvalidationRequest request)");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        helper = new ForwardOneToOneLinkImpl(null, null, null, null);
        mytc = PMLogger.registerTC(class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener == null ? (class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener = PMCacheInvalidationMessageListener.class$("com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener")) : class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener);
        String string = null;
        String string2 = null;
        try {
            string = System.getProperty("com.ibm.ws.ejbpersistence.cacheinvalidation");
            string2 = System.getProperty("com.ibm.ws.ejbpersistence.cacheinvalidatation");
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)mytc, (String)throwable.getMessage());
            Tr.error((TraceComponent)mytc, (String)"Property com.ibm.ws.ejbpersistence.cacheinvalidation");
        }
        if (string == null & string2 != null) {
            string = string2;
        }
        if (string != null) {
            cacheInvalidationEnabled = true;
            busName = string;
            if (mytc.isDebugEnabled()) {
                Tr.debug((TraceComponent)mytc, (String)("PM cache invalidation enabled, using busName = " + busName));
            }
        } else if (mytc.isDebugEnabled()) {
            Tr.debug((TraceComponent)mytc, (String)"Property com.ibm.ws.ejbpersistence.cacheinvalidation not specified, default is not enabled");
        }
    }
}

