/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import mx4j.log.Log;
import mx4j.log.Logger;

public class MBeanServerFactory {
    private static ArrayList servers = new ArrayList();
    static /* synthetic */ Class class$javax$management$MBeanServerFactory;
    static /* synthetic */ Class class$javax$management$MBeanServerBuilder;

    private MBeanServerFactory() {
    }

    private static Logger getLogger() {
        return Log.getLogger((String)(class$javax$management$MBeanServerFactory == null ? (class$javax$management$MBeanServerFactory = MBeanServerFactory.class$("javax.management.MBeanServerFactory")) : class$javax$management$MBeanServerFactory).getName());
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer createMBeanServer(String defaultDomain) {
        MBeanServer server = MBeanServerFactory.createMBeanServerImpl(defaultDomain, "createMBeanServer");
        ArrayList arrayList = servers;
        synchronized (arrayList) {
            servers.add(server);
        }
        Logger logger = MBeanServerFactory.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)("MBeanServer " + server + " registered successfully"));
        }
        return server;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String defaultDomain) {
        return MBeanServerFactory.createMBeanServerImpl(defaultDomain, "newMBeanServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMBeanServer(MBeanServer server) {
        block12: {
            Logger logger = MBeanServerFactory.getLogger();
            try {
                if (logger.isEnabledFor(20)) {
                    logger.info((Object)("Releasing MBeanServer " + server));
                }
                if (server != null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new MBeanServerPermission("releaseMBeanServer"));
                    }
                    boolean removed = false;
                    ArrayList arrayList = servers;
                    synchronized (arrayList) {
                        removed = servers.remove(server);
                    }
                    if (removed) {
                        if (logger.isEnabledFor(20)) {
                            logger.info((Object)("MBeanServer " + server + " released successfully"));
                        }
                    } else {
                        logger.warn((Object)("MBeanServer " + server + " not released, cannot find it"));
                    }
                    break block12;
                }
                logger.warn((Object)"MBeanServer not released, it's null");
            }
            catch (SecurityException x) {
                if (logger.isEnabledFor(20)) {
                    logger.info((Object)("Security Exception caught while releasing MBeanServer " + server), (Throwable)x);
                }
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList findMBeanServer(String id) {
        Logger logger = MBeanServerFactory.getLogger();
        ArrayList<MBeanServer> list = null;
        try {
            SecurityManager sm;
            if (logger.isEnabledFor(20)) {
                logger.info((Object)("Finding MBeanServer with ID: " + id));
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(new MBeanServerPermission("findMBeanServer"));
            }
            if (id == null) {
                list = (ArrayList<MBeanServer>)servers.clone();
            } else {
                list = new ArrayList<MBeanServer>();
                ArrayList arrayList = servers;
                synchronized (arrayList) {
                    for (int i = 0; i < servers.size(); ++i) {
                        MBeanServer server = (MBeanServer)servers.get(i);
                        try {
                            String serverId = (String)server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
                            if (!id.equals(serverId)) continue;
                            list.add(server);
                            if (!logger.isEnabledFor(10)) continue;
                            logger.debug((Object)("Found matching MBeanServer: " + server));
                            continue;
                        }
                        catch (Exception ignored) {
                            logger.error((Object)"Delegate implementation is buggy", (Throwable)ignored);
                        }
                    }
                }
            }
            if (logger.isEnabledFor(20)) {
                logger.info((Object)("MBeanServer(s) found: " + list));
            }
            return list;
        }
        catch (SecurityException x) {
            if (logger.isEnabledFor(20)) {
                logger.info((Object)("Security Exception caught while finding MBeanServer with ID: " + id), (Throwable)x);
            }
            throw x;
        }
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static MBeanServer createMBeanServerImpl(String domain, String permission) {
        Logger logger = MBeanServerFactory.getLogger();
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new MBeanServerPermission(permission));
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)"Obtaining MBeanServerBuilder");
            }
            MBeanServerBuilder builder = MBeanServerFactory.createMBeanServerBuilder();
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Using MBeanServerBuilder " + builder.getClass()));
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)"Creating MBeanServerDelegate...");
            }
            MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("MBeanServerDelegate " + delegate.getClass() + " created successfully"));
            }
            if (logger.isEnabledFor(20)) {
                logger.info((Object)"Creating MBeanServer...");
            }
            MBeanServer mbs = builder.newMBeanServer(domain, null, delegate);
            if (logger.isEnabledFor(20)) {
                logger.info((Object)("MBeanServer " + mbs + " created successfully"));
            }
            return mbs;
        }
        catch (SecurityException x) {
            if (logger.isEnabledFor(20)) {
                logger.info((Object)"Security Exception caught while creating an MBeanServer", (Throwable)x);
            }
            throw x;
        }
    }

    private static MBeanServerBuilder createMBeanServerBuilder() {
        Class builderClass = MBeanServerFactory.loadMBeanServerBuilderClass();
        try {
            return (MBeanServerBuilder)builderClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new JMRuntimeException("Specified MBeanServerBuilder must be a subclass of MBeanServerBuilder: " + builderClass);
        }
        catch (IllegalAccessException e) {
            throw new JMRuntimeException("Can't instantiate MBeanServerBuilder " + builderClass + ": " + e);
        }
        catch (InstantiationException e) {
            throw new JMRuntimeException("Can't instantiate MBeanServerBuilder " + builderClass + ": " + e);
        }
    }

    private static Class loadMBeanServerBuilderClass() {
        String builderClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("javax.management.builder.initial");
            }
        });
        if (builderClassName == null || builderClassName.length() == 0) {
            return class$javax$management$MBeanServerBuilder == null ? (class$javax$management$MBeanServerBuilder = MBeanServerFactory.class$("javax.management.MBeanServerBuilder")) : class$javax$management$MBeanServerBuilder;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(builderClassName);
            }
            return Class.forName(builderClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JMRuntimeException("MBeanServerBuilder class not found: " + builderClassName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

