/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.util;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.util.BasicPrinter;

public class HelpDialog
extends JDialog
implements ActionListener {
    JTextArea textArea;
    JButton printButton;
    JButton okayButton;
    private ResourceBundle rb = null;
    private AbstractAction okay_action = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            HelpDialog.this.setVisible(false);
            HelpDialog.this.dispose();
        }
    };
    String helpFile = "";
    String buffer = "";

    public HelpDialog(Frame frame) {
        this(frame, ResourceHandler.getMessage("help_dialog.caption"), false);
    }

    public HelpDialog(Frame frame, boolean bl) {
        this(frame, ResourceHandler.getMessage("help_dialog.caption"), bl);
    }

    public HelpDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public HelpDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.getRootPane().registerKeyboardAction(this.okay_action, KeyStroke.getKeyStroke(27, 0), 2);
        this.majorLayout();
    }

    public void majorLayout() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        this.setResizable(true);
        jTextArea.setFont(new JEditorPane().getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        try {
            this.rb = ResourceBundle.getBundle("sun.plugin.converter.resources.ConverterHelp");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Enumeration<String> enumeration = this.rb.getKeys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        try {
            if (this.rb != null) {
                this.helpFile = "";
                for (int i = 0; i < n; ++i) {
                    this.helpFile = this.helpFile + this.rb.getString("conhelp.txt" + i) + "\n";
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        String string = this.getHelpText();
        this.textArea.setText(string);
        this.textArea.getAccessibleContext().setAccessibleDescription(string);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        this.textArea.setFocusTraversalKeys(0, hashSet);
        hashSet.clear();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        this.textArea.setFocusTraversalKeys(1, hashSet);
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                HelpDialog.this.textArea.getCaret().setVisible(true);
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
        if (jScrollBar != null && jScrollBar2 != null) {
            jScrollBar.getAccessibleContext().setAccessibleName(jScrollBar.getAccessibleContext().getAccessibleRole().toString());
            jScrollBar2.getAccessibleContext().setAccessibleName(jScrollBar2.getAccessibleContext().getAccessibleRole().toString());
        }
        jScrollPane.getViewport().add(this.textArea);
        JScrollPane jScrollPane2 = new JScrollPane(jTextArea);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setHorizontalScrollBarPolicy(32);
        Dimension dimension = this.getToolkit().getScreenSize();
        jScrollPane2.setPreferredSize(new Dimension(dimension.width / 2, dimension.height / 2));
        jTextArea.setText(this.helpFile);
        jTextArea.setCaretPosition(0);
        this.printButton = new JButton(ResourceHandler.getMessage("button.print"));
        this.printButton.setMnemonic(ResourceHandler.getAcceleratorKey("button.print"));
        this.printButton.addActionListener(this);
        this.okayButton = new JButton(ResourceHandler.getMessage("button.okay"));
        this.okayButton.setMnemonic(ResourceHandler.getAcceleratorKey("button.okay"));
        this.okayButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (!HelpDialog.this.okayButton.hasFocus()) {
                    HelpDialog.this.okayButton.requestFocus();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.okayButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane2, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.frame.sizingBorderWidth", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        4.access$000(this.this$1).pack();
                    }
                });
            }

            static /* synthetic */ HelpDialog access$000(4 var0) {
                return var0.HelpDialog.this;
            }
        });
    }

    public String getHelpText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.text1"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.default_template"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.text2"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.ieonly_template"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.text3"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.nsonly_template"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.text4"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.extend_template"));
        stringBuffer.append(ResourceHandler.getMessage("help_dialog.text5"));
        this.buffer = stringBuffer.toString();
        return this.buffer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component == this.okayButton) {
            this.setVisible(false);
            this.dispose();
        } else if (component == this.printButton) {
            BasicPrinter.printDocument(new Frame(), this.buffer, "Print Help Text");
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
        if (bl) {
            super.pack();
        }
        super.setVisible(bl);
    }
}

