/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.HLSLiteDataInterface;
import com.ibm.ws.client.applicationclient.ClientProcessService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.I18nClientComponentImpl;
import com.ibm.ws.i18n.context.I18nJndiSupport;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.Messages;
import javax.naming.InitialContext;

public final class I18nServiceClient
extends I18nService {
    private static final TraceComponent tc = Tr.register((String)"com.ibm.ws.i18n.context.I18nServiceClient", (String)"InternationalizationService", (String)"com.ibm.ws.i18n.context.rsrc.i18nctx");

    private I18nServiceClient() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"ctor");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"ctor", (Object)this);
        }
    }

    public static synchronized I18nService getInstance() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getInstance");
        }
        if (null == I18nService.instance) {
            new I18nServiceClient();
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getInstance", (Object)I18nService.instance);
        }
        return I18nService.instance;
    }

    public String computeProcessName() {
        String result;
        boolean isEntryEnabled;
        block8: {
            isEntryEnabled = tc.isEntryEnabled();
            if (isEntryEnabled) {
                Tr.entry((TraceComponent)tc, (String)"computeProcessName");
            }
            result = null;
            try {
                int idx;
                ClientProcessService cps = ((I18nClientComponentImpl)I18nServiceClient.getComponentImpl()).getClientProcessService();
                if (null != cps && null != (result = cps.getJ2EEName().toString()) && (idx = result.lastIndexOf(35)) >= 0 && result.length() > 0) {
                    result = result.substring(idx + 1);
                }
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.i18n.context.I18nServiceClient.computeProcessName", (String)"146", (Object)I18nServiceClient.getInstance());
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"computeProcessName", (Object)"An exception occurred while obtaining the client process name.");
                }
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"computeProcessName", (Object)"An exception occurred while obtaining the client process name.");
            }
        }
        if (null == result) {
            result = Messages.getMsg("MSG.PROCESS.NAME.CLIENT");
        }
        if (null == result) {
            result = "[client]";
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"computeProcessName", (Object)result);
        }
        return result;
    }

    public void initialize(Object initConfig) throws ComponentDisabledException, ConfigurationWarning {
        Exception err;
        boolean isEventEnabled;
        boolean isDebugEnabled;
        boolean isEntryEnabled;
        block45: {
            block47: {
                block46: {
                    block44: {
                        isEntryEnabled = tc.isEntryEnabled();
                        isDebugEnabled = tc.isDebugEnabled();
                        isEventEnabled = tc.isEventEnabled();
                        if (isEntryEnabled) {
                            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)initConfig);
                        }
                        if (0 < state) {
                            if (isEventEnabled) {
                                Tr.event((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service already attempted initialization on " + I18nServiceClient.getProcessName() + "; exit immediately."));
                            } else if (isDebugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service already attempted initialization on " + I18nServiceClient.getProcessName() + "; exit immediately."));
                            }
                            if (isEntryEnabled) {
                                Tr.exit((TraceComponent)tc, (String)"initialize");
                            }
                            return;
                        }
                        err = null;
                        boolean bl = isUserEnabled = !I18nService.isBackDoorDisabled();
                        if (isUserEnabled) {
                            Tr.info((TraceComponent)tc, (String)"INF.STATE", (Object)Messages.toArgs(Messages.getMsg("MSG.USER.ENABLED"), I18nServiceClient.getProcessName()));
                            if (isEventEnabled) {
                                Tr.event((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service is enabled on " + I18nServiceClient.getProcessName() + "."));
                            } else if (isDebugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service is enabled on " + I18nServiceClient.getProcessName() + "."));
                            }
                        } else {
                            Tr.info((TraceComponent)tc, (String)"INF.STATE", (Object)Messages.toArgs(Messages.getMsg("MSG.USER.DISABLED"), I18nServiceClient.getProcessName()));
                            if (isEventEnabled) {
                                Tr.event((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service is disabled on " + I18nServiceClient.getProcessName() + "; abort."));
                            } else if (isDebugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service is disabled on " + I18nServiceClient.getProcessName() + "; abort."));
                            }
                            if (isEntryEnabled) {
                                Tr.exit((TraceComponent)tc, (String)"initialize");
                            }
                            throw new ComponentDisabledException();
                        }
                        try {
                            this.getRmiOrb();
                            if (!isDebugEnabled) break block44;
                            Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("RMI singleton ORB succesfully obtained on " + I18nServiceClient.getProcessName() + "."));
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.i18n.context.I18nService.initialize", (String)"215", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"ERR.NO.ORB.SUPPORT", (Object)I18nServiceClient.getProcessName());
                            if (isEventEnabled) {
                                Tr.event((TraceComponent)tc, (String)"initialize", (Object)("An exception occurred while obtaining RMI singleton ORB on " + I18nServiceClient.getProcessName() + "; abort."));
                            } else if (isDebugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("An exception occurred while obtaining RMI singleton ORB on " + I18nServiceClient.getProcessName() + "; abort."));
                            }
                            err = e;
                            break block45;
                        }
                    }
                    try {
                        this.getThreadContextManager();
                        if (isEventEnabled) {
                            Tr.event((TraceComponent)tc, (String)"initialize", (Object)("Thread context manager successfully initialized on " + I18nServiceClient.getProcessName() + "."));
                            break block46;
                        }
                        if (!isDebugEnabled) break block46;
                        Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("Thread context manager successfully initialized on " + I18nServiceClient.getProcessName() + "."));
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.i18n.context.I18nService.initialize", (String)"236", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"ERR.NO.TCM.SUPPORT", (Object)I18nServiceClient.getProcessName());
                        if (isEventEnabled) {
                            Tr.event((TraceComponent)tc, (String)"initialize", (Object)("An exception occurred while initializing the ThreadContextManager on " + I18nServiceClient.getProcessName() + "; abort."));
                        } else if (isDebugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("An exception occurred while initializing the ThreadContextManager on " + I18nServiceClient.getProcessName() + "; abort."));
                        }
                        err = e;
                        break block45;
                    }
                }
                try {
                    ActivityService.registerLiteService((String)"com.ibm.ws.i18n", (HLSLiteDataInterface)this.getLiteData());
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"initialize", (Object)("IIOP handler successfully registered with Activity Service on " + I18nServiceClient.getProcessName() + "."));
                        break block47;
                    }
                    if (!isDebugEnabled) break block47;
                    Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("IIOP handler successfully registered with Activity Service on " + I18nServiceClient.getProcessName() + "."));
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.i18n.context.I18nService.initialize", (String)"258", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"ERR.NO.IIOP.SUPPORT", (Object)I18nServiceClient.getProcessName());
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"initialize", (Object)("An exception occurred while registering IIOP handler with the Activity Service on " + I18nServiceClient.getProcessName() + "; abort."));
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("An exception occurred while registering IIOP handler with the Activity Service on " + I18nServiceClient.getProcessName() + "; abort."));
                    }
                    err = e;
                    break block45;
                }
            }
            I18nServiceClient.setState((short)1);
        }
        if (isUserEnabled) {
            if (1 == state) {
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service succesfully initialized on " + I18nServiceClient.getProcessName() + "."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service successfully initialized on " + I18nServiceClient.getProcessName() + "."));
                }
            } else {
                I18nServiceClient.setState((short)3);
                if (null != err) {
                    Tr.error((TraceComponent)tc, (String)"ERR.INTRNL.EXC", (Object)Messages.toArgs(I18nService.getProcessName(), err));
                }
                Tr.info((TraceComponent)tc, (String)"INF.STATE.NOT", (Object)Messages.toArgs(Messages.getMsg("MSG.INITIALIZED"), I18nServiceClient.getProcessName()));
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service failed to initialize on " + I18nServiceClient.getProcessName() + "."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"initialize", (Object)("Internationalization service failed to initialize on " + I18nServiceClient.getProcessName() + "."));
                }
                if (isEntryEnabled) {
                    Tr.exit((TraceComponent)tc, (String)"initialize");
                }
                ConfigurationWarning cw = new ConfigurationWarning((Throwable)new ComponentDisabledException());
                throw cw;
            }
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start() {
        Exception err;
        boolean isEventEnabled;
        boolean isDebugEnabled;
        boolean isEntryEnabled;
        block38: {
            isEntryEnabled = tc.isEntryEnabled();
            isDebugEnabled = tc.isDebugEnabled();
            isEventEnabled = tc.isEventEnabled();
            if (isEntryEnabled) {
                Tr.entry((TraceComponent)tc, (String)"start");
            }
            if (!isUserEnabled) {
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"start", (Object)("Internationalization service not enabled on " + I18nServiceClient.getProcessName() + "; abort."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"start", (Object)("Internationalization service not enabled on " + I18nServiceClient.getProcessName() + "; abort."));
                }
                if (isEntryEnabled) {
                    Tr.exit((TraceComponent)tc, (String)"start");
                }
                return;
            }
            if (4 == state) {
                I18nServiceClient.setState((short)2);
                if (isEntryEnabled) {
                    Tr.exit((TraceComponent)tc, (String)"start");
                }
                return;
            }
            err = null;
            if (1 < state) {
                Tr.warning((TraceComponent)tc, (String)"INF.STATE.ALREADY", (Object)Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nServiceClient.getProcessName()));
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"start", (Object)("Internationalization service already started on " + I18nServiceClient.getProcessName() + "; exit immediately."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"start", (Object)("Internationalization service already started on " + I18nServiceClient.getProcessName() + "; exit immediately."));
                }
            } else if (1 > state) {
                Tr.warning((TraceComponent)tc, (String)"INF.STATE.NOT", (Object)Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nServiceClient.getProcessName()));
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"start", (Object)("Internationalization service not yet initialized on " + I18nServiceClient.getProcessName() + "; abort."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"start", (Object)("Internationalization service not yet initialized on " + I18nServiceClient.getProcessName() + "; abort."));
                }
            } else {
                try {
                    this.getUserInternationalization();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.i18n.context.I18nService.start", (String)"360", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"ERR.NO.API.SUPPORT", (Object)I18nServiceClient.getProcessName());
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"start", (Object)("An exception occurred while initializing Internationalization API on " + I18nServiceClient.getProcessName() + "; service API unavailable."));
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"start", (Object)("An exception occurred while initializing Internationalization API on " + I18nServiceClient.getProcessName() + "; service API unavailable."));
                    }
                    err = e;
                    break block38;
                }
                try {
                    ClientProcessService cps = ((I18nClientComponentImpl)componentImpl).getClientProcessService();
                    InitialContext javaColonCtx = (InitialContext)cps.getJavaColonCtx();
                    I18nJndiSupport.bindI18nContextApi(javaColonCtx);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.i18n.context.I18nService.initialize", (String)"380", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"ERR.NO.JNDI.SUPPORT", (Object)I18nServiceClient.getProcessName());
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"start", (Object)("An exception occurred while initializing the JNDI reference for UserInternationalization on " + I18nServiceClient.getProcessName() + "; service API unavailable to client."));
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"start", (Object)("An exception occurred while initializing the JNDI reference for UserInternationalization on " + I18nServiceClient.getProcessName() + "; service API unavailable to client."));
                    }
                    err = e;
                    break block38;
                }
                I18nServiceClient.setState((short)2);
            }
        }
        if (2 == state) {
            if (isEventEnabled) {
                Tr.event((TraceComponent)tc, (String)"start", (Object)("Internationalization service successfully started on " + I18nServiceClient.getProcessName() + "."));
            } else if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"start", (Object)("Internationalization service successfully started on " + I18nServiceClient.getProcessName() + "."));
            }
        } else {
            I18nServiceClient.setState((short)3);
            if (null != err) {
                Tr.error((TraceComponent)tc, (String)"ERR.INTRNL.EXC", (Object)Messages.toArgs(I18nServiceClient.getProcessName(), err));
            }
            Tr.info((TraceComponent)tc, (String)"INF.STATE.NOT", (Object)Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nServiceClient.getProcessName()));
            if (isEventEnabled) {
                Tr.event((TraceComponent)tc, (String)"start", (Object)("Internationalization service failed to start on " + I18nServiceClient.getProcessName() + "."));
            } else if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"start", (Object)("Internationalization service failed to start on " + I18nServiceClient.getProcessName() + "."));
            }
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        if (isUserEnabled) {
            I18nServiceClient.setState((short)4);
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (isUserEnabled) {
            I18nServiceClient.setState((short)5);
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }
}

