/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.LocalThreadContext_20;
import com.ibm.ws.i18n.context.ThreadContextManager;
import com.ibm.ws.i18n.context.util.XmlSoap;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

public class I18nClientSoapHandler
extends GenericHandler {
    private static final TraceComponent tc = Tr.register((String)"com.ibm.ws.i18n.context.I18nClientSoapHandler", (String)"InternationalizationService", (String)"com.ibm.ws.i18n.context.rsrc.i18nctx");
    private ThreadContextManager tcm = ThreadContextManager.getInstance();
    private static I18nService i18nService;

    public I18nClientSoapHandler() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"ctor");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"ctor");
        }
    }

    public void init(HandlerInfo config) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        super.init(config);
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void destroy() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public QName[] getHeaders() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getHeaders");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getHeaders");
        }
        return super.getHeaders();
    }

    public boolean handleRequest(MessageContext msgContext) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"handleRequest");
        }
        if (I18nService.getState() != 2) {
            if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"handleRequest", (Object)("Internationalization service is not started on " + I18nService.getProcessName() + "; ignore request."));
            }
        } else if (null == msgContext) {
            if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"handleRequest", (Object)"Message context is null; ignore request.");
            }
        } else {
            try {
                com.ibm.ws.webservices.engine.MessageContext mc = (com.ibm.ws.webservices.engine.MessageContext)msgContext;
                SOAPHeader sh = XmlSoap.getSoapHeader(mc);
                if (null == sh) {
                    if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"handleRequest", (Object)"SOAP header unavailable.");
                    }
                } else {
                    SOAPHeaderElement tish = sh.getHeaderByName("http://www.ibm.com/webservices/InternationalizationContext", "InternationalizationContext", true);
                    if (null == tish) {
                        SOAPHeaderElement ish;
                        if (isDebugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)"handleRequest", (Object)"no pre-existing I18N SOAP header");
                        }
                        if (null == (ish = (SOAPHeaderElement)sh.addHeaderElement(XmlSoap.I18N_CONTEXT_SAAJ_NAME))) {
                            if (isDebugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)"handleRequest", (Object)"Unable to create/insert SOAP Internationalization context header.");
                            }
                        } else {
                            ish.setMustUnderstand(false);
                            LocalThreadContext_20 ltc = (LocalThreadContext_20)this.tcm.getCurrentContext();
                            XmlSoap.appendContext(ish, ltc);
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.i18n.context.I18nClientSoapHandler.handleRequest", (String)"206", (Object)((Object)this));
                if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"handleRequest", (Object)("Exception: " + e));
                }
                e.printStackTrace();
            }
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"handleRequest");
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"handleResponse");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"handleResponse");
        }
        return true;
    }

    public void handleClosure(MessageContext msgContext) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"handleClosure");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"handleClosure");
        }
    }

    public boolean handleFault(MessageContext msgContext) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"handleFault");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"handleFault");
        }
        return true;
    }

    void log(String msg) {
        System.out.println(null == msg ? "<Z>" : msg);
    }
}

