/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.util.LocaleList;
import java.io.Serializable;
import java.util.Locale;

public final class I18nAttr
implements Serializable {
    static final long serialVersionUID = 3331836332080425256L;
    private static final TraceComponent tc = Tr.register((String)"com.ibm.ws.i18n.context.I18nAttr", (String)"InternationalizationService", (String)"com.ibm.ws.i18n.context.rsrc.i18nctx");
    public static final short UNKNOWN = -1;
    private short i18nType = (short)-1;
    public static final short AMI = 0;
    public static final short CMI = 1;
    private short runAs = (short)-1;
    public static final short RUN_AS_CALLER = 0;
    public static final short RUN_AS_SERVER = 1;
    public static final short RUN_AS_SPECIFIED = 2;
    private Locale[] locales = null;
    private String timeZoneId = null;
    public static final I18nAttr AMI_RUN_AS_SERVER = new I18nAttr(0, 1, null, null);
    public static I18nAttr CMI_RUN_AS_CALLER = new I18nAttr(1, 0, null, null);
    public static I18nAttr CMI_RUN_AS_SERVER = new I18nAttr(1, 1, null, null);

    public I18nAttr() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"ctor");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"ctor", (Object)this);
        }
    }

    public I18nAttr(short i18nType, short runAs, Locale[] locales, String timeZoneId) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"ctor");
        }
        this.i18nType = i18nType;
        this.runAs = runAs;
        if (null == locales) {
            this.locales = locales;
        } else {
            this.locales = new Locale[locales.length];
            System.arraycopy(locales, 0, this.locales, 0, locales.length);
        }
        this.timeZoneId = timeZoneId;
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"ctor", (Object)this);
        }
    }

    public short getI18nType() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getI18nType");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getI18nType", (Object)Short.toString(this.i18nType));
        }
        return this.i18nType;
    }

    public void setI18nType(short i18nType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"setI18nType", (Object)Short.toString(i18nType));
        }
        if (0 <= i18nType && i18nType <= 1) {
            this.i18nType = i18nType;
        } else {
            this.i18nType = (short)-1;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setI18nType", (Object)("The supplied type value is out of range on " + I18nService.getProcessName() + "; default to UNKNOWN."));
            }
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"setI18nType");
        }
    }

    public short getRunAs() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getRunAs");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getRunAs", (Object)Short.toString(this.runAs));
        }
        return this.runAs;
    }

    public void setRunAs(short runAs) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"setRunAs", (Object)Short.toString(runAs));
        }
        this.runAs = runAs;
        if (0 <= runAs && runAs <= 2) {
            this.runAs = runAs;
        } else {
            this.runAs = (short)-1;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setRunAs", (Object)("The supplied runAs value is out of range on " + I18nService.getProcessName() + "; default to UNKNOWN."));
            }
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"setRunAs");
        }
    }

    public Locale[] getLocales() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getLocales");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getLocales", (Object)this.locales);
        }
        return this.locales;
    }

    public void setLocales(Locale[] locales) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"setLocales", (Object)locales);
        }
        this.locales = locales;
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"setLocales");
        }
    }

    public String getTimeZoneId() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getTimeZoneId");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getTimeZoneId", (Object)this.timeZoneId);
        }
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"setTimeZoneId", (Object)timeZoneId);
        }
        this.timeZoneId = timeZoneId;
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"setTimeZoneId");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        switch (this.i18nType) {
            case 0: {
                result.append("AMI");
                break;
            }
            case 1: {
                result.append("CMI");
                break;
            }
            default: {
                result.append("?MI");
            }
        }
        switch (this.runAs) {
            case 0: {
                result.append(",RunAsCaller");
                break;
            }
            case 1: {
                result.append(",RunAsServer");
                break;
            }
            case 2: {
                result.append(",RunAsSpecified");
                result.append(",Locales=" + (null == this.locales ? "null" : LocaleList.toString_20(this.locales)));
                result.append(",TimeZoneId=" + (null == this.timeZoneId ? "null" : this.timeZoneId.toString()));
                break;
            }
            default: {
                result.append(",RunAs?");
            }
        }
        result.append("]");
        return result.toString();
    }

    public static String toString(I18nAttr i18nAttr) {
        if (null == i18nAttr) {
            return "null";
        }
        return i18nAttr.toString();
    }
}

