/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.ContextType;
import com.ibm.ws.i18n.context.I18nAttr;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.LocalThreadContext_20;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.ThreadContextManager;
import com.ibm.ws.i18n.context.util.Locale;
import com.ibm.ws.i18n.context.util.LocaleList;
import com.ibm.ws.i18n.context.util.TimeZone;

public class I18nApiImpl {
    private static final TraceComponent tc = Tr.register((String)"com.ibm.ws.i18n.context.b", (String)"InternationalizationService", (String)"com.ibm.ws.i18n.context.rsrc.i18nctx");
    protected static ThreadContextManager threadContextManager = ThreadContextManager.getInstance();
    protected static boolean STRICT_USAGE = true;

    private I18nApiImpl() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"ctor");
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"ctor", (Object)this);
        }
    }

    public static void setCurrentLocales_20(java.util.Locale[] locales, ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        boolean isEventEnabled = tc.isEventEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)locales);
        }
        try {
            I18nAttr i18nAttrib;
            if (2 != I18nService.getState()) {
                if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)("Internationalization Service is not started on " + I18nService.getProcessName() + ": throw ISE."));
                }
                throw new IllegalStateException(Messages.getMsg("INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nService.getProcessName())));
            }
            LocalThreadContext_20 currentContext = (LocalThreadContext_20)threadContextManager.getCurrentContext();
            if (null == currentContext) {
                currentContext = LocalThreadContext_20.newInstance(null, null, null, null, I18nAttr.AMI_RUN_AS_SERVER);
            }
            if (null == (i18nAttrib = currentContext.getI18nAttr())) {
                if (!STRICT_USAGE) {
                    Tr.warning((TraceComponent)tc, (String)"INF.ATTR.DEFAULT.USED", (Object)Messages.toArgs(Messages.getMsg("MSG.ATTR.AMI.RUNASSERVER"), I18nService.getProcessName()));
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply the default, [AMI RunAsServer].");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply the default, [AMI RunAsServer].");
                    }
                    currentContext.setI18nAttr(I18nAttr.AMI_RUN_AS_SERVER);
                } else {
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    }
                    if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    }
                    throw new IllegalStateException(Messages.getMsg("INF.CTX.MISSING", Messages.toArgs(Messages.getMsg("MSG.CTX.LOCALE"), I18nService.getProcessName())));
                }
            }
            if (0 != i18nAttrib.getI18nType()) {
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)("Invocation locale may be set under the AMI Internationalization policy, only: " + I18nAttr.toString(i18nAttrib)));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)("Invocation locale may be set under the AMI Internationalization policy, only: " + I18nAttr.toString(i18nAttrib)));
                }
                throw new IllegalStateException(Messages.getMsg("ERR.CTX.CMI.ACCESS.EXC", Messages.toArgs(i18nAttrib.toString())));
            }
            if (null == locales) {
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)"Supplied locale is null; apply the default JVM locale.");
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)"Supplied locale is null; apply the default JVM locale.");
                }
                locales = LocaleList.getDefault_20();
            }
            currentContext.setLocaleList(LocaleList.clone_20(locales), contextType);
            threadContextManager.setCurrentContext(currentContext);
        }
        catch (IllegalStateException exc1) {
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"setCurrentLocales_20");
            }
            throw exc1;
        }
        catch (Exception exc2) {
            FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.i18n.context.I18nApiImpl.setCurrentLocales_20", (String)"180");
            Tr.error((TraceComponent)tc, (String)"ERR.INTRNL.EXC", (Object)Messages.toArgs(I18nService.getProcessName(), exc2));
            if (isEventEnabled) {
                Tr.event((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)("An unexpected exception occured setting current locales: " + exc2));
            } else if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"setCurrentLocales_20", (Object)("An unexpected exception occured setting current locales: " + exc2));
            }
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"setCurrentLocales_20");
            }
            throw new IllegalStateException(Messages.getMsg("ERR.INTRNL.EXC", Messages.toArgs(exc2)));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"setCurrentLocales_20");
        }
    }

    public static void setCurrentTimeZone_20(java.util.TimeZone timezone, ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        boolean isEventEnabled = tc.isEventEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)timezone);
        }
        try {
            I18nAttr i18nAttrib;
            if (2 != I18nService.getState()) {
                if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)("Internationalization Service is not started on " + I18nService.getProcessName() + ": throw ISE."));
                }
                throw new IllegalStateException(Messages.getMsg("INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nService.getProcessName())));
            }
            LocalThreadContext_20 currentContext = (LocalThreadContext_20)threadContextManager.getCurrentContext();
            if (null == currentContext) {
                currentContext = LocalThreadContext_20.newInstance(null, null, null, null, I18nAttr.AMI_RUN_AS_SERVER);
            }
            if (null == (i18nAttrib = currentContext.getI18nAttr())) {
                if (!STRICT_USAGE) {
                    Tr.warning((TraceComponent)tc, (String)"INF.ATTR.DEFAULT.USED", (Object)new Object[]{Messages.getMsg("MSG.ATTR.AMI.RUNASSERVER"), I18nService.getProcessName()});
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply the default, [AMI, RunAsServer].");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply the default, [AMI, RunAsServer].");
                    }
                    currentContext.setI18nAttr(I18nAttr.AMI_RUN_AS_SERVER);
                } else {
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (strict usage): throw ISE.");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    }
                    throw new IllegalStateException(Messages.getMsg("INF.CTX.MISSING", Messages.toArgs(Messages.getMsg("MSG.CTX.TIMEZONE"), I18nService.getProcessName())));
                }
            }
            if (0 != i18nAttrib.getI18nType()) {
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)("Invocation locale may be set under the AMI Internationalization policy, only: " + I18nAttr.toString(i18nAttrib)));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)("Invocation locale may be set under the AMI Internationalization policy, only: " + I18nAttr.toString(i18nAttrib)));
                }
                throw new IllegalStateException(Messages.getMsg("ERR.CTX.CMI.ACCESS.EXC", Messages.toArgs(i18nAttrib.toString())));
            }
            if (null == timezone) {
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)"Supplied time zone is null; apply the default JVM time zone.");
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)"Supplied time zone is null; apply the default JVM time zone.");
                }
                timezone = TimeZone.getDefault_20();
            }
            currentContext.setTimeZone(timezone, contextType);
            threadContextManager.setCurrentContext(currentContext);
        }
        catch (IllegalStateException exc1) {
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"setCurrentTimeZone_20");
            }
            throw exc1;
        }
        catch (Exception exc2) {
            FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.i18n.context.I18nApiImpl.setCurrentTimeZone_20", (String)"298");
            Tr.error((TraceComponent)tc, (String)"ERR.INTRNL.EXC", (Object)Messages.toArgs(I18nService.getProcessName(), exc2));
            if (isEventEnabled) {
                Tr.event((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)("An unexpected exception occured setting current time zone: " + exc2));
            } else if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"setCurrentTimeZone_20", (Object)("An unexpected exception occured setting current time zone: " + exc2));
            }
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"setCurrentTimeZone_20");
            }
            throw new IllegalStateException(Messages.getMsg("ERR.INTRNL.EXC", Messages.toArgs(exc2)));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"setCurrentTimeZone_20");
        }
    }

    public static java.util.Locale getCurrentLocale_20(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        boolean isEventEnabled = tc.isEventEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getCurrentLocale_20");
        }
        java.util.Locale result = null;
        try {
            java.util.Locale[] currentLocaleList;
            I18nAttr i18nAttrib;
            if (2 != I18nService.getState()) {
                if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)("Internationalization Service is not started on " + I18nService.getProcessName() + ": throw ISE."));
                }
                throw new IllegalStateException(Messages.getMsg("INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nService.getProcessName())));
            }
            LocalThreadContext_20 currentContext = (LocalThreadContext_20)threadContextManager.getCurrentContext();
            if (null == currentContext) {
                currentContext = LocalThreadContext_20.newInstance(null, null, null, null, I18nAttr.AMI_RUN_AS_SERVER);
            }
            if (null == (i18nAttrib = currentContext.getI18nAttr())) {
                if (!STRICT_USAGE) {
                    Tr.warning((TraceComponent)tc, (String)"INF.ATTR.DEFAULT.USED", (Object)Messages.toArgs(Messages.getMsg("MSG.ATTR.AMI.RUNASSERVER"), I18nService.getProcessName()));
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply the default, [AMI RunAsServer].");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply the default, [AMI RunAsServer].");
                    }
                    currentContext.setI18nAttr(I18nAttr.AMI_RUN_AS_SERVER);
                } else {
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    }
                    throw new IllegalStateException(Messages.getMsg("INF.CTX.MISSING", Messages.toArgs(Messages.getMsg("MSG.CTX.LOCALE"), I18nService.getProcessName())));
                }
            }
            if (null == (currentLocaleList = (java.util.Locale[])currentContext.getLocaleList(contextType)) || currentLocaleList.length < 1) {
                result = Locale.getDefault_20();
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)(contextType + " locales unavailable; apply the default JVM locale."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)(contextType + " locales unavailable; apply the default JVM locale."));
                }
            } else {
                result = LocaleList.tail_20(currentLocaleList);
            }
        }
        catch (IllegalStateException exc1) {
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentLocale_20");
            }
            throw exc1;
        }
        catch (Exception exc2) {
            FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.i18n.context.I18nApiImpl.getCurrentLocale_20", (String)"408");
            Tr.error((TraceComponent)tc, (String)"ERR.INTRNL.EXC", (Object)Messages.toArgs(I18nService.getProcessName(), exc2));
            if (isEventEnabled) {
                Tr.event((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)("An unexpected exception occured getting current locale: " + exc2));
            } else if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)("An unexpected exception occured getting current locale: " + exc2));
            }
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentLocale_20");
            }
            throw new IllegalStateException(Messages.getMsg("ERR.INTRNL.EXC", Messages.toArgs(exc2)));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getCurrentLocale_20", (Object)result);
        }
        return result;
    }

    public static java.util.Locale[] getCurrentLocales_20(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        boolean isEventEnabled = tc.isEventEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getCurrentLocales_20");
        }
        java.util.Locale[] result = null;
        try {
            java.util.Locale[] currentLocaleList;
            I18nAttr i18nAttrib;
            if (2 != I18nService.getState()) {
                if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)("Internationalization Service is not started on " + I18nService.getProcessName() + ": throw ISE."));
                }
                throw new IllegalStateException(Messages.getMsg("INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nService.getProcessName())));
            }
            LocalThreadContext_20 currentContext = (LocalThreadContext_20)threadContextManager.getCurrentContext();
            if (null == currentContext) {
                currentContext = LocalThreadContext_20.newInstance(null, null, null, null, I18nAttr.AMI_RUN_AS_SERVER);
            }
            if (null == (i18nAttrib = currentContext.getI18nAttr())) {
                if (!STRICT_USAGE) {
                    Tr.warning((TraceComponent)tc, (String)"INF.ATTR.DEFAULT.USED", (Object)Messages.toArgs(Messages.getMsg("MSG.ATTR.AMI.RUNASSERVER"), I18nService.getProcessName()));
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply default, [AMI RunAsServer].");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply default, [AMI RunAsServer].");
                    }
                    currentContext.setI18nAttr(I18nAttr.AMI_RUN_AS_SERVER);
                } else {
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    }
                    throw new IllegalStateException(Messages.getMsg("INF.CTX.MISSING", Messages.toArgs(Messages.getMsg("MSG.CTX.LOCALE"), I18nService.getProcessName())));
                }
            }
            if (null == (currentLocaleList = (java.util.Locale[])currentContext.getLocaleList(contextType)) || currentLocaleList.length < 1) {
                result = LocaleList.getDefault_20();
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)(contextType + " locales unavailable; apply the default JVM locale."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)(contextType + " locales unavailable; apply the default JVM locale."));
                }
            } else {
                result = currentLocaleList;
            }
        }
        catch (IllegalStateException exc1) {
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentLocales_20");
            }
            throw exc1;
        }
        catch (Exception exc2) {
            FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.i18n.context.I18nApiImpl.getCurrentLocales_20", (String)"519");
            Tr.error((TraceComponent)tc, (String)"ERR.INTRNL.EXC", (Object)Messages.toArgs(I18nService.getProcessName(), exc2));
            if (isEventEnabled) {
                Tr.event((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)("An unexpected exception occured getting current locales: " + exc2));
            } else if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)("An unexpected exception occured getting current locales: " + exc2));
            }
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentLocales_20");
            }
            throw new IllegalStateException(Messages.getMsg("ERR.INTRNL.EXC", Messages.toArgs(exc2)));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getCurrentLocales_20", (Object)result);
        }
        return result;
    }

    public static java.util.TimeZone getCurrentTimeZone_20(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        boolean isEventEnabled = tc.isEventEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getCurrentTimeZone_20");
        }
        java.util.TimeZone result = null;
        try {
            java.util.TimeZone currentTimeZone;
            I18nAttr i18nAttrib;
            if (2 != I18nService.getState()) {
                if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)("Internationalization Service is not started on " + I18nService.getProcessName() + ": throw ISE."));
                }
                throw new IllegalStateException(Messages.getMsg("INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nService.getProcessName())));
            }
            LocalThreadContext_20 currentContext = (LocalThreadContext_20)threadContextManager.getCurrentContext();
            if (null == currentContext) {
                currentContext = LocalThreadContext_20.newInstance(null, null, null, null, I18nAttr.AMI_RUN_AS_SERVER);
            }
            if (null == (i18nAttrib = currentContext.getI18nAttr())) {
                if (!STRICT_USAGE) {
                    Tr.warning((TraceComponent)tc, (String)"INF.ATTR.DEFAULT.USED", (Object)new Object[]{Messages.getMsg("MSG.ATTR.AMI.RUNASSERVER"), I18nService.getProcessName()});
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (non-strict usage): apply the default, [AMI RunAsServer].");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (non-strict usage); apply the default, [AMI RunAsServer].");
                    }
                    currentContext.setI18nAttr(I18nAttr.AMI_RUN_AS_SERVER);
                } else {
                    if (isEventEnabled) {
                        Tr.event((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    } else if (isDebugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)"Context lacks Internationalization policy (strict usage); throw ISE.");
                    }
                    throw new IllegalStateException(Messages.getMsg("INF.CTX.MISSING", Messages.toArgs(Messages.getMsg("MSG.CTX.LOCALE"), I18nService.getProcessName())));
                }
            }
            if (null == (currentTimeZone = (java.util.TimeZone)currentContext.getTimeZone(contextType))) {
                result = TimeZone.getDefault_20();
                if (isEventEnabled) {
                    Tr.event((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)(contextType + " time zone unavailable; apply the default JVM time zone."));
                } else if (isDebugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)(contextType + " time zone unavailable; apply the default JVM time zone."));
                }
            } else {
                result = currentTimeZone;
            }
        }
        catch (IllegalStateException exc1) {
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentTimeZone_20");
            }
            throw exc1;
        }
        catch (Exception exc2) {
            FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.i18n.context.I18nApiImpl.getCurrentTimeZone_20", (String)"631");
            Tr.error((TraceComponent)tc, (String)"ERR.INTRNL.EXC", (Object)Messages.toArgs(I18nService.getProcessName(), exc2));
            if (isEventEnabled) {
                Tr.event((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)("An unexpected exception occured while getting current time zone: " + I18nService.getProcessName() + ": " + exc2));
            } else if (isDebugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"getCurrentTimeZone_20", (Object)("An unexpected exception occured while getting current time zone: " + I18nService.getProcessName() + ": " + exc2));
            }
            if (isEntryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"getCurrentTimeZone_20");
            }
            throw new IllegalStateException(Messages.getMsg("ERR.INTRNL.EXC", Messages.toArgs(exc2)));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"getCurrentTimeZone_20");
        }
        return result;
    }
}

