/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;

    RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPrivateKey.a("_0\u0015\u001b}\u001c1\u000f\u00039x\u001a2W|R<\u000f\u0013|\u0006\u007f") + iOException.getMessage());
        }
    }

    RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public String toString() {
        return RSAPrivateKey.a("u\u001d-=Zy\u0019)'J\u001c\r369l-\t\u0001xH:@<|Eej\u001avX*\f\u0002j\u0006U") + this.modulus.toString() + "\n" + RSAPrivateKey.a("L-\t\u0001xH:@\u0012aL0\u000e\u0012wHej") + this.privateExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(RSAPrivateKey.a("u1\u0016\u0016uU;@%J}\u000f\u0012\u001eo]+\u0005<|E\u007f\u0005\u0019zS;\t\u0019~\u0010\u007f\u0004\u0016m]\u007f\u000f\u0001|N-\u0015\u0019"));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void zeroize() {
        this.modulus = BigInteger.ZERO;
        this.privateExponent = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 60;
                        break;
                    }
                    case 1: {
                        n5 = 95;
                        break;
                    }
                    case 2: {
                        n5 = 96;
                        break;
                    }
                    case 3: {
                        n5 = 119;
                        break;
                    }
                    default: {
                        n5 = 25;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

