/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class JarEntry {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZipEntry zipentry = null;
    private String fileName = null;
    private String manifestHeader = null;
    private byte[] byteArray = null;

    public JarEntry(String string, String string2) {
        this.zipentry = new ZipEntry(string);
        this.fileName = string2;
    }

    public JarEntry(String string, String string2, byte[] byArray) {
        this.zipentry = new ZipEntry(string);
        this.fileName = string2;
        this.byteArray = byArray;
    }

    public byte[] getByteArray() throws IOException {
        if (this.byteArray == null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.getFileName()));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = bufferedInputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = bufferedInputStream.read();
            }
            if (byteArrayOutputStream != null) {
                this.byteArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return this.byteArray;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getManifestHeader() {
        return this.manifestHeader;
    }

    public ZipEntry getZipEntry() {
        return this.zipentry;
    }

    public void setManifestHeader(String string) {
        this.manifestHeader = string;
    }
}

