/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.deploywrapper;

import com.ibm.ejs.container.util.NameUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejbdeploy.Database;
import com.ibm.etools.ejbdeploy.EJBDeploy;
import com.ibm.etools.ejbdeploy.EJBDeploymentException;
import com.ibm.etools.ejbdeploy.IStatusMonitor;
import com.ibm.etools.ejbdeploy.Options;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DeployUtil {
    private static TraceComponent tc = Tr.register((Class)DeployUtil.class);
    private static NLS messagesNLS = new NLS("messages");

    protected static String getMessage(String string, String string2) {
        return messagesNLS.getString(string, string2);
    }

    protected static String getMessage(String string, Object object, String string2) {
        return messagesNLS.getFormattedMessage(string, new Object[]{object}, string2);
    }

    protected static void statusMessage(IStatusMonitor iStatusMonitor, String string, Object object, String string2) {
        iStatusMonitor.taskMessage(DeployUtil.getMessage(string, object, string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deploy(Archive archive, DeployOptions deployOptions, IStatusMonitor iStatusMonitor) throws EJBDeploymentException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"deploy", (Object)(archive + "," + deployOptions));
            }
            String string = null;
            try {
                try {
                    String string2 = deployOptions.getWorkingDirectory();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("workingDirectory:" + string2));
                    }
                    EJBDeploy eJBDeploy = new EJBDeploy(string2);
                    deployOptions.setInputModuleName(archive.getURI());
                    DeployUtil.deployModule(eJBDeploy, (ModuleFile)archive, deployOptions, iStatusMonitor);
                }
                catch (EJBDeploymentException eJBDeploymentException) {
                    throw eJBDeploymentException;
                }
                catch (Exception exception) {
                    string = DeployUtil.getMessage("deployexception.ExceptionThrownDuringDeployment", "exception is thrown during deployment process");
                    throw new EJBDeploymentException(string, (Throwable)exception, false);
                }
                Object var7_9 = null;
                if (string == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (string != null) {
                    DeployUtil.deleteAll(string);
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)tc, (String)"deploy");
                throw throwable;
            }
            DeployUtil.deleteAll(string);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"deploy");
    }

    public static void deploy(String string, DeployOptions deployOptions, IStatusMonitor iStatusMonitor) throws EJBDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deploy", (Object)(string + ',' + deployOptions));
        }
        Archive archive = null;
        try {
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            archive = commonarchiveFactory.openArchive(string);
        }
        catch (Exception exception) {
            String string2 = DeployUtil.getMessage("deployexception.UnableToOpenArchive", "Unable to open the archive file");
            throw new EJBDeploymentException(string2, (Throwable)exception, false);
        }
        DeployUtil.deploy(archive, deployOptions, iStatusMonitor);
        archive.close();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deploy");
        }
    }

    public static boolean isDeployed(String string) throws EJBDeploymentException {
        Archive archive;
        try {
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            archive = commonarchiveFactory.openArchive(string);
        }
        catch (Exception exception) {
            String string2 = DeployUtil.getMessage("deployexception.CannotOpenArchive", string, "Cannot open archive file: {0}");
            throw new EJBDeploymentException(string2, (Throwable)exception, false);
        }
        if (archive instanceof EJBJarFile) {
            boolean bl = DeployUtil.isEJBJarDeployed((EJBJarFile)archive);
            ((EJBJarFile)archive).close();
            return bl;
        }
        if (archive instanceof EARFile) {
            boolean bl = true;
            List list = ((EARFile)archive).getEJBJarFiles();
            for (int i = 0; bl && i < list.size(); ++i) {
                EJBJarFile eJBJarFile = (EJBJarFile)list.get(i);
                bl = DeployUtil.isEJBJarDeployed(eJBJarFile);
            }
            ((EARFile)archive).close();
            return bl;
        }
        return false;
    }

    public static boolean isEJBJarDeployed(EJBJarFile eJBJarFile) {
        EJBJar eJBJar = eJBJarFile.getDeploymentDescriptor();
        Iterator iterator = eJBJar.getEnterpriseBeans().iterator();
        boolean bl = true;
        while (bl && iterator.hasNext()) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
            if (enterpriseBean.isMessageDriven()) continue;
            String string = NameUtil.getRemoteImplClassName((EnterpriseBean)enterpriseBean, (eJBJar.getVersionID() >= 20 ? 1 : 0) != 0);
            if (string == null) {
                string = NameUtil.getLocalImplClassName((EnterpriseBean)enterpriseBean, (eJBJar.getVersionID() >= 20 ? 1 : 0) != 0);
            }
            if (string != null) {
                string = string.replace('.', '/') + ".class";
                bl = eJBJarFile.containsFile(string);
                continue;
            }
            System.out.println("EJB is not an MDB but the remote and local interfaces are null. This should not happen");
        }
        return bl;
    }

    private static void deployModule(final EJBDeploy eJBDeploy, ModuleFile moduleFile, DeployOptions deployOptions, final IStatusMonitor iStatusMonitor) throws EJBDeploymentException {
        String string;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deployModule", (Object)moduleFile);
        }
        if (moduleFile instanceof EJBJarFile) {
            object = ((EJBJarFile)moduleFile).getDeploymentDescriptor();
            string = object.getEjbClientJar();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("clientJar:" + string));
            }
            deployOptions.setClientJarName(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("options:" + deployOptions));
        }
        if ((string = (String)((Properties)(object = System.getProperties())).get("com.ibm.itp.location")) == null || string.equals("")) {
            String string2 = DeployUtil.getMessage("deployexception.com.ibm.itp.locationNotSet", "com.ibm.itp.location needs to be set");
            throw new EJBDeploymentException(string2, new Throwable(), false);
        }
        final Options options = DeployUtil.convert(deployOptions);
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Calling deployer.execute() in doPrivileged()");
                    }
                    eJBDeploy.execute(options, iStatusMonitor, string);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (EJBDeploymentException)((Object)privilegedActionException.getException());
        }
    }

    private static Options convert(DeployOptions deployOptions) throws EJBDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convert", (Object)deployOptions);
        }
        Options options = new Options();
        if (deployOptions.getClasspath() != null) {
            options.setClasspath(deployOptions.getClasspath());
        }
        options.setCodegenOnly(deployOptions.isCodegenOnly());
        if (deployOptions.getDeployedModuleName() != null) {
            options.setDeployedModuleName(deployOptions.getDeployedModuleName());
        }
        if (deployOptions.getInputModuleName() != null) {
            options.setInputModuleName(deployOptions.getInputModuleName());
        }
        options.setUse40MappingRules(deployOptions.isUse40MappingRules());
        options.setValidation(deployOptions.isValidation());
        options.setRMICOptions(deployOptions.getRMICOptions());
        options.setDatabaseVendor(DeployUtil.convertToDatabase(deployOptions.getDatabaseType()));
        options.setDatabaseName(deployOptions.getDatabaseName());
        options.setDatabaseSchemaName(deployOptions.getSchemaName());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("newOptions:" + options));
        }
        return options;
    }

    private static Database convertToDatabase(String string) {
        Database database = null;
        if (string == null) {
            return database;
        }
        if (string.equals("DB2UDB_V81")) {
            database = Database.DB2UDB_V81;
        } else if (string.equals("DB2UDB_V82")) {
            database = Database.DB2UDB_V82;
        } else if (string.equals("DB2EXPRESS_V81")) {
            database = Database.DB2EXPRESS_V81;
        } else if (string.equals("DB2EXPRESS_V82")) {
            database = Database.DB2EXPRESS_V82;
        } else if (string.equals("CLOUDSCAPE_V5")) {
            database = Database.CLOUDSCAPE_V5;
        } else if (string.equals("DERBY_V10")) {
            database = Database.DB2CLOUDSCAPE_V8;
        } else if (string.equals("DB2UDBOS390_V7")) {
            database = Database.DB2UDBOS390_V7;
        } else if (string.equals("DB2UDBOS390_V8")) {
            database = Database.DB2UDBOS390_V8;
        } else if (string.equals("DB2UDBISERIES")) {
            database = Database.DB2UDBISERIES;
        } else if (string.equals("DB2UDBISERIES_V52")) {
            database = Database.DB2UDBISERIES;
        } else if (string.equals("DB2UDBISERIES_V53")) {
            database = Database.DB2UDBISERIES;
        } else if (string.equals("INFORMIX_V73")) {
            database = Database.INFORMIX_V73;
        } else if (string.equals("INFORMIX_V93")) {
            database = Database.INFORMIX_V93;
        } else if (string.equals("INFORMIX_V94")) {
            database = Database.INFORMIX_V94;
        } else if (string.equals("MSSQLSERVER_V7")) {
            database = Database.MSSQLSERVER_V7;
        } else if (string.equals("MSSQLSERVER_2000")) {
            database = Database.MSSQLSERVER_2000;
        } else if (string.equals("ORACLE_V8")) {
            database = Database.ORACLE_V8;
        } else if (string.equals("ORACLE_V9I")) {
            database = Database.ORACLE_V9I;
        } else if (string.equals("ORACLE_V10G")) {
            database = Database.ORACLE_V10G;
        } else if (string.equals("SYBASE_V1200")) {
            database = Database.SYBASE_V1200;
        } else if (string.equals("SYBASE_V1250")) {
            database = Database.SYBASE_V1250;
        } else if (string.equals("SQL92")) {
            database = Database.SQL92;
        } else if (string.equals("SQL99")) {
            database = Database.SQL99;
        }
        return database;
    }

    private static void deleteAll(String string) {
        File file = new File(string);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteAll", (Object)file.getAbsolutePath());
        }
        if (file.exists()) {
            if (!file.isFile()) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    DeployUtil.deleteAll(string + File.separator + stringArray[i]);
                }
            }
            if (!file.delete()) {
                // empty if block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteAll");
        }
    }

    private static File renameSource(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"renameSource", (Object)string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append("_source");
            stringBuffer.append(string.substring(n));
        } else {
            stringBuffer.append(string).append("_source");
        }
        File file = new File(string);
        File file2 = new File(stringBuffer.toString());
        file.renameTo(file2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"renameSource", (Object)file2);
        }
        return file2;
    }
}

