/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.exception.WsRuntimeFwException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.AsynchronousInitializer;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.component.ThreadContextHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.Join;
import com.ibm.ws.util.ThreadPool;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ComponentImpl
implements Component,
BeanContextChild,
BeanContextServiceProvider,
BeanContextServiceRevokedListener {
    private static final TraceComponent tc = Tr.register((Class)ComponentImpl.class, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    protected String name;
    protected String state;
    private BeanContext beanContext;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private boolean inhibitMultiThreadedBehavior = inhibtMultiThreadedBehaviorGlobally;
    private static boolean inhibtMultiThreadedBehaviorGlobally = false;
    private Join join = null;
    private WsException latchedAsynchronousException = null;
    private static ThreadPool initializers = null;
    private ThreadContextHelper threadContextHelper = null;

    static void _setStartupThreadPool(ThreadPool threadPool) {
        initializers = threadPool;
    }

    protected static void setGlobalAsynchBehaviorInhibited(boolean bl) {
        inhibtMultiThreadedBehaviorGlobally = bl;
    }

    void inhibitAsynchBehavior() {
        this.inhibitMultiThreadedBehavior = true;
    }

    protected final void runAsynchronousInitializer(AsynchronousInitializer asynchronousInitializer) throws WsRuntimeFwException {
        this.runAsynchronousInitializer(asynchronousInitializer, true);
    }

    protected final void runAsynchronousInitializer(AsynchronousInitializer asynchronousInitializer, boolean bl) throws WsRuntimeFwException {
        if (this.inhibitMultiThreadedBehavior || initializers == null) {
            asynchronousInitializer.run();
            return;
        }
        try {
            if (bl) {
                if (this.join == null) {
                    this.join = new Join();
                }
                this.join.increment();
            }
            _AsynchInitializer _AsynchInitializer2 = new _AsynchInitializer(asynchronousInitializer, bl);
            initializers.execute((Runnable)_AsynchInitializer2);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)this.getClass().getName(), (String)"103");
        }
    }

    protected final void join() throws ConfigurationWarning, ConfigurationError, ComponentDisabledException, RuntimeWarning, RuntimeError {
        if (this.join == null) {
            return;
        }
        this.join.join();
        if (this.latchedAsynchronousException != null) {
            if (this.latchedAsynchronousException instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof ConfigurationError) {
                throw (ConfigurationError)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof ComponentDisabledException) {
                throw (ComponentDisabledException)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof RuntimeWarning) {
                throw (RuntimeWarning)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof RuntimeError) {
                throw (RuntimeError)this.latchedAsynchronousException;
            }
            FFDCFilter.processException((Throwable)this.latchedAsynchronousException, (String)this.getClass().getName(), (String)"108");
            throw new RuntimeWarning("unexpected asynchronous exception: " + this.latchedAsynchronousException);
        }
    }

    private int exceptionRank(WsException wsException) {
        if (wsException instanceof ConfigurationWarning) {
            return 0;
        }
        if (wsException instanceof ConfigurationError) {
            return 2;
        }
        if (wsException instanceof ComponentDisabledException) {
            return 1;
        }
        if (wsException instanceof RuntimeWarning) {
            return 3;
        }
        if (wsException instanceof RuntimeError) {
            return 4;
        }
        FFDCFilter.processException((Throwable)this.latchedAsynchronousException, (String)this.getClass().getName(), (String)"198");
        return -1;
    }

    private void latchAsychronousException(WsException wsException) {
        FFDCFilter.processException((Throwable)wsException, (String)this.getClass().getName(), (String)"198");
        if (this.latchedAsynchronousException != null) {
            if (this.exceptionRank(wsException) > this.exceptionRank(this.latchedAsynchronousException)) {
                this.latchedAsynchronousException = wsException;
            }
        } else {
            this.latchedAsynchronousException = wsException;
        }
    }

    private ThreadContextHelper getThreadContextHelper() {
        if (this.threadContextHelper == null) {
            this.threadContextHelper = (ThreadContextHelper)ImplFactory.loadImplFromKey((Class)ThreadContextHelper.class);
        }
        return this.threadContextHelper;
    }

    protected ComponentImpl() {
    }

    protected BeanContextServices getBeanContextServices() {
        return (BeanContextServices)this.getBeanContext();
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getState() {
        return this.state;
    }

    protected void setState(String string) throws PropertyVetoException, RuntimeError, RuntimeWarning, ConfigurationError, ConfigurationWarning {
        try {
            this.vetoableChangeSupport.fireVetoableChange("state", this.state, string);
        }
        catch (com.ibm.ws.exception.PropertyVetoException propertyVetoException) {
            Throwable throwable = propertyVetoException.getCause();
            if (throwable instanceof RuntimeWarning) {
                throw (RuntimeWarning)((Object)throwable);
            }
            if (throwable instanceof RuntimeError) {
                throw (RuntimeError)((Object)throwable);
            }
            if (throwable instanceof ConfigurationError) {
                throw (ConfigurationError)((Object)throwable);
            }
            if (throwable instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)((Object)throwable);
            }
            throw propertyVetoException;
        }
        String string2 = this.state;
        this.state = string;
        this.propertyChangeSupport.firePropertyChange("state", string2, this.state);
    }

    protected void setInitializationState(String string) throws ConfigurationError, ConfigurationWarning {
        try {
            this.setState(string);
        }
        catch (ConfigurationWarning configurationWarning) {
            throw configurationWarning;
        }
        catch (ConfigurationError configurationError) {
            throw configurationError;
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception);
        }
    }

    protected void setStartState(String string) throws RuntimeError, RuntimeWarning {
        try {
            this.setState(string);
        }
        catch (RuntimeError runtimeError) {
            throw runtimeError;
        }
        catch (RuntimeWarning runtimeWarning) {
            throw runtimeWarning;
        }
        catch (Exception exception) {
            throw new RuntimeError(exception);
        }
    }

    public void setBeanContext(BeanContext beanContext) throws PropertyVetoException {
        if (this.beanContext == beanContext) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange("beanContext", this.beanContext, beanContext);
        BeanContext beanContext2 = this.beanContext;
        this.beanContext = beanContext;
        this.propertyChangeSupport.firePropertyChange("beanContext", beanContext2, beanContext);
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        this.latchedAsynchronousException = null;
    }

    public void destroy() {
    }

    public void start() throws RuntimeWarning, RuntimeError {
        this.latchedAsynchronousException = null;
    }

    public void stop() {
    }

    protected Object getService(Class clazz) {
        try {
            return this.getBeanContextServices().getService(this, this, clazz, null, this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            return null;
        }
    }

    protected void releaseService(Object object) {
        if (object != null) {
            this.getBeanContextServices().releaseService(this, this, object);
        }
    }

    protected boolean addService(Class clazz) {
        return this.addService(clazz, this);
    }

    public boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        return this.getBeanContextServices().addService(clazz, beanContextServiceProvider);
    }

    public Object getService(BeanContextServices beanContextServices, Object object, Class clazz, Object object2) {
        return this;
    }

    public void releaseService(BeanContextServices beanContextServices, Object object, Object object2) {
    }

    public Iterator getCurrentServiceSelectors(BeanContextServices beanContextServices, Class clazz) {
        return null;
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
    }

    protected String getConfigId(EObject eObject) {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            if (mBeanFactory != null) {
                return mBeanFactory.getConfigId((Object)eObject);
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, (String)this.getClass().getName(), (String)"353");
        }
        return null;
    }

    protected void registerMBean(String string, RuntimeCollaborator runtimeCollaborator, String string2, EObject eObject, Properties properties) {
        String string3 = this.getConfigId(eObject);
        this.registerMBean(string, runtimeCollaborator, string2, string3, properties);
    }

    protected Set lookupMBeans(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(objectName, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.service((TraceComponent)tc, (String)"WSVR0402W", (Object)new Object[]{string, malformedObjectNameException});
            return null;
        }
    }

    protected void registerMBean(String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
        MBeanFactory mBeanFactory;
        if (string2 != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("name", string2);
        }
        if ((mBeanFactory = AdminServiceFactory.getMBeanFactory()) != null) {
            try {
                mBeanFactory.activateMBean(string, runtimeCollaborator, string3, null, properties);
            }
            catch (AdminException adminException) {
                Tr.service((TraceComponent)tc, (String)"WSVR0400W", (Object)new Object[]{string2, adminException});
            }
        }
    }

    protected void deregisterMBean(EObject eObject) {
        this.deregisterMBean(this.getConfigId(eObject));
    }

    protected void deregisterMBean(String string) {
        try {
            AdminServiceFactory.getMBeanFactory().deactivateMBean(string);
        }
        catch (AdminException adminException) {
            Tr.service((TraceComponent)tc, (String)"WSVR0401W", (Object)new Object[]{this.name, adminException});
        }
    }

    protected void deregisterMBeanViaQuery(String string) {
        Set set = this.lookupMBeans(string);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                try {
                    AdminServiceFactory.getMBeanFactory().deactivateMBean(objectName);
                }
                catch (AdminException adminException) {
                    Tr.service((TraceComponent)tc, (String)"WSVR0401W", (Object)new Object[]{this.name, adminException});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String expandVariable(String string) throws IllegalArgumentException {
        VariableMap variableMap = null;
        try {
            variableMap = (VariableMap)this.getService(VariableMap.class);
            String string2 = variableMap.expand(string);
            this.releaseService(variableMap);
            return string2;
        }
        catch (Throwable throwable) {
            this.releaseService(variableMap);
            throw throwable;
        }
    }

    public static Properties getProperties(Service service) {
        Properties properties = new Properties();
        EList eList = service.getProperties();
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                Property property = (Property)eList.get(i);
                properties.put(property.getName(), property.getValue());
            }
        }
        return properties;
    }

    public String toString() {
        return this.getName() + " [" + this.getClass() + "]";
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    private class _AsynchInitializer
    implements Runnable {
        final AsynchronousInitializer task;
        final boolean joinFlag;

        _AsynchInitializer(AsynchronousInitializer asynchronousInitializer, boolean bl) {
            this.task = asynchronousInitializer;
            this.joinFlag = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ComponentImpl.this.getThreadContextHelper().establishCredentials();
                this.task.run();
            }
            catch (ConfigurationWarning configurationWarning) {
                ComponentImpl.this.latchAsychronousException(configurationWarning);
            }
            catch (ConfigurationError configurationError) {
                ComponentImpl.this.latchAsychronousException(configurationError);
            }
            catch (RuntimeWarning runtimeWarning) {
                ComponentImpl.this.latchAsychronousException(runtimeWarning);
            }
            catch (RuntimeError runtimeError) {
                ComponentImpl.this.latchAsychronousException(runtimeError);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"250");
                ComponentImpl.this.latchAsychronousException(new RuntimeWarning(throwable));
            }
            finally {
                if (this.joinFlag) {
                    ComponentImpl.this.join.decrement();
                }
            }
        }
    }
}

