/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.csi.TimerTaskInfo;
import com.ibm.ws.management.tools.EJBTimersCommand;

public class CancelEJBTimersCommand
extends EJBTimersCommand {
    private static final TraceComponent tc = Tr.register((Class)CancelEJBTimersCommand.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ws.management.tools.CancelEJBTimersCommand";
    private static final String METHOD_CANCEL = "cancel";
    private Object[] ivCancelParams = new Object[2];
    private String[] ivCancelSignature = new String[2];
    private int ivNumTimersCancelled = 0;
    private int ivNumTimersFailed = 0;

    public CancelEJBTimersCommand() {
        this.ivCancelParams[0] = null;
        this.ivCancelParams[1] = new Boolean(true);
        this.ivCancelSignature[0] = "java.lang.String";
        this.ivCancelSignature[1] = "java.lang.Boolean";
    }

    public static void main(String[] stringArray) {
        System.exit(new CancelEJBTimersCommand().executeUtility(stringArray));
    }

    protected String getCommandName() {
        return "cancelEJBTimers";
    }

    protected int performCmdAction(TimerTaskInfo timerTaskInfo) {
        int n = 0;
        try {
            this.ivCancelParams[0] = timerTaskInfo.getTaskId();
            this.ivAdminClient.invoke(this.ivSchedulerMBean, METHOD_CANCEL, this.ivCancelParams, this.ivCancelSignature);
            n = this.issueTimerMessage(timerTaskInfo);
            ++this.ivNumTimersCancelled;
        }
        catch (Throwable throwable) {
            n = -3;
            this.issueCancelExceptionMessage(timerTaskInfo, throwable);
            ++this.ivNumTimersFailed;
        }
        return n;
    }

    protected void issueSummaryMessage() {
        String string = Integer.toString(this.ivNumTimersCancelled);
        this.issueMessage("CNTR9062I", new Object[]{string}, "{0} EJB Timer tasks cancelled");
        if (this.ivNumTimersFailed > 0) {
            String string2 = Integer.toString(this.ivNumTimersFailed);
            this.issueMessage("CNTR9063I", new Object[]{string2}, "{0} EJB Timer tasks failed to cancel");
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, "ADMU0211I: Error details may be seen in the file: {0}");
        }
    }

    protected void issueCancelExceptionMessage(TimerTaskInfo timerTaskInfo, Throwable throwable) {
        String string = timerTaskInfo.getTaskId();
        this.issueMessage("CNTR9064I", new Object[]{string}, "Failed to cancel EJB Timer : {0}");
        this.issueTimerMessage(timerTaskInfo);
        this.issueMessage("CNTR9065I", new Object[]{throwable.toString()}, "EJB Timer cancel failure caused by: {0}");
        Tr.error((TraceComponent)tc, (String)"CNTR9100E", (Object)throwable.toString());
        Tr.service((TraceComponent)tc, (String)"CNTR9100E", (Object)throwable);
    }
}

