/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cpi;

import com.ibm.ejs.persistence.CollectionFactory;
import com.ibm.ejs.persistence.EJSJDBCPersister;
import com.ibm.ejs.persistence.EnumerationFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.websphere.cpi.CPIException;
import com.ibm.websphere.cpi.Finder;
import com.ibm.websphere.cpi.Persister;
import com.ibm.websphere.cpi.PersisterConfigData;
import com.ibm.websphere.cpi.PersisterFactory;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.websphere.cpi.PersisterTx;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.ws.cpi.JDBCPersisterMetaDataImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JDBCPersisterFactoryImpl
implements PersisterFactory {
    private static TraceComponent tc = Tr.register((Class)JDBCPersisterFactoryImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ws.cpi.JDBCPersisterFactoryImpl";

    public Persister create(EJBConfigData eJBConfigData) throws CPIException {
        EJSJDBCPersister eJSJDBCPersister = null;
        PersisterConfigData persisterConfigData = eJBConfigData.getPersisterConfigData();
        Properties properties = persisterConfigData.getProperties();
        String string = (String)properties.get("DataSourceName");
        DataSource dataSource = null;
        try {
            EnterpriseBean enterpriseBean = eJBConfigData.getDeploymentData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"EJB : ", (Object)enterpriseBean);
            }
            if (!(enterpriseBean instanceof ContainerManagedEntity)) {
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"looking up data source", (Object)string);
            }
            if (string == null) {
                Tr.warning((TraceComponent)tc, (String)"DATASOURCE_NAME_NULL_CNTR0026W", (Object)eJBConfigData.getJ2EEName());
                throw new CPIException("Data source name is not specified.");
            }
            InitialContext initialContext = new InitialContext();
            dataSource = (DataSource)initialContext.lookup(string);
            JDBCPersisterMetaDataImpl jDBCPersisterMetaDataImpl = new JDBCPersisterMetaDataImpl(enterpriseBean, persisterConfigData, eJBConfigData.getClassLoader(), dataSource);
            eJSJDBCPersister = EJSJDBCPersister.create(jDBCPersisterMetaDataImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cpi.JDBCPersisterFactoryImpl.create", (String)"96", (Object)this);
            String string2 = "The bean's J2EEName is " + eJBConfigData.getJ2EEName() + ". The data source name is " + string + ".";
            Tr.warning((TraceComponent)tc, (String)"ERROR_STARTING_CMP_BEAN_CNTR0031W", (Object)new Object[]{eJBConfigData.getJ2EEName(), exception});
            Tr.warning((TraceComponent)tc, (String)"ERROR_CREATING_CMP_PERSISTER_CNTR0032W", (Object)string);
            throw new CPIException("Persister creation failed." + string2, (Throwable)exception);
        }
        return eJSJDBCPersister;
    }

    public Enumeration wrapResultsInEnumeration(PersisterTx persisterTx, PersisterHome persisterHome, Finder finder) throws RemoteException, FinderException {
        return EnumerationFactory.create(persisterTx, persisterHome, finder);
    }

    public Enumeration wrapResultsInEnumeration(PersisterTx persisterTx, PersisterHome persisterHome, Enumeration enumeration) throws RemoteException, FinderException {
        return EnumerationFactory.create(persisterTx, persisterHome, enumeration);
    }

    public Collection wrapResultsInCollection(PersisterTx persisterTx, PersisterHome persisterHome, Finder finder) throws RemoteException, FinderException {
        return CollectionFactory.create(persisterTx, persisterHome, finder);
    }

    public Collection wrapResultsInCollection(PersisterTx persisterTx, PersisterHome persisterHome, Collection collection) throws RemoteException, FinderException {
        return CollectionFactory.create(persisterTx, persisterHome, collection);
    }
}

