/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.IllegalOperationException;
import java.util.ArrayList;

final class BucketImpl
extends ArrayList
implements Bucket {
    private long hitCount = 0L;
    private static final TraceComponent tc = Tr.register((Class)BucketImpl.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final long serialVersionUID = -8739929064206657681L;

    BucketImpl() {
    }

    public Element findByKey(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Element element = (Element)this.get(i);
            if (!element.key.equals(object)) continue;
            ++this.hitCount;
            return element;
        }
        return null;
    }

    public Element insertByKey(Object object, Object object2) {
        Element element = new Element(object, object2);
        this.add(element);
        ++this.hitCount;
        return element;
    }

    public Element discardByKey(Object object) {
        int n = this.findIndexByKey(object);
        Element element = null;
        if (n != -1) {
            element = (Element)this.get(n);
            if (element.pinned > 0) {
                return null;
            }
            this.remove(n);
            ++this.hitCount;
        }
        return element;
    }

    public Element removeByKey(Object object) {
        return this.removeByKey(object, false);
    }

    public Element removeByKey(Object object, boolean bl) {
        int n = this.findIndexByKey(object);
        Element element = null;
        if (n != -1) {
            element = (Element)this.get(n);
            if (!bl && element.pinned > 0 || bl && element.pinned > 1) {
                throw new IllegalOperationException(object, element.pinned);
            }
            this.remove(n);
            ++this.hitCount;
        }
        return element;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    private int findIndexByKey(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Element element = (Element)this.get(i);
            if (!element.key.equals(object)) continue;
            return i;
        }
        return -1;
    }
}

